/*
 * Decompiled with CFR 0.152.
 */
package fr.imag.leibniz.jbool.operation.options;

import fr.imag.leibniz.jbool.operation.Operation;
import fr.imag.leibniz.jbool.operation.options.OperationOptions;
import fr.imag.leibniz.jbool.operation.options.OperationOptionsException;
import fr.imag.leibniz.jbool.operation.options.OptionsDialog;
import java.awt.Component;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public abstract class AbstractOperationOptions
implements OperationOptions {
    private Operation m_Operation = null;
    private Component m_Component = null;
    private boolean m_ComponentCreated = false;
    private Hashtable m_Options = null;

    public AbstractOperationOptions(Operation lOperation) {
        if (lOperation == null) {
            throw new IllegalArgumentException("null operation");
        }
        this.m_Operation = lOperation;
    }

    public final Operation getOperation() {
        return this.m_Operation;
    }

    public OptionsDialog getDialog() {
        return null;
    }

    public void readInputValues() throws OperationOptionsException {
        if (this.m_Options == null) {
            return;
        }
        Enumeration desKeys = this.m_Options.keys();
        while (desKeys.hasMoreElements()) {
            this.readOptionInputValue(desKeys.nextElement());
        }
    }

    public boolean checkInputvalue() {
        return true;
    }

    protected Component createComponent() {
        return null;
    }

    public final Component getComponent() {
        if (!this.m_ComponentCreated) {
            this.m_Component = this.createComponent();
            this.m_ComponentCreated = true;
        }
        return this.m_Component;
    }

    private void addOption(OptionDescriptor lOption) {
        if (lOption == null) {
            return;
        }
        if (this.m_Options == null) {
            this.m_Options = new Hashtable();
        }
        if (this.m_Options.containsKey(lOption.getKey())) {
            throw new IllegalArgumentException("Key already exists");
        }
        this.m_Options.put(lOption.getKey(), lOption);
    }

    protected void addOption(Object laCle, String leLabel, boolean laValeur) {
        this.addOption(new BooleanOptionDescriptor(laCle, leLabel, laValeur));
    }

    protected void addOption(Object laCle, String leLabel, int laValeur) {
        this.addOption(new IntegerOptionDescriptor(laCle, leLabel, laValeur));
    }

    protected void addOption(Object laCle, String leLabel, String laValeur) {
        this.addOption(new StringOptionDescriptor(laCle, leLabel, laValeur));
    }

    protected JComponent getOptionComponent(Object laKey) {
        JComponent[] desComponents = null;
        JComponent unResultat = null;
        JPanel unPanel = null;
        desComponents = this.getOptionComponents(laKey);
        switch (desComponents.length) {
            case 0: {
                break;
            }
            case 1: {
                unResultat = desComponents[0];
                break;
            }
            default: {
                unPanel = new JPanel();
                unPanel.setLayout(new BoxLayout(unPanel, 0));
                int i = 0;
                while (i < desComponents.length) {
                    unPanel.add(desComponents[i]);
                    ++i;
                }
                unResultat = unPanel;
            }
        }
        return unResultat;
    }

    protected JComponent[] getOptionComponents(Object laKey) throws NoSuchElementException {
        OptionDescriptor uneOption = null;
        OptionInput unInput = null;
        if (this.m_Options != null) {
            uneOption = (OptionDescriptor)this.m_Options.get(laKey);
        }
        if (uneOption == null) {
            throw new NoSuchElementException(laKey.toString());
        }
        unInput = uneOption.getOptionInput();
        return unInput.getInputComponents();
    }

    protected JComponent getOptionsComponent(Object[] lesKeys) {
        return null;
    }

    private Object getOptionValue(Object laKey) throws NoSuchElementException {
        OptionDescriptor uneOption = null;
        if (this.m_Options != null) {
            uneOption = (OptionDescriptor)this.m_Options.get(laKey);
        }
        if (uneOption == null) {
            throw new NoSuchElementException(laKey.toString());
        }
        return uneOption.getValue();
    }

    protected boolean getBooleanOptionValue(Object laKey) {
        Boolean unBoolean = (Boolean)this.getOptionValue(laKey);
        return unBoolean;
    }

    protected int getIntegerOptionValue(Object laKey) {
        Integer unInteger = (Integer)this.getOptionValue(laKey);
        return unInteger;
    }

    protected String getStringOptionValue(Object laKey) {
        return (String)this.getOptionValue(laKey);
    }

    protected void setOptionValue(Object laKey, Object laValeur) throws NoSuchElementException {
        OptionDescriptor uneOption = null;
        if (this.m_Options != null) {
            uneOption = (OptionDescriptor)this.m_Options.get(laKey);
        }
        if (uneOption == null) {
            throw new NoSuchElementException(laKey.toString());
        }
        uneOption.setValue(laValeur);
    }

    protected Object getOptionInputValue(Object laKey) throws NoSuchElementException {
        OptionDescriptor uneOption = null;
        OptionInput unInput = null;
        if (this.m_Options != null) {
            uneOption = (OptionDescriptor)this.m_Options.get(laKey);
        }
        if (uneOption == null) {
            throw new NoSuchElementException(laKey.toString());
        }
        unInput = uneOption.getOptionInput();
        return unInput.getInputValue();
    }

    protected void readOptionInputValue(Object laKey) throws NoSuchElementException {
        this.setOptionValue(laKey, this.getOptionInputValue(laKey));
    }

    private interface OptionInput {
        public JComponent[] getInputComponents();

        public Object getInputValue();
    }

    private abstract class OptionDescriptor {
        private Object m_Key;
        private String m_Label;
        private Object m_Value;

        public OptionDescriptor(Object laKey, String leLabel, Object laValue) {
            if (laKey == null) {
                throw new IllegalArgumentException("null key");
            }
            this.m_Key = laKey;
            this.m_Label = leLabel;
            this.setValue(laValue);
        }

        public final Object getKey() {
            return this.m_Key;
        }

        public final String getLabel() {
            return this.m_Label;
        }

        public final Object getValue() {
            return this.m_Value;
        }

        public void setValue(Object laValue) {
            if (laValue == null) {
                throw new IllegalArgumentException("null value");
            }
            this.checkValue(laValue);
            this.m_Value = laValue;
        }

        public abstract OptionInput getOptionInput();

        protected abstract void checkValue(Object var1);
    }

    private class BooleanOptionDescriptor
    extends OptionDescriptor
    implements OptionInput {
        private JCheckBox m_CheckBox = null;

        public BooleanOptionDescriptor(Object laKey, String leLabel, boolean laValue) {
            super(laKey, leLabel, new Boolean(laValue));
            this.m_CheckBox = new JCheckBox(leLabel, laValue);
        }

        public OptionInput getOptionInput() {
            return this;
        }

        protected void checkValue(Object laValue) {
            if (!(laValue instanceof Boolean)) {
                throw new IllegalArgumentException(laValue.getClass().getName());
            }
        }

        public JComponent[] getInputComponents() {
            return new JComponent[]{this.m_CheckBox};
        }

        public Object getInputValue() {
            return new Boolean(this.m_CheckBox.isSelected());
        }
    }

    private class IntegerOptionDescriptor
    extends OptionDescriptor
    implements OptionInput {
        private JTextField m_TextField = null;

        public IntegerOptionDescriptor(Object laKey, String leLabel, int laValue) {
            super(laKey, leLabel, new Integer(laValue));
            this.m_TextField = new JTextField(String.valueOf(laValue), 8);
        }

        public OptionInput getOptionInput() {
            return this;
        }

        protected void checkValue(Object laValue) {
            if (!(laValue instanceof Integer)) {
                throw new IllegalArgumentException(laValue.getClass().getName());
            }
        }

        public JComponent[] getInputComponents() {
            return new JComponent[]{new JLabel(this.getLabel()), this.m_TextField};
        }

        public Object getInputValue() {
            String unText = null;
            Integer unNombre = null;
            unText = this.m_TextField.getText();
            try {
                unNombre = Integer.valueOf(unText);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            return unNombre;
        }
    }

    private class StringOptionDescriptor
    extends OptionDescriptor
    implements OptionInput {
        private JTextField m_TextField = null;

        public StringOptionDescriptor(Object laKey, String leLabel, String laValue) {
            super(laKey, leLabel, laValue);
            this.m_TextField = new JTextField(laValue, 8);
        }

        public OptionInput getOptionInput() {
            return this;
        }

        protected void checkValue(Object laValue) {
            if (!(laValue instanceof String)) {
                throw new IllegalArgumentException(laValue.getClass().getName());
            }
        }

        public JComponent[] getInputComponents() {
            return new JComponent[]{new JLabel(this.getLabel()), this.m_TextField};
        }

        public Object getInputValue() {
            String unText = null;
            unText = this.m_TextField.getText();
            return unText;
        }
    }
}

