/*
 * Decompiled with CFR 0.152.
 */
package fr.imag.leibniz.jbool.operation;

import fr.imag.leibniz.jbool.operation.Operation;

public class OperationTree {
    private static OperationTree m_Separator = null;
    private int m_ID = 0;
    private Operation m_Operation = null;
    private String m_Label = null;
    private OperationTree[] m_Children = null;

    public OperationTree(Operation lOperation) {
        this(0, lOperation);
    }

    public OperationTree(int lID, Operation lOperation) {
        this(lID);
        if (lOperation == null) {
            throw new IllegalArgumentException("null operation");
        }
        this.m_Operation = lOperation;
    }

    public OperationTree(String leLabel, OperationTree[] lesChildren) {
        this(0, leLabel, lesChildren);
    }

    public OperationTree(int lID, String leLabel, OperationTree[] lesChildren) {
        this(lID);
        if (leLabel == null) {
            throw new IllegalArgumentException("null label");
        }
        this.m_Label = leLabel;
        this.m_Children = lesChildren;
    }

    public OperationTree(String leLabel, OperationTree leChild) {
        this(0, leLabel, leChild);
    }

    public OperationTree(int lID, String leLabel, OperationTree leChild) {
        this(lID, leLabel, new OperationTree[]{leChild});
    }

    public OperationTree(int lID, String leLabel) {
        this(lID, leLabel, new OperationTree[0]);
    }

    private OperationTree(int lID) {
        this.m_ID = lID;
    }

    public static OperationTree getSeparator() {
        if (m_Separator == null) {
            m_Separator = new OperationTree(0);
        }
        return m_Separator;
    }

    public static OperationTree createFlatTree(String leLabel, Operation[] lesOperations) {
        return OperationTree.createFlatTree(0, leLabel, lesOperations);
    }

    public static OperationTree createFlatTree(int lID, String leLabel, Operation[] lesOperations) {
        OperationTree[] desFils = null;
        desFils = OperationTree.createForest(lesOperations);
        return desFils == null ? null : new OperationTree(lID, leLabel, desFils);
    }

    private static OperationTree[] createForest(Operation[] lesOperations) {
        OperationTree[] uneListe = null;
        Operation uneOperation = null;
        if (lesOperations != null) {
            uneListe = new OperationTree[lesOperations.length];
            int i = 0;
            while (i < lesOperations.length) {
                uneOperation = lesOperations[i];
                uneListe[i] = uneOperation == null ? OperationTree.getSeparator() : new OperationTree(uneOperation);
                ++i;
            }
        }
        return uneListe;
    }

    public int getID() {
        return this.m_ID;
    }

    public Operation getOperation() {
        return this.m_Operation;
    }

    public String getLabel() {
        return this.m_Operation == null ? this.m_Label : this.m_Operation.getName();
    }

    public OperationTree[] getChildren() {
        return this.m_Children;
    }
}

