/*
 * Decompiled with CFR 0.152.
 */
package fr.imag.leibniz.jbool.operation;

import fr.imag.leibniz.jbool.BooleanFunction;
import fr.imag.leibniz.jbool.gui.MainWindow;
import fr.imag.leibniz.jbool.operation.Operation;
import fr.imag.leibniz.jbool.operation.OperationResult;
import fr.imag.leibniz.jbool.operation.options.OperationOptions;
import fr.imag.leibniz.jbool.operation.options.OperationOptionsException;
import fr.imag.leibniz.jbool.operation.options.OptionsDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;

public class OperationAction
extends AbstractAction {
    private Operation m_Operation = null;
    private OperationOptions m_Options = null;
    private static BooleanFunction m_choice;

    public OperationAction(Operation lOperation) {
        if (lOperation == null) {
            throw new IllegalArgumentException("null operation");
        }
        this.m_Operation = lOperation;
        this.m_Operation.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                OperationAction.this.updateProperties(e.getPropertyName());
            }
        });
        this.updateProperties(null);
    }

    protected void updateProperties(String laProperty) {
        if (laProperty == null || laProperty.equals("PropertyName") || laProperty.equals("PropertyHasOptions")) {
            String unNom = this.m_Operation.getName();
            if (unNom != null && this.m_Operation.getHasOptions()) {
                unNom = String.valueOf(unNom) + "...";
            }
            this.putValue("Name", unNom);
        }
        if (laProperty == null || laProperty.equals("PropertyDescription")) {
            this.putValue("LongDescription", this.m_Operation.getDescription());
        }
        if (laProperty == null || laProperty.equals("PropertyIsEnabled")) {
            this.setEnabled(this.m_Operation.getIsEnabled());
        }
    }

    public Operation getOperation() {
        return this.m_Operation;
    }

    public JButton createButton() {
        String unNom = (String)this.getValue("Name");
        JButton unBouton = new JButton(unNom);
        unBouton.addActionListener(this);
        return unBouton;
    }

    public void actionPerformed(ActionEvent e) {
        this.runOperation();
    }

    private final void runOperation() {
        String op;
        OperationResult unResultat = null;
        if (this.m_Options == null) {
            this.m_Options = this.m_Operation.getDefaultOptions();
        }
        if ((op = this.m_Operation.getName()) == "Union" || op == "Product") {
            new ChoiceDialog(op);
        } else {
            if (this.displayOptions(this.m_Options)) {
                unResultat = this.m_Operation.run(this.m_Options);
            }
            if (unResultat != null) {
                this.useResult(unResultat);
            }
        }
    }

    protected void useResult(OperationResult leResultat) {
        String unMessage = null;
        Object unObject = null;
        if (leResultat == null) {
            return;
        }
        unMessage = leResultat.getMessage();
        unObject = leResultat.getResult();
        if (unMessage != null) {
            unObject = unObject != null ? new Object[]{unMessage, unObject} : unMessage;
        }
        if (unObject != null) {
            JOptionPane.showMessageDialog(null, unObject, this.m_Operation.getName(), 1);
        }
    }

    protected final boolean displayOptions(OperationOptions lesOptions) {
        OptionsDialog unDialog = null;
        if (lesOptions != null && (unDialog = lesOptions.getDialog()) == null) {
            unDialog = new DefaultOptionsDialog(null, lesOptions.getOperation().getName(), lesOptions);
        }
        return unDialog == null ? true : unDialog.displayDialog();
    }

    public static BooleanFunction getBooleanFunction() {
        return m_choice;
    }

    protected class DefaultOptionsDialog
    extends JDialog
    implements OptionsDialog {
        private OperationOptions m_Options = null;
        private boolean m_Valide = false;

        public DefaultOptionsDialog(Frame leParent, String leTitre, OperationOptions lesOptions) {
            super(leParent, leTitre, true);
            if (lesOptions == null) {
                throw new IllegalArgumentException("null options");
            }
            this.m_Options = lesOptions;
        }

        public boolean displayDialog() {
            Component unComponent = null;
            Component desBoutons = null;
            unComponent = this.m_Options.getComponent();
            if (unComponent == null) {
                return true;
            }
            desBoutons = this.createButtonRow();
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add(unComponent, "Center");
            if (desBoutons != null) {
                this.getContentPane().add(desBoutons, "South");
            }
            this.pack();
            Toolkit tk = Toolkit.getDefaultToolkit();
            Dimension ScreenSize = tk.getScreenSize();
            this.setLocation(ScreenSize.width / 2 - this.getWidth() / 2, ScreenSize.height / 2 - this.getHeight() / 2);
            this.setVisible(true);
            return this.m_Valide;
        }

        protected void onOK() {
            try {
                this.m_Options.readInputValues();
                this.m_Valide = true;
                this.dispose();
            }
            catch (OperationOptionsException e) {
                JOptionPane.showMessageDialog(this, e, "Error", 0);
            }
        }

        protected void onCancel() {
            this.dispose();
        }

        protected Component createButtonRow() {
            JButton unBouton = null;
            JPanel unPanel = null;
            unPanel = new JPanel();
            unPanel.setLayout(new BoxLayout(unPanel, 0));
            unBouton = new JButton("OK");
            unBouton.addActionListener(new ActionListener(this){
                final /* synthetic */ DefaultOptionsDialog this$1;
                {
                    this.this$1 = defaultOptionsDialog;
                }

                public void actionPerformed(ActionEvent e) {
                    this.this$1.onOK();
                }
            });
            unPanel.add(unBouton);
            unBouton = new JButton("Cancel");
            unBouton.addActionListener(new ActionListener(this){
                final /* synthetic */ DefaultOptionsDialog this$1;
                {
                    this.this$1 = defaultOptionsDialog;
                }

                public void actionPerformed(ActionEvent e) {
                    this.this$1.onCancel();
                }
            });
            unPanel.add(unBouton);
            return unPanel;
        }
    }

    public class ChoiceDialog
    extends JDialog
    implements ActionListener {
        private JButton b_Ok;
        private JButton b_Cancel;
        private LinkedList items = new LinkedList();

        public ChoiceDialog(String op) {
            JPanel unComponent = new JPanel();
            JScrollPane unScrollPane = new JScrollPane(unComponent);
            Box boxVertical = Box.createVerticalBox();
            this.getContentPane().add(unScrollPane);
            unComponent.add(boxVertical);
            boxVertical.add(new JLabel("Choose 1 function for the " + op + " : "));
            boxVertical.add(Box.createVerticalStrut(10));
            int nb = MainWindow.getFunctionsList().size();
            int i = 0;
            while (i < nb) {
                boxVertical.add(Box.createVerticalStrut(2));
                this.items.add(new JCheckBox(MainWindow.getBooleanFunction(i).getName()));
                boxVertical.add((JCheckBox)this.items.get(this.items.size() - 1));
                ++i;
            }
            this.setTitle(op);
            this.setSize(300, 400);
            Toolkit tk = Toolkit.getDefaultToolkit();
            Dimension dimEcran = tk.getScreenSize();
            this.setLocation(dimEcran.width / 2 - this.getWidth() / 2, dimEcran.height / 2 - this.getHeight() / 2);
            JToolBar toolBar = new JToolBar();
            this.b_Ok = new JButton("Ok");
            this.b_Cancel = new JButton("Cancel");
            this.getContentPane().add((Component)toolBar, "South");
            toolBar.setFloatable(false);
            this.b_Ok.setMaximumSize(new Dimension(50, 27));
            this.b_Ok.setPreferredSize(new Dimension(50, 27));
            this.b_Cancel.setMaximumSize(new Dimension(65, 27));
            this.b_Cancel.setPreferredSize(new Dimension(65, 27));
            this.b_Ok.addActionListener(this);
            this.b_Cancel.addActionListener(this);
            toolBar.add(this.b_Ok);
            toolBar.add(this.b_Cancel);
            this.setResizable(false);
            this.setVisible(true);
        }

        public void actionPerformed(ActionEvent ev) {
            if (ev.getSource() == this.b_Ok) {
                int m_compteur = 0;
                int i = 0;
                while (i < this.items.size() && m_compteur < 2) {
                    JCheckBox jtb = (JCheckBox)this.items.get(i);
                    if (jtb.isSelected() && ++m_compteur < 2) {
                        m_choice = (BooleanFunction)MainWindow.getFunctionsList().get(i);
                    }
                    ++i;
                }
                if (m_compteur == 1) {
                    OperationResult unResultat = OperationAction.this.m_Operation.run(OperationAction.this.m_Options);
                    if (unResultat != null) {
                        OperationAction.this.useResult(unResultat);
                    }
                    this.dispose();
                } else {
                    JFrame resultWindow = new JFrame();
                    JOptionPane.showMessageDialog(resultWindow, "1 function must be selected", "Invalid selection", 2);
                }
            } else if (ev.getSource() == this.b_Cancel) {
                this.dispose();
            }
        }
    }
}

