/*
 * Decompiled with CFR 0.152.
 */
package fr.imag.leibniz.jbool.gui;

import fr.imag.leibniz.jbool.BooleanFunction;
import fr.imag.leibniz.jbool.function.OpenFunction;
import fr.imag.leibniz.jbool.function.RandomCreation;
import fr.imag.leibniz.jbool.function.Threshold;
import fr.imag.leibniz.jbool.gui.BooleanFunctionInput;
import fr.imag.leibniz.jbool.gui.BooleanFunctionView;
import fr.imag.leibniz.jbool.gui.HelpPanel;
import fr.imag.leibniz.jbool.operation.AbstractBooleanOperation;
import fr.imag.leibniz.jbool.operation.BooleanOperation;
import fr.imag.leibniz.jbool.operation.BooleanOperationResult;
import fr.imag.leibniz.jbool.operation.Operation;
import fr.imag.leibniz.jbool.operation.OperationAction;
import fr.imag.leibniz.jbool.operation.OperationResult;
import fr.imag.leibniz.jbool.operation.OperationTree;
import fr.imag.leibniz.jbool.operation.options.OperationOptions;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.util.LinkedList;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;

public class MainWindow
extends JFrame
implements WindowListener {
    public static final String PROPERTY_CURRENT_FUNCTION = "fr.imag.leibniz.jbool.gui.MainWindow.CurrentFunction";
    private static MainWindow g_CurrentWindow = null;
    private PropertyChangeSupport m_Properties = null;
    private InternalFrameListener m_FrameListener = new FrameListener();
    private JDesktopPane m_Desktop = null;
    private BooleanFunctionInput m_TextZone;
    private BooleanFunctionView m_BooleanFunctionView;
    private int shiftBooleanFrame = 0;
    private static LinkedList listFunctions = new LinkedList();
    private BooleanFunction m_CurrentFunction = null;
    private MutableTreeNode m_Arbre = null;

    public MainWindow(String leTitle) {
        super(leTitle);
        JTree unArbre = null;
        JComponent unContenu = null;
        this.m_Properties = new PropertyChangeSupport(this);
        this.m_Arbre = this.createFunctionTree();
        this.m_Desktop = this.createDesktopPane();
        this.updateMenuBar(null);
        unArbre = this.createTree(this.m_Arbre);
        if (unArbre != null) {
            JSplitPane unSplit = new JSplitPane();
            unSplit.setLeftComponent(new JScrollPane(unArbre));
            unSplit.setRightComponent(this.m_Desktop);
            unContenu = unSplit;
        } else {
            unContenu = this.m_Desktop;
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)unContenu, "Center");
        this.m_TextZone = new BooleanFunctionInput(this);
        this.getContentPane().add((Component)this.m_TextZone, "North");
        this.pack();
        this.m_Desktop.setBackground(new Color(10, 0, 220));
        g_CurrentWindow = this;
        this.addWindowListener(this);
        this.setDefaultCloseOperation(0);
        this.setSize(800, 600);
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension ScreenSize = tk.getScreenSize();
        this.setLocation(ScreenSize.width / 2 - this.getWidth() / 2, ScreenSize.height / 2 - this.getHeight() / 2);
    }

    protected MutableTreeNode createFunctionTree() {
        return new DefaultMutableTreeNode();
    }

    protected JTree createTree(MutableTreeNode leNoeud) {
        return null;
    }

    protected JDesktopPane createDesktopPane() {
        return new JDesktopPane();
    }

    public static MainWindow getCurrentWindow() {
        return g_CurrentWindow;
    }

    public final void addPropertyChangeListener(PropertyChangeListener leListener) {
        this.m_Properties.addPropertyChangeListener(leListener);
    }

    public final void addPropertyChangeListener(String strPropertyName, PropertyChangeListener leListener) {
        this.m_Properties.addPropertyChangeListener(strPropertyName, leListener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener leListener) {
        this.m_Properties.removePropertyChangeListener(leListener);
    }

    public final void removePropertyChangeListener(String strPropertyName, PropertyChangeListener leListener) {
        this.m_Properties.removePropertyChangeListener(strPropertyName, leListener);
    }

    protected final boolean hasListeners(String strPropertyName) {
        return this.m_Properties.hasListeners(strPropertyName);
    }

    protected final void firePropertyChange(PropertyChangeEvent lEvenement) {
        this.m_Properties.firePropertyChange(lEvenement);
    }

    private void setCurrentFunction(BooleanFunction laFonction) {
        PropertyChangeEvent unEvenement = null;
        unEvenement = new PropertyChangeEvent(this, PROPERTY_CURRENT_FUNCTION, this.m_CurrentFunction, laFonction);
        this.m_CurrentFunction = laFonction;
        this.updateMenuBar(laFonction);
        this.firePropertyChange(unEvenement);
    }

    protected void updateMenuBar(BooleanFunction laFunction) {
        this.setJMenuBar(this.createMenuBar(laFunction));
        this.validate();
    }

    protected JMenuBar createMenuBar(BooleanFunction laFunction) {
        JMenuBar uneBar = new JMenuBar();
        JMenu unFileMenu = null;
        JMenu unEditMenu = null;
        JMenu unHelpMenu = null;
        JMenu unMenu = null;
        JMenuItem unItem = null;
        OperationTree unOperationTree = null;
        OperationTree[] desFils = null;
        unFileMenu = new JMenu("File");
        uneBar.add(unFileMenu);
        unItem = this.addOperation(unFileMenu, new AbstractBooleanOperation("New", null, 1, false){

            public OperationResult run(OperationOptions lesOptions) {
                return this.createResult(new BooleanFunction());
            }

            public String getGeneratedName(String leNomOriginal) {
                return leNomOriginal;
            }

            public KeyStroke getAccelerator() {
                return KeyStroke.getKeyStroke(78, 2);
            }
        });
        this.addOperation(unFileMenu, new OpenFunction());
        this.addOperation(unFileMenu, new RandomCreation());
        this.addOperation(unFileMenu, new Threshold());
        unEditMenu = new JMenu("Edit");
        uneBar.add(unEditMenu);
        JMenuItem unUndoItem = new JMenuItem("Undo");
        unUndoItem.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        unEditMenu.add(unUndoItem).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
            }
        });
        JMenuItem unCutItem = new JMenuItem("Cut");
        unCutItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        unEditMenu.add(unCutItem).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainWindow.this.m_TextZone.getTextZone().cut();
            }
        });
        JMenuItem unCopyItem = new JMenuItem("Copy");
        unCopyItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        unEditMenu.add(unCopyItem).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String s = MainWindow.this.m_TextZone.getTextZone().getSelectedText();
                if (s != null) {
                    MainWindow.this.m_TextZone.getTextZone().copy();
                }
            }
        });
        JMenuItem unPasteItem = new JMenuItem("Paste");
        unPasteItem.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        unEditMenu.add(unPasteItem).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainWindow.this.m_TextZone.getTextZone().paste();
            }
        });
        JMenuItem unClearItem = new JMenuItem("Clear");
        unClearItem.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        unEditMenu.add(unClearItem).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainWindow.this.m_TextZone.getTextZone().getSelectedText();
                int posDebSelect = MainWindow.this.m_TextZone.getTextZone().getSelectionStart();
                int posFinSelect = MainWindow.this.m_TextZone.getTextZone().getSelectionEnd();
                MainWindow.this.m_TextZone.getTextZone().setText(String.valueOf(MainWindow.this.m_TextZone.getSelectedText(0, posDebSelect)) + MainWindow.this.m_TextZone.getSelectedText(posFinSelect, MainWindow.this.m_TextZone.getTextZone().getText().length() - posFinSelect));
                MainWindow.this.m_TextZone.getTextZone().setCaretPosition(posDebSelect);
            }

            public KeyStroke getAccelerator() {
                return KeyStroke.getKeyStroke(127, 0);
            }
        });
        JMenuItem unSelectAllItem = new JMenuItem("Select All");
        unSelectAllItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        unEditMenu.add(unSelectAllItem).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainWindow.this.m_TextZone.getTextZone().selectAll();
            }

            public KeyStroke getAccelerator() {
                return KeyStroke.getKeyStroke(65, 2);
            }
        });
        unHelpMenu = new JMenu("Help");
        unItem = unHelpMenu.add("Help");
        unItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainWindow.this.displayHelpFrame();
            }
        });
        unItem.setAccelerator(KeyStroke.getKeyStroke(156, 0));
        if (laFunction != null) {
            unOperationTree = laFunction.getOperationTree();
        }
        if (unOperationTree != null) {
            desFils = unOperationTree.getChildren();
        }
        if (desFils != null) {
            int i = 0;
            while (i < desFils.length) {
                unOperationTree = desFils[i];
                if (unOperationTree != null) {
                    switch (unOperationTree.getID()) {
                        case 1: {
                            unMenu = unFileMenu;
                            break;
                        }
                        case 2: {
                            unMenu = unEditMenu;
                            break;
                        }
                        default: {
                            unMenu = new JMenu(unOperationTree.getLabel());
                            uneBar.add(unMenu);
                        }
                    }
                    this.addOperationTree(unMenu, unOperationTree, true);
                }
                ++i;
            }
        }
        unFileMenu.addSeparator();
        unFileMenu.add("Forced close").addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainWindow.this.dispose();
            }
        });
        JMenuItem unQuitItem = new JMenuItem("Quit");
        unFileMenu.add(unQuitItem).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFrame alertWindow = new JFrame();
                Object[] choice = new String[]{"Yes", "No"};
                int rang = JOptionPane.showOptionDialog(alertWindow, "Are you sure you \n want to quit JBool ?", "Close Message", 1, 3, null, choice, choice[1]);
                if (rang == 0) {
                    MainWindow.this.dispose();
                }
            }
        });
        unQuitItem.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        uneBar.add(unHelpMenu);
        return uneBar;
    }

    protected Action[] createEditActions() {
        return null;
    }

    protected final JMenuItem addOperation(JMenu leMenu, BooleanOperation lOperation) {
        KeyStroke unAccelerator = null;
        JMenuItem unItem = null;
        unAccelerator = lOperation.getAccelerator();
        unItem = leMenu.add(new BooleanAction(lOperation));
        if (unAccelerator != null) {
            unItem.setAccelerator(unAccelerator);
        }
        return unItem;
    }

    protected final void addOperationTree(JMenu leMenu, OperationTree leTree, boolean leAddSeparator) {
        OperationTree[] desFils = null;
        OperationTree unFils = null;
        Operation uneOperation = null;
        JMenu unSubMenu = null;
        String unText = null;
        if (leMenu == null || leTree == null) {
            return;
        }
        desFils = leTree.getChildren();
        if (desFils == null) {
            return;
        }
        if (leAddSeparator) {
            leAddSeparator = leMenu.getItemCount() > 0;
        }
        int i = 0;
        while (i < desFils.length) {
            unFils = desFils[i];
            if (unFils != null) {
                if (leAddSeparator) {
                    leMenu.addSeparator();
                    leAddSeparator = false;
                }
                if ((uneOperation = unFils.getOperation()) == null) {
                    unText = unFils.getLabel();
                    if (unText == null) {
                        leMenu.addSeparator();
                    } else {
                        unSubMenu = new JMenu(unText);
                        this.addOperationTree(unSubMenu, unFils, false);
                        leMenu.add(unSubMenu).setEnabled(unSubMenu.getItemCount() > 0);
                    }
                } else {
                    this.addOperation(leMenu, (BooleanOperation)uneOperation);
                }
            }
            ++i;
        }
    }

    protected void displayHelpFrame() {
        JInternalFrame uneFrame = new JInternalFrame("Help window", true, true, true, true);
        uneFrame.getContentPane().setLayout(new BorderLayout());
        uneFrame.getContentPane().add((Component)new HelpPanel(this.getClass().getResource("Help/intro.html")), "Center");
        uneFrame.pack();
        uneFrame.setSize(450, 300);
        this.m_Desktop.add(uneFrame);
        try {
            uneFrame.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        uneFrame.setVisible(true);
    }

    public void displayFunction(BooleanFunction uneFunction) {
        BooleanFrame uneFrame = null;
        if (uneFunction == null) {
            return;
        }
        uneFrame = new BooleanFrame(uneFunction);
        this.m_Desktop.add(uneFrame);
        uneFrame.setDefaultCloseOperation(0);
        try {
            uneFrame.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        uneFrame.setVisible(true);
    }

    public BooleanFunction getSelectedFunction() {
        BooleanFrame uneFrame = null;
        uneFrame = this.getSelectedFrame();
        return uneFrame == null ? null : uneFrame.getBooleanFunction();
    }

    public BooleanFrame getSelectedFrame() {
        BooleanFrame uneFrame = null;
        try {
            uneFrame = (BooleanFrame)this.m_Desktop.getSelectedFrame();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return uneFrame;
    }

    public void windowClosing(WindowEvent ev) {
        JFrame alertWindow = new JFrame();
        Object[] choice = new String[]{"Yes", "No"};
        int rang = JOptionPane.showOptionDialog(alertWindow, "Are you sure you \n want to quit JBool?", "Close Message", 1, 3, null, choice, choice[1]);
        if (rang == 0) {
            this.dispose();
        }
    }

    public void windowActivated(WindowEvent ev) {
    }

    public void windowDeactivated(WindowEvent ev) {
    }

    public void windowClosed(WindowEvent ev) {
    }

    public void windowOpened(WindowEvent ev) {
    }

    public void windowIconified(WindowEvent ev) {
    }

    public void windowDeiconified(WindowEvent ev) {
    }

    public static void addFunction(BooleanFunction m_Function) {
        listFunctions.add(m_Function);
    }

    public static void removeFunction(BooleanFunction m_Function) {
        listFunctions.remove(m_Function);
    }

    public static LinkedList getFunctionsList() {
        return listFunctions;
    }

    public static BooleanFunction getBooleanFunction(int i) {
        return (BooleanFunction)listFunctions.get(i);
    }

    protected class BooleanAction
    extends OperationAction {
        public BooleanAction(BooleanOperation lOperation) {
            super(lOperation);
        }

        protected void useResult(OperationResult leResultat) {
            Object unObjet = null;
            BooleanFunction uneFunction = null;
            if (leResultat != null && leResultat instanceof BooleanOperationResult) {
                uneFunction = ((BooleanOperationResult)leResultat).getFunction(false);
                MainWindow.this.displayFunction(uneFunction);
            } else {
                super.useResult(leResultat);
            }
        }
    }

    protected class BooleanFrame
    extends JInternalFrame {
        private BooleanFunction m_Function = null;

        public BooleanFrame(BooleanFunction uneFunction) {
            super(uneFunction.getName(), true, true, true, true);
            this.setLocation(MainWindow.this.shiftBooleanFrame * 28, MainWindow.this.shiftBooleanFrame * 28);
            MainWindow.this.shiftBooleanFrame = (10 + MainWindow.this.shiftBooleanFrame + 1) % 10;
            this.m_Function = uneFunction;
            this.m_Function.addPropertyChangeListener(new PropertyChangeListener(this){
                final /* synthetic */ BooleanFrame this$1;
                {
                    this.this$1 = booleanFrame;
                }

                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("fr.imag.leibniz.jbool.BooleanFunction.PropertyName")) {
                        this.this$1.setTitle(BooleanFrame.access$0(this.this$1).getName());
                    }
                }
            });
            Container container = this.getContentPane();
            BooleanFunctionView booleanFunctionView = new BooleanFunctionView(this.m_Function);
            MainWindow.this.m_BooleanFunctionView = booleanFunctionView;
            container.add(booleanFunctionView);
            this.pack();
            this.addInternalFrameListener(MainWindow.this.m_FrameListener);
            MainWindow.addFunction(uneFunction);
        }

        public BooleanFunction getBooleanFunction() {
            return this.m_Function;
        }

        static /* synthetic */ BooleanFunction access$0(BooleanFrame booleanFrame) {
            return booleanFrame.m_Function;
        }
    }

    protected class FrameListener
    extends InternalFrameAdapter
    implements Runnable {
        private BooleanFunction m_CurrentFunction = null;

        protected FrameListener() {
        }

        public void internalFrameActivated(InternalFrameEvent e) {
            this.update(e, true);
        }

        public void internalFrameDeactivated(InternalFrameEvent e) {
            this.update(e, false);
        }

        public void internalFrameClosed(InternalFrameEvent e) {
            this.update(e, false);
        }

        public void run() {
            MainWindow.this.setCurrentFunction(this.m_CurrentFunction);
        }

        private void update(InternalFrameEvent e, boolean bNew) {
            BooleanFunction uneFunction = null;
            boolean bNeedsUpdate = false;
            uneFunction = ((BooleanFrame)e.getSource()).getBooleanFunction();
            if (bNew) {
                boolean bl = bNeedsUpdate = this.m_CurrentFunction != uneFunction;
                if (bNeedsUpdate) {
                    this.m_CurrentFunction = uneFunction;
                }
            } else {
                boolean bl = bNeedsUpdate = this.m_CurrentFunction == uneFunction;
                if (bNeedsUpdate) {
                    this.m_CurrentFunction = null;
                }
            }
            SwingUtilities.invokeLater(this);
        }

        public void internalFrameClosing(InternalFrameEvent e) {
            try {
                e.getInternalFrame().setSelected(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            JFrame alertWindow = new JFrame();
            Object[] choice = new String[]{"Yes", "No"};
            int rang = JOptionPane.showOptionDialog(alertWindow, "Are you sure you want to \n close the current window ?", "Close Message", 1, 3, null, choice, choice[1]);
            if (rang == 0) {
                MainWindow.removeFunction(MainWindow.this.getSelectedFrame().getBooleanFunction());
                MainWindow.this.getSelectedFrame().dispose();
            }
        }
    }
}

