/*
 * Decompiled with CFR 0.152.
 */
package fr.imag.leibniz.jbool.gui;

import fr.imag.leibniz.jbool.BooleanFunction;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.text.JTextComponent;

public class BooleanFunctionView
extends JPanel {
    private PropertyChangeListener m_oBooleanFunctionListener = null;
    private BooleanFunction m_oDisplayedFunction = null;
    private JTextComponent m_oValue = null;
    private ButtonModel m_oIsDisjonctive = null;
    private ButtonModel m_oIsConjonctive = null;
    private JLabel m_oGeneralOrPositive = null;
    private JTextComponent m_oTermCount = null;
    private JTextComponent m_oVarsetSize = null;
    private JTextComponent m_oVarset = null;

    public BooleanFunctionView() {
        this((BooleanFunction)null);
    }

    public BooleanFunctionView(BooleanFunction oFunction) {
        super(new GridBagLayout());
        this.initComponents();
        this.display(oFunction, true);
    }

    private synchronized void initComponents() {
        GridBagConstraints oConstraints = null;
        JTextArea oTextArea = null;
        JPanel oPanel = null;
        ButtonGroup oGroup = null;
        ActionListener oListener = null;
        JToggleButton oButton = null;
        oConstraints = this.createDefaultConstraints(1.0, 1.0, 8);
        oConstraints.gridwidth = 0;
        oTextArea = new JTextArea(4, 32);
        oTextArea.setEditable(false);
        oTextArea.setLineWrap(true);
        this.add((Component)new JScrollPane(oTextArea, 20, 30), oConstraints);
        this.m_oValue = oTextArea;
        this.m_oValue.setFocusable(false);
        oConstraints = this.createDefaultConstraints(0.0, 0.0, 2);
        oGroup = new ButtonGroup();
        oListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (BooleanFunctionView.this.m_oDisplayedFunction != null) {
                    BooleanFunctionView.this.m_oDisplayedFunction.changeNormalForm();
                }
            }
        };
        oButton = new JToggleButton("disjunctive");
        oButton.addActionListener(oListener);
        oGroup.add(oButton);
        this.m_oIsDisjonctive = oButton.getModel();
        this.add((Component)oButton, oConstraints);
        oButton = new JToggleButton("conjunctive");
        oButton.addActionListener(oListener);
        this.m_oIsConjonctive = oButton.getModel();
        oGroup.add(oButton);
        this.add((Component)oButton, oConstraints);
        oConstraints = this.createDefaultConstraints(0.0, 0.0, 2);
        oConstraints.anchor = 13;
        oConstraints.gridwidth = 0;
        this.m_oGeneralOrPositive = new JLabel();
        this.add((Component)this.m_oGeneralOrPositive, oConstraints);
        oPanel = new JPanel(new GridBagLayout());
        this.m_oTermCount = new JTextField(4);
        this.m_oTermCount.setEditable(false);
        this.m_oTermCount.setFocusable(false);
        oPanel.add(new JLabel("mF : "));
        oPanel.add((Component)this.m_oTermCount, this.createDefaultConstraints(0.0, 0.0, 2));
        this.m_oVarsetSize = new JTextField(4);
        this.m_oVarsetSize.setEditable(false);
        this.m_oVarsetSize.setFocusable(false);
        oPanel.add(new JLabel("nX : "));
        oPanel.add((Component)this.m_oVarsetSize, this.createDefaultConstraints(0.0, 0.0, 2));
        this.m_oVarset = new JTextField(16);
        this.m_oVarset.setEditable(false);
        this.m_oVarset.setFocusable(false);
        oPanel.add(new JLabel("Varset : "));
        oPanel.add((Component)this.m_oVarset, this.createDefaultConstraints(1.0, 0.0, 2));
        oConstraints = this.createDefaultConstraints(1.0, 0.0, 2);
        oConstraints.gridwidth = 0;
        this.add((Component)oPanel, oConstraints);
    }

    public String getStringSelection() {
        return this.m_oValue.getSelectedText();
    }

    public String getTextView() {
        return this.m_oValue.getText();
    }

    public JTextComponent getm_oValue() {
        return this.m_oValue;
    }

    private GridBagConstraints createDefaultConstraints(double fWeightX, double fWeightY, int nInset) {
        GridBagConstraints oResult = null;
        oResult = new GridBagConstraints();
        oResult.weightx = fWeightX > 0.0 ? fWeightX : 0.0;
        double d = oResult.weighty = fWeightY > 0.0 ? fWeightY : 0.0;
        if (fWeightX > 0.0) {
            oResult.fill = fWeightY > 0.0 ? 1 : 2;
        } else if (fWeightY > 0.0) {
            oResult.fill = 3;
        }
        if (nInset > 0) {
            oResult.insets = new Insets(nInset, nInset, nInset, nInset);
        }
        return oResult;
    }

    public void display(BooleanFunction oFunction, boolean bDynamic) {
        this.setDisplayedFunction(oFunction, bDynamic);
        this.update();
    }

    public void update() {
        this.update(this.m_oDisplayedFunction);
    }

    private void update(BooleanFunction oFunction) {
        if (oFunction != this.m_oDisplayedFunction) {
            throw new IllegalArgumentException();
        }
        if (this.m_oValue != null) {
            this.m_oValue.setText(oFunction == null ? "" : oFunction.toString());
        }
        if (this.m_oIsDisjonctive != null) {
            this.m_oIsDisjonctive.setSelected(oFunction == null ? false : !oFunction.isConjonctive());
        }
        if (this.m_oIsConjonctive != null) {
            this.m_oIsConjonctive.setSelected(oFunction == null ? false : oFunction.isConjonctive());
        }
        if (this.m_oGeneralOrPositive != null) {
            this.m_oGeneralOrPositive.setText(oFunction == null ? "" : (oFunction.isGeneral() ? "general" : "positive"));
        }
        if (this.m_oTermCount != null) {
            this.m_oTermCount.setText(oFunction == null ? "" : String.valueOf(oFunction.getTerms().length));
        }
        if (this.m_oVarsetSize != null || this.m_oVarset != null) {
            String strVarset = null;
            String string = strVarset = oFunction == null ? null : oFunction.getVariableSet();
            if (this.m_oVarsetSize != null) {
                this.m_oVarsetSize.setText(strVarset == null ? "0" : String.valueOf(strVarset.length()));
            }
            if (this.m_oVarset != null) {
                this.m_oVarset.setText(strVarset == null ? "" : strVarset);
            }
        }
        this.setEnabled(oFunction != null);
    }

    public void setEnabled(boolean bEnabled) {
        Component[] aChildren = null;
        super.setEnabled(bEnabled);
        aChildren = this.getComponents();
        if (aChildren == null) {
            return;
        }
        int i = 0;
        while (i < aChildren.length) {
            if (aChildren[i] != null) {
                aChildren[i].setEnabled(bEnabled);
            }
            ++i;
        }
    }

    private synchronized BooleanFunction setDisplayedFunction(BooleanFunction oFunction, boolean bDynamic) {
        BooleanFunction oPrevious = null;
        oPrevious = this.m_oDisplayedFunction;
        if (this.m_oDisplayedFunction != null && this.m_oBooleanFunctionListener != null) {
            this.m_oDisplayedFunction.removePropertyChangeListener(this.m_oBooleanFunctionListener);
        }
        this.m_oDisplayedFunction = oFunction;
        if (oFunction != null && bDynamic) {
            if (this.m_oBooleanFunctionListener == null) {
                this.m_oBooleanFunctionListener = new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent e) {
                        BooleanFunctionView.this.update();
                    }
                };
            }
            oFunction.addPropertyChangeListener(this.m_oBooleanFunctionListener);
        } else {
            this.m_oBooleanFunctionListener = null;
        }
        return oPrevious;
    }

    private static JFrame show(BooleanFunction oFunction) {
        JFrame oFrame = null;
        oFrame = new JFrame(oFunction == null ? "" : oFunction.getName());
        oFrame.getContentPane().add(new BooleanFunctionView(oFunction));
        oFrame.pack();
        oFrame.setVisible(true);
        return oFrame;
    }

    public static void main(String[] args) {
        BooleanFunctionView.show(BooleanFunction.createRandomFunction(15, 8, 4, false, false, false));
    }
}

