/*
 * Decompiled with CFR 0.152.
 */
package fr.imag.leibniz.jbool.function;

import fr.imag.leibniz.jbool.BooleanFunction;
import fr.imag.leibniz.jbool.Term;
import fr.imag.leibniz.jbool.operation.AbstractBooleanOperation;
import fr.imag.leibniz.jbool.operation.OperationResult;
import fr.imag.leibniz.jbool.operation.options.AbstractOperationOptions;
import fr.imag.leibniz.jbool.operation.options.OperationOptions;
import fr.imag.leibniz.jbool.operation.options.OperationOptionsException;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;

public class Threshold
extends AbstractBooleanOperation {
    static Class class$java$lang$String;
    static Class class$java$lang$Integer;

    public Threshold() {
        super("Threshold", null, 1, true);
    }

    public OperationResult run(OperationOptions lesOptions) {
        if (!(lesOptions instanceof Options)) {
            throw new IllegalArgumentException(lesOptions.getClass().getName());
        }
        int nThreshold = ((Options)lesOptions).getThreshold();
        int[] aCoefs = ((Options)lesOptions).getCoefs();
        return this.createResult(BooleanFunction.createThresholdFunction(nThreshold, aCoefs));
    }

    public OperationOptions getDefaultOptions() {
        return new Options();
    }

    public String getGeneratedName(String leNomOriginal) {
        return leNomOriginal;
    }

    static Class _mthclass$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private class Options
    extends AbstractOperationOptions {
        private ThresholdComponent m_oThresholdInput;
        private CoefComponent m_oCoefInput;
        private int m_nThreshold = 0;
        private int[] m_aCoefs = new int[1];

        public int getThreshold() {
            return this.m_nThreshold;
        }

        public int[] getCoefs() {
            return (int[])this.m_aCoefs.clone();
        }

        public void readInputValues() throws OperationOptionsException {
            this.m_nThreshold = this.m_oThresholdInput.getValue();
            this.m_aCoefs = this.m_oCoefInput.getCoefs();
        }

        protected Component createComponent() {
            JPanel unComponent = new JPanel();
            this.m_oThresholdInput = new ThresholdComponent(this.m_nThreshold);
            this.m_oCoefInput = new CoefComponent(this.m_aCoefs);
            unComponent.setLayout(new BoxLayout(unComponent, 1));
            unComponent.add(this.m_oThresholdInput);
            unComponent.add(this.m_oCoefInput);
            return unComponent;
        }

        public Options() {
            super(Threshold.this);
        }
    }

    private static class CoefComponent
    extends JPanel {
        private CoefModel m_oModel = null;
        private JSlider m_oSizeInput;
        private JLabel m_oSizeOutput;

        public int[] getCoefs() {
            return this.m_oModel.getCoefs();
        }

        public CoefComponent(int[] aInitialCoefs) {
            JTable oTable = null;
            JPanel oPanel = null;
            this.setLayout(new BorderLayout());
            this.m_oModel = new CoefModel(aInitialCoefs);
            this.m_oSizeOutput = new JLabel(Integer.toString(this.m_oModel.getSize()));
            this.m_oSizeInput = new JSlider(this.m_oModel.getMinimumSize(), this.m_oModel.getMaximumSize(), this.m_oModel.getSize());
            this.m_oSizeInput.addChangeListener(new ChangeListener(this){
                final /* synthetic */ CoefComponent this$1;
                {
                    this.this$1 = coefComponent;
                }

                public void stateChanged(ChangeEvent oEvent) {
                    CoefComponent.access$0(this.this$1).setSize(CoefComponent.access$1(this.this$1).getValue());
                }
            });
            this.m_oModel.addTableModelListener(new TableModelListener(this){
                final /* synthetic */ CoefComponent this$1;
                {
                    this.this$1 = coefComponent;
                }

                public void tableChanged(TableModelEvent e) {
                    CoefComponent.access$2(this.this$1).setText(Integer.toString(CoefComponent.access$0(this.this$1).getSize()));
                    CoefComponent.access$1(this.this$1).setValue(CoefComponent.access$0(this.this$1).getSize());
                }
            });
            oPanel = new JPanel(new BorderLayout());
            oPanel.add((Component)new JLabel("Number of variables : "), "West");
            oPanel.add((Component)this.m_oSizeOutput, "East");
            oPanel.add((Component)this.m_oSizeInput, "Center");
            this.add((Component)oPanel, "North");
            oTable = new JTable(this.m_oModel);
            this.add((Component)new JScrollPane(oTable), "Center");
        }

        static /* synthetic */ CoefModel access$0(CoefComponent coefComponent) {
            return coefComponent.m_oModel;
        }

        static /* synthetic */ JSlider access$1(CoefComponent coefComponent) {
            return coefComponent.m_oSizeInput;
        }

        static /* synthetic */ JLabel access$2(CoefComponent coefComponent) {
            return coefComponent.m_oSizeOutput;
        }

        private class CoefModel
        extends AbstractTableModel {
            private int m_nSize = 0;
            private int[] m_aValues = new int[this.getMaximumSize()];

            public int getMinimumSize() {
                return 0;
            }

            public int getMaximumSize() {
                return 32;
            }

            public int getSize() {
                return this.m_nSize;
            }

            public synchronized void setSize(int nSize) {
                if (nSize < this.getMinimumSize() || nSize > this.getMaximumSize()) {
                    throw new IllegalArgumentException();
                }
                if (this.m_nSize != nSize) {
                    this.m_nSize = nSize;
                    this.fireTableDataChanged();
                }
            }

            public int[] getCoefs() {
                int[] aResult = new int[this.getSize()];
                System.arraycopy(this.m_aValues, 0, aResult, 0, aResult.length);
                return aResult;
            }

            public int getCoef(int nIndex) {
                return this.m_aValues[nIndex];
            }

            public synchronized void setCoef(int nIndex, int nValue) {
                this.m_aValues[nIndex] = nValue;
                this.fireTableRowsUpdated(nIndex, nIndex);
            }

            public final int getRowCount() {
                return this.getSize();
            }

            public final int getColumnCount() {
                return 2;
            }

            public final Class getColumnClass(int nColumn) {
                Class oResult;
                switch (nColumn) {
                    case 0: {
                        oResult = class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = Threshold._mthclass$("java.lang.String"));
                        break;
                    }
                    case 1: {
                        oResult = class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = Threshold._mthclass$("java.lang.Integer"));
                        break;
                    }
                    default: {
                        oResult = null;
                    }
                }
                return oResult;
            }

            public final String getColumnName(int nColumn) {
                String oResult;
                switch (nColumn) {
                    case 0: {
                        oResult = "Name";
                        break;
                    }
                    case 1: {
                        oResult = "Value";
                        break;
                    }
                    default: {
                        oResult = null;
                    }
                }
                return oResult;
            }

            public final boolean isCellEditable(int nRow, int nColumn) {
                return nColumn == 1;
            }

            public final Object getValueAt(int nRow, int nColumn) {
                Object oResult;
                switch (nColumn) {
                    case 0: {
                        oResult = String.valueOf(Term.getChar(nRow));
                        break;
                    }
                    case 1: {
                        oResult = new Integer(this.getCoef(nRow));
                        break;
                    }
                    default: {
                        oResult = null;
                    }
                }
                return oResult;
            }

            public final void setValueAt(Object oValue, int nRow, int nColumn) {
                if (nColumn == 1) {
                    this.setCoef(nRow, ((Number)oValue).intValue());
                }
            }

            CoefModel(int[] aInitialValues) {
                if (aInitialValues == null) {
                    this.m_nSize = 0;
                } else {
                    if (aInitialValues.length > this.getMaximumSize()) {
                        throw new IllegalArgumentException();
                    }
                    System.arraycopy(aInitialValues, 0, this.m_aValues, 0, aInitialValues.length);
                    this.m_nSize = aInitialValues.length;
                }
            }
        }
    }

    private static class ThresholdComponent
    extends JPanel {
        private SpinnerNumberModel m_oModel;

        public int getValue() {
            return this.m_oModel.getNumber().intValue();
        }

        public void setValue(int nValue) {
            this.m_oModel.setValue(new Integer(nValue));
        }

        public ThresholdComponent(int nInitialValue) {
            this.m_oModel = new SpinnerNumberModel(nInitialValue, Integer.MIN_VALUE, Integer.MAX_VALUE, 1);
            this.setLayout(new BorderLayout());
            this.add((Component)new JLabel("Threshold value : "), "West");
            this.add((Component)new JSpinner(this.m_oModel), "Center");
        }
    }
}

