/*
 * Decompiled with CFR 0.152.
 */
package fr.imag.leibniz.jbool.function;

import fr.imag.leibniz.jbool.BooleanFunction;
import fr.imag.leibniz.jbool.operation.AbstractBooleanOperation;
import fr.imag.leibniz.jbool.operation.OperationResult;
import fr.imag.leibniz.jbool.operation.options.AbstractOperationOptions;
import fr.imag.leibniz.jbool.operation.options.OperationOptions;
import java.awt.Component;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class RandomCreation
extends AbstractBooleanOperation {
    public RandomCreation() {
        super("Random", null, 1, true);
    }

    public OperationResult run(OperationOptions lesOptions) {
        if (!(lesOptions instanceof Options)) {
            throw new IllegalArgumentException(lesOptions.getClass().getName());
        }
        return this.createResult(BooleanFunction.createRandomFunction(((Options)lesOptions).numberOfVariables(), ((Options)lesOptions).numberOfTerms(), ((Options)lesOptions).degree(), ((Options)lesOptions).isUniform(), ((Options)lesOptions).isPositive(), ((Options)lesOptions).isConjonctive()));
    }

    public OperationOptions getDefaultOptions() {
        return new Options(12, 5, 2, false, false, false);
    }

    public String getGeneratedName(String leNomOriginal) {
        return leNomOriginal;
    }

    public class Options
    extends AbstractOperationOptions {
        public Options(int leNbVariables, int leNbTerms, int leDegree, boolean lUniform, boolean laPositive, boolean leConjonctive) {
            super(RandomCreation.this);
            this.addOption((Object)"NbVariables", "Number of variables", leNbVariables);
            this.addOption((Object)"NbTerms", "Maximal number of terms", leNbTerms);
            this.addOption((Object)"Degree", "Minimal degree", leDegree);
            this.addOption((Object)"Uniform", "Uniform", lUniform);
            this.addOption((Object)"Positive", "Positive", laPositive);
            this.addOption((Object)"Conjunctive", "Conjunctive", leConjonctive);
        }

        protected Component createComponent() {
            JPanel unComponent = new JPanel();
            unComponent.setLayout(new BoxLayout(unComponent, 1));
            unComponent.add(this.getOptionComponent("NbVariables"));
            unComponent.add(this.getOptionComponent("NbTerms"));
            unComponent.add(this.getOptionComponent("Degree"));
            unComponent.add(this.getOptionComponent("Uniform"));
            unComponent.add(this.getOptionComponent("Positive"));
            unComponent.add(this.getOptionComponent("Conjunctive"));
            return unComponent;
        }

        public int numberOfVariables() {
            return this.getIntegerOptionValue("NbVariables");
        }

        public int numberOfTerms() {
            return this.getIntegerOptionValue("NbTerms");
        }

        public int degree() {
            return this.getIntegerOptionValue("Degree");
        }

        public boolean isUniform() {
            return this.getBooleanOptionValue("Uniform");
        }

        public boolean isPositive() {
            return this.getBooleanOptionValue("Positive");
        }

        public boolean isConjonctive() {
            return this.getBooleanOptionValue("Conjunctive");
        }
    }
}

