/*
 * Decompiled with CFR 0.152.
 */
package fr.imag.leibniz.jbool;

import fr.imag.leibniz.jbool.BoolEngineObject;
import fr.imag.leibniz.jbool.BooleanFunction;
import fr.imag.leibniz.jbool.ConstantTermException;
import java.util.Hashtable;
import java.util.NoSuchElementException;

public class Term
extends BoolEngineObject {
    private static Hashtable m_Positions = null;
    private static final String m_Alphabet = "abcdefghijklmnopqrstuvwxyz123456";
    private static final int MAX_SIZE = "abcdefghijklmnopqrstuvwxyz123456".length();
    private BooleanFunction m_oParent = null;

    static {
        m_Positions = new Hashtable();
        int i = 0;
        while (i < m_Alphabet.length()) {
            m_Positions.put(new Character(m_Alphabet.charAt(i)), new Integer(i));
            ++i;
        }
    }

    public static Term getTerm(long nTermRef) {
        return nTermRef == 0L ? null : new Term(nTermRef);
    }

    public Term() {
    }

    public Term(String inText) throws ConstantTermException {
        this.setBoolRef(Term.createTermRef(inText), false);
    }

    protected Term(BooleanFunction oParent, long nTermRef) {
        super(nTermRef);
        this.m_oParent = oParent;
    }

    private Term(long nTermRef) {
        super(nTermRef);
    }

    protected void deleteBoolObject(long hBoolRef) {
        if (this.m_oParent == null) {
            Term.deleteTermRef(hBoolRef);
        }
    }

    public static long createTermRef(String inText) throws ConstantTermException {
        boolean[] aPositives = null;
        boolean[] aNegatives = null;
        int nIndex = -1;
        if (inText != null) {
            nIndex = inText.indexOf(45);
            if (nIndex < 0) {
                aPositives = Term.createCheckedVector(inText);
            } else {
                if (nIndex > 0) {
                    aPositives = Term.createCheckedVector(inText.substring(0, nIndex));
                }
                try {
                    aNegatives = Term.createCheckedVector(inText.substring(nIndex + 1));
                }
                catch (ConstantTermException e) {
                    throw new ConstantTermException(!e.getValue());
                }
            }
        }
        return Term.createTermRef(aPositives, aNegatives);
    }

    public static boolean[] createCheckedVector(String inText) throws ConstantTermException {
        boolean[] aVector = null;
        int nLength = 0;
        char unChar = '\u0000';
        if (inText != null) {
            nLength = inText.length();
        }
        if (nLength > 0) {
            aVector = new boolean[MAX_SIZE];
        }
        int i = 0;
        while (i < nLength) {
            unChar = inText.charAt(i);
            switch (unChar) {
                case 'T': {
                    throw new ConstantTermException(true);
                }
                case 'F': {
                    throw new ConstantTermException(false);
                }
            }
            aVector[Term.getPosition((char)unChar)] = true;
            ++i;
        }
        return aVector;
    }

    public static boolean[] createVector(String inText) {
        boolean[] aVector = null;
        try {
            aVector = Term.createCheckedVector(inText);
        }
        catch (ConstantTermException e) {
            throw new IllegalArgumentException(inText);
        }
        return aVector;
    }

    public static boolean checkDisjoint(boolean[] inFirst, boolean[] inSecond) {
        int nSize = 0;
        boolean nAreDisjoint = true;
        if (inFirst != null && inSecond != null) {
            nSize = Math.min(inFirst.length, inSecond.length);
            int i = 0;
            while (i < nSize && nAreDisjoint) {
                nAreDisjoint = !inFirst[i] || !inSecond[i];
                ++i;
            }
        }
        return nAreDisjoint;
    }

    public static boolean checkDisjoint(String inFirst, String inSecond) {
        return Term.checkDisjoint(Term.createVector(inFirst), Term.createVector(inSecond));
    }

    public String toString() {
        return Term.toString(this.getBoolRef());
    }

    public static String toString(long inTermRef) {
        String strPos = Term.toString(Term.getPositives(inTermRef));
        String strNeg = Term.toString(Term.getNegatives(inTermRef));
        return strNeg.length() > 0 ? String.valueOf(strPos) + '-' + strNeg : strPos;
    }

    protected static String toString(boolean[] inValues) {
        String strResult = new String();
        if (inValues == null) {
            return null;
        }
        int i = 0;
        while (i < inValues.length) {
            if (inValues[i]) {
                strResult = String.valueOf(strResult) + Term.getChar(i);
            }
            ++i;
        }
        return strResult;
    }

    public boolean isUseful() {
        return Term.isUseful(this.getBoolRef());
    }

    public static char getChar(int inPosition) {
        return m_Alphabet.charAt(inPosition);
    }

    protected static int getPosition(char c) {
        Integer unePosition = (Integer)m_Positions.get(new Character(c));
        if (unePosition == null) {
            throw new NoSuchElementException();
        }
        return unePosition;
    }

    private static native long createTermRef(boolean[] var0, boolean[] var1);

    private static native boolean[] getPositives(long var0);

    private static native boolean[] getNegatives(long var0);

    private static native void deleteTermRef(long var0);

    public static native boolean isUseful(long var0);
}

