/*
 * Decompiled with CFR 0.152.
 */
package fr.imag.leibniz.jbool;

import fr.imag.leibniz.jbool.BoolEngineObject;
import fr.imag.leibniz.jbool.ConstantTermException;
import fr.imag.leibniz.jbool.Term;
import fr.imag.leibniz.jbool.function.AddDummy;
import fr.imag.leibniz.jbool.function.Assignment;
import fr.imag.leibniz.jbool.function.ChangeForm;
import fr.imag.leibniz.jbool.function.CheckPositive;
import fr.imag.leibniz.jbool.function.Compacting;
import fr.imag.leibniz.jbool.function.Complement;
import fr.imag.leibniz.jbool.function.DegreeSorting;
import fr.imag.leibniz.jbool.function.DeleteDummy;
import fr.imag.leibniz.jbool.function.DisjointForm;
import fr.imag.leibniz.jbool.function.DualForm;
import fr.imag.leibniz.jbool.function.DualFunction;
import fr.imag.leibniz.jbool.function.Duplicate;
import fr.imag.leibniz.jbool.function.ExtractBySize;
import fr.imag.leibniz.jbool.function.FormalComplement;
import fr.imag.leibniz.jbool.function.FullPrime;
import fr.imag.leibniz.jbool.function.FusionVariables;
import fr.imag.leibniz.jbool.function.IrredundantForm;
import fr.imag.leibniz.jbool.function.Monotone;
import fr.imag.leibniz.jbool.function.PositiveBound;
import fr.imag.leibniz.jbool.function.PrimeBasis;
import fr.imag.leibniz.jbool.function.Product;
import fr.imag.leibniz.jbool.function.QHorn;
import fr.imag.leibniz.jbool.function.Quadratic;
import fr.imag.leibniz.jbool.function.Refutable;
import fr.imag.leibniz.jbool.function.Regular;
import fr.imag.leibniz.jbool.function.RenameFunction;
import fr.imag.leibniz.jbool.function.SaveAsFunction;
import fr.imag.leibniz.jbool.function.SaveFunction;
import fr.imag.leibniz.jbool.function.ShiftVariables;
import fr.imag.leibniz.jbool.function.SwitchVariables;
import fr.imag.leibniz.jbool.function.Union;
import fr.imag.leibniz.jbool.operation.BooleanOperation;
import fr.imag.leibniz.jbool.operation.Operation;
import fr.imag.leibniz.jbool.operation.OperationTree;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.StringTokenizer;

public class BooleanFunction
extends BoolEngineObject {
    public static final String PROPERTY_NAME = "fr.imag.leibniz.jbool.BooleanFunction.PropertyName";
    public static final String PROPERTY_VALUE = "fr.imag.leibniz.jbool.BooleanFunction.PropertyValue";
    private static int m_Compteur = 0;
    private Term[] m_aTerms = null;
    private OperationTree m_OperationTree = null;
    private String m_Nom = null;
    private BooleanFunction m_Parent = null;
    private BooleanOperation m_Generator = null;
    private File file_ref = null;

    public BooleanFunction() {
        this(null, null);
    }

    public BooleanFunction(boolean leConjonctiveFlag) {
        this(null, null, leConjonctiveFlag);
    }

    public BooleanFunction(String leFunctionText) {
        this(null, leFunctionText);
    }

    public BooleanFunction(String leNom, String leFunctionText) {
        this(leNom, leFunctionText, BooleanFunction.guessConjonctiveFlag(leFunctionText));
    }

    public BooleanFunction(String leFunctionText, boolean leConjonctiveFlag) {
        this(null, leFunctionText, leConjonctiveFlag);
    }

    public BooleanFunction(String leNom, String leFunctionText, boolean leConjonctiveFlag) {
        this.setValue(leFunctionText, BooleanFunction.guessConjonctiveFlag(leFunctionText));
        if (leNom != null) {
            this.initName(leNom);
        }
    }

    public BooleanFunction(BooleanFunction laFunction) {
        super(laFunction.createRefCopy());
        this.initName(laFunction.m_Nom);
    }

    private BooleanFunction(BooleanFunction leParent, long inFunctionRef) {
        super(inFunctionRef);
        this.m_Parent = leParent;
        BooleanFunction.changeVarset(inFunctionRef, inFunctionRef);
    }

    protected void deleteBoolObject(long hBoolRef) {
    }

    protected final long createRefCopy() {
        return BooleanFunction.duplicateFunctionRef(this.getBoolRef());
    }

    public Object clone() {
        return new BooleanFunction(this);
    }

    private void initName(String leNom) {
        this.m_Nom = leNom == null ? "Function " + ++m_Compteur : leNom;
    }

    public final void setName(String leNom) {
        String unOld = this.m_Nom;
        this.m_Nom = leNom;
        this.firePropertyChange(PROPERTY_NAME, unOld, this.m_Nom);
    }

    public String getName() {
        return this.m_Generator == null ? this.m_Nom : this.getNameForOperation(this.m_Generator);
    }

    private String getNameForOperation(BooleanOperation lOperation) {
        return lOperation.getGeneratedName(this.m_Parent == null ? this.m_Nom : this.m_Parent.getName());
    }

    public void setGenerator(BooleanOperation leGenerator, boolean leDetachFlag) {
        if (this.m_Parent == null || leDetachFlag) {
            this.initName(this.getNameForOperation(leGenerator));
            this.m_Parent = null;
        } else {
            this.m_Generator = leGenerator;
            this.m_Parent.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent e) {
                    BooleanFunction.this.parentChanged(e.getPropertyName());
                }
            });
        }
    }

    private void parentChanged(String laProperty) {
        if (laProperty.equals(PROPERTY_NAME)) {
            this.firePropertyChange(PROPERTY_NAME, null, null);
        } else {
            laProperty.equals(PROPERTY_VALUE);
        }
    }

    private static boolean guessConjonctiveFlag(String laValue) {
        boolean unFlag = false;
        if (laValue != null && laValue.indexOf(38) >= 0) {
            unFlag = true;
        }
        return unFlag;
    }

    public void setValue(String laValue) {
        this.setValue(laValue, this.isConjonctive());
    }

    protected synchronized void setValue(String laValue, boolean leConjonctiveFlag) {
        StringTokenizer oTokenizer = null;
        int nTaille = 0;
        long[] aTermRefs = null;
        long aFunctionRef = 0L;
        if (laValue != null) {
            oTokenizer = new StringTokenizer(laValue, leConjonctiveFlag ? "& " : "+ ");
            nTaille = oTokenizer.countTokens();
        }
        this.m_aTerms = null;
        aTermRefs = new long[nTaille];
        int i = 0;
        while (i < nTaille && aFunctionRef == 0L) {
            block4: {
                try {
                    aTermRefs[i] = Term.createTermRef(oTokenizer.nextToken());
                }
                catch (ConstantTermException e) {
                    if (leConjonctiveFlag == e.getValue()) break block4;
                    aFunctionRef = BooleanFunction.createConstantFunction(e.getValue(), leConjonctiveFlag);
                }
            }
            ++i;
        }
        long ref1 = this.getBoolRef();
        this.setBoolRef(aFunctionRef == 0L ? BooleanFunction.createFunctionRef(aTermRefs, leConjonctiveFlag) : aFunctionRef, false);
        BooleanFunction.changeVarset(ref1, this.getBoolRef());
        this.firePropertyChange(PROPERTY_VALUE, null, null);
    }

    public final OperationTree getOperationTree() {
        if (this.m_OperationTree == null) {
            this.m_OperationTree = this.createOperation();
        }
        return this.m_OperationTree;
    }

    protected OperationTree createOperation() {
        Operation[] desOperations = null;
        OperationTree[] desTrees = null;
        boolean i = false;
        desTrees = new OperationTree[6];
        desOperations = new BooleanOperation[]{new SaveFunction(this), new SaveAsFunction(this), new RenameFunction(this)};
        desTrees[0] = OperationTree.createFlatTree(1, "File", desOperations);
        BooleanOperation[] booleanOperationArray = new BooleanOperation[9];
        booleanOperationArray[0] = new FormalComplement(this);
        booleanOperationArray[1] = new ChangeForm(this);
        booleanOperationArray[3] = new DegreeSorting(this);
        booleanOperationArray[4] = new ShiftVariables(this);
        booleanOperationArray[5] = new Compacting(this);
        booleanOperationArray[7] = new DeleteDummy(this);
        booleanOperationArray[8] = new AddDummy(this);
        desOperations = booleanOperationArray;
        desTrees[1] = OperationTree.createFlatTree(2, "Edit", desOperations);
        BooleanOperation[] booleanOperationArray2 = new BooleanOperation[6];
        booleanOperationArray2[0] = new DualForm(this);
        booleanOperationArray2[1] = new DisjointForm(this);
        booleanOperationArray2[3] = new IrredundantForm(this);
        booleanOperationArray2[4] = new FullPrime(this);
        booleanOperationArray2[5] = new PrimeBasis(this);
        desOperations = booleanOperationArray2;
        desTrees[2] = OperationTree.createFlatTree("Presentation", desOperations);
        BooleanOperation[] booleanOperationArray3 = new BooleanOperation[9];
        booleanOperationArray3[0] = new Duplicate(this);
        booleanOperationArray3[1] = new Assignment(this);
        booleanOperationArray3[2] = new FusionVariables(this);
        booleanOperationArray3[3] = new ExtractBySize(this);
        booleanOperationArray3[4] = new PositiveBound(this);
        booleanOperationArray3[5] = new SwitchVariables(this);
        booleanOperationArray3[7] = new Complement(this);
        booleanOperationArray3[8] = new DualFunction(this);
        desOperations = booleanOperationArray3;
        desTrees[3] = OperationTree.createFlatTree("Construction", desOperations);
        desOperations = new BooleanOperation[]{new Union(this), new Product(this)};
        desTrees[4] = OperationTree.createFlatTree("Operations", desOperations);
        desOperations = new BooleanOperation[]{new CheckPositive(this), new Monotone(this), new Regular(this), new Quadratic(this), new QHorn(this), new Refutable(this)};
        desTrees[5] = OperationTree.createFlatTree("Computations", desOperations);
        return new OperationTree("", desTrees);
    }

    private static BooleanFunction createFunction(long inFunctionRef) {
        return inFunctionRef == 0L ? null : new BooleanFunction(null, inFunctionRef);
    }

    public static BooleanFunction createRandomFunction(int nbVariables, int nbTerms, int degre, boolean isUniform, boolean isPositive, boolean isConjonctive) {
        return BooleanFunction.createFunction(BooleanFunction.createRandom(nbVariables, nbTerms, degre, isUniform, isPositive, isConjonctive));
    }

    public static BooleanFunction createThresholdFunction(int nThreshold, int[] aWeights) {
        return BooleanFunction.createFunction(BooleanFunction.createThreshold(nThreshold, aWeights));
    }

    public BooleanFunction createPositiveBound() {
        return this.createChild(BooleanFunction.createPositiveBound(this.getBoolRef()));
    }

    public BooleanFunction extractBySize(int degree) {
        return this.createChild(BooleanFunction.extractBySize(this.getBoolRef(), degree));
    }

    public void degreeSorting(boolean increasing) {
        BooleanFunction.degreeSorting(this.getBoolRef(), increasing);
        this.firePropertyChange(PROPERTY_VALUE, null, null);
    }

    public void shiftVariables(int shiftValue) {
        BooleanFunction.shiftVariables(this.getBoolRef(), shiftValue);
        this.firePropertyChange(PROPERTY_VALUE, null, null);
    }

    public BooleanFunction createFormalComplement() {
        return this.createChild(BooleanFunction.formalComplement(this.createRefCopy()));
    }

    public BooleanFunction createDualForm() {
        return this.createChild(BooleanFunction.dualForm(this.getBoolRef()));
    }

    public BooleanFunction createDisjointForm() {
        return this.createChild(BooleanFunction.disjointForm(this.getBoolRef()));
    }

    public boolean monotone() {
        return BooleanFunction.isMonotone(this.createRefCopy());
    }

    public boolean regular() {
        return BooleanFunction.isRegular(this.createRefCopy());
    }

    public boolean quadratic() {
        return BooleanFunction.isQuadratic(this.createRefCopy());
    }

    public boolean qHorn() {
        return BooleanFunction.isqHorn(this.createRefCopy());
    }

    public boolean refutable() {
        return BooleanFunction.isRefutable(this.createRefCopy());
    }

    public BooleanFunction createUnion(BooleanFunction m_Function) {
        return this.createChild(BooleanFunction.union(this.getBoolRef(), m_Function.getBoolRef()));
    }

    public BooleanFunction createProduct(BooleanFunction m_Function) {
        return this.createChild(BooleanFunction.product(this.getBoolRef(), m_Function.getBoolRef()));
    }

    public void deleteVariables() {
        BooleanFunction.delete(this.getBoolRef());
        this.firePropertyChange(PROPERTY_VALUE, null, null);
    }

    public void addVariables(String var) {
        boolean[] desVars = Term.createVector(var);
        BooleanFunction.add(this.getBoolRef(), desVars);
        this.firePropertyChange(PROPERTY_VALUE, null, null);
    }

    public BooleanFunction createIrredundantForm() {
        return this.createChild(BooleanFunction.irredundantForm(this.createRefCopy()));
    }

    public BooleanFunction createFullPrime() {
        return this.createChild(BooleanFunction.fullPrime(this.createRefCopy()));
    }

    public BooleanFunction createPrimeBasis() {
        return this.createChild(BooleanFunction.primeBasis(this.createRefCopy()));
    }

    public void compacting() {
        BooleanFunction.compacting(this.getBoolRef());
        this.firePropertyChange(PROPERTY_VALUE, null, null);
    }

    public void changeNormalForm() {
        BooleanFunction.changeNormalForm(this.getBoolRef());
        this.firePropertyChange(PROPERTY_VALUE, null, null);
    }

    public BooleanFunction createAssignment(String trueVariables, String falseVariables) {
        boolean[] desFalses;
        BooleanFunction uneFunction = null;
        boolean[] desTrues = Term.createVector(trueVariables);
        if (!Term.checkDisjoint(desTrues, desFalses = Term.createVector(falseVariables))) {
            throw new IllegalArgumentException();
        }
        uneFunction = this.createChild(BooleanFunction.assignment(this.getBoolRef(), desTrues, desFalses));
        return uneFunction;
    }

    public BooleanFunction createFusion(String fusionVariables) {
        BooleanFunction uneFunction = null;
        boolean[] desFusionVariables = Term.createVector(fusionVariables);
        uneFunction = this.createChild(BooleanFunction.fusion(this.getBoolRef(), desFusionVariables));
        return uneFunction;
    }

    public BooleanFunction switchVariables(String switchVars) {
        BooleanFunction uneFunction = null;
        long nFunctionRef = 0L;
        boolean[] desSwitchVars = Term.createVector(switchVars);
        nFunctionRef = this.createRefCopy();
        BooleanFunction.switchVariables(nFunctionRef, desSwitchVars);
        uneFunction = this.createChild(nFunctionRef);
        return uneFunction;
    }

    public BooleanFunction createComplement() {
        return this.createChild(BooleanFunction.complement(this.getBoolRef()));
    }

    public BooleanFunction createDualFunction() {
        return this.createChild(BooleanFunction.dualFunction(this.getBoolRef()));
    }

    public boolean checkPositive() {
        boolean bResult = false;
        if (!this.isGeneral()) {
            return true;
        }
        bResult = BooleanFunction.checkPositive(this.getBoolRef());
        if (bResult) {
            this.firePropertyChange(PROPERTY_VALUE, null, null);
        }
        return bResult;
    }

    public boolean isConjonctive() {
        return BooleanFunction.isConjonctive(this.getBoolRef());
    }

    public boolean isGeneral() {
        return BooleanFunction.isGeneral(this.getBoolRef());
    }

    public String getVariableSet() {
        return Term.toString(BooleanFunction.getVariableSet(this.getBoolRef()));
    }

    public Term[] getTerms() {
        return this.getTerms(true);
    }

    private synchronized Term[] getTerms(boolean bClone) {
        long[] aRefs = null;
        if (this.m_aTerms == null) {
            aRefs = BooleanFunction.getTermRefs(this.getBoolRef());
            this.m_aTerms = new Term[aRefs == null ? 0 : aRefs.length];
            int i = 0;
            while (i < this.m_aTerms.length) {
                this.m_aTerms[i] = new Term(this, aRefs[i]);
                ++i;
            }
        }
        return this.m_aTerms != null && bClone ? (Term[])this.m_aTerms.clone() : this.m_aTerms;
    }

    public int getTermCount() {
        Term[] aTerms = null;
        aTerms = this.getTerms(false);
        return aTerms == null ? 0 : aTerms.length;
    }

    public Term getTerm(int nIndex) {
        Term[] aTerms = null;
        aTerms = this.getTerms(false);
        return aTerms == null || nIndex < 0 && nIndex >= aTerms.length ? null : aTerms[nIndex];
    }

    protected BooleanFunction createChild(long inFunctionRef) {
        return new BooleanFunction(this, inFunctionRef);
    }

    public String toString() {
        return BooleanFunction.toString(this.getBoolRef());
    }

    public static String toString(long inFunctionRef) {
        StringBuffer unBuffer = null;
        String unResultat = null;
        String unOperateur = null;
        String strTemp = null;
        boolean aConjonctiveFlag = false;
        aConjonctiveFlag = BooleanFunction.isConjonctive(inFunctionRef);
        unOperateur = aConjonctiveFlag ? " & " : " + ";
        long[] aTermRefs = BooleanFunction.getTermRefs(inFunctionRef);
        if (aTermRefs != null && aTermRefs.length > 0) {
            unBuffer = new StringBuffer();
            int i = 0;
            while (i < aTermRefs.length) {
                strTemp = Term.toString(aTermRefs[i]);
                if (strTemp != null) {
                    if (unBuffer.length() > 0) {
                        unBuffer.append(unOperateur);
                    }
                    unBuffer.append(strTemp);
                }
                ++i;
            }
            unResultat = unBuffer.length() == 0 ? (aConjonctiveFlag ? "F" : "T") : unBuffer.toString();
        } else {
            unResultat = aConjonctiveFlag ? "T" : "F";
        }
        return unResultat;
    }

    private static long createConstantFunction(boolean inValue, boolean inIsConjonctive) {
        long[] desTermRefs = null;
        if (inValue != inIsConjonctive) {
            try {
                desTermRefs = new long[]{Term.createTermRef("")};
            }
            catch (ConstantTermException e) {
                throw new RuntimeException();
            }
        }
        return BooleanFunction.createFunctionRef(desTermRefs, inIsConjonctive);
    }

    public File getFileRef() {
        return this.file_ref;
    }

    public void setFileRef(File f) {
        this.file_ref = f;
    }

    private static native long createFunctionRef(long[] var0, boolean var1);

    private static native long duplicateFunctionRef(long var0);

    private static native long[] getTermRefs(long var0);

    private static native boolean isConjonctive(long var0);

    private static native boolean isGeneral(long var0);

    private static native boolean[] getVariableSet(long var0);

    private static native long createPositiveBound(long var0);

    private static native void changeNormalForm(long var0);

    private static native long formalComplement(long var0);

    private static native long dualForm(long var0);

    private static native long disjointForm(long var0);

    private static native long irredundantForm(long var0);

    private static native void degreeSorting(long var0, boolean var2);

    private static native void shiftVariables(long var0, int var2);

    private static native long createRandom(int var0, int var1, int var2, boolean var3, boolean var4, boolean var5);

    private static native long createThreshold(int var0, int[] var1);

    private static native long fullPrime(long var0);

    private static native long primeBasis(long var0);

    private static native void compacting(long var0);

    private static native long extractBySize(long var0, int var2);

    private static native long assignment(long var0, boolean[] var2, boolean[] var3);

    private static native long fusion(long var0, boolean[] var2);

    private static native void switchVariables(long var0, boolean[] var2);

    private static native long complement(long var0);

    private static native long dualFunction(long var0);

    private static native boolean checkPositive(long var0);

    private static native boolean isMonotone(long var0);

    private static native boolean isRegular(long var0);

    private static native boolean isQuadratic(long var0);

    private static native boolean isqHorn(long var0);

    private static native boolean isRefutable(long var0);

    private static native void changeVarset(long var0, long var2);

    private static native long union(long var0, long var2);

    private static native long product(long var0, long var2);

    private static native long delete(long var0);

    private static native long add(long var0, boolean[] var2);
}

