#!/usr/bin/env python3
# -*- coding: utf8 -*-
# test encoding: à-é-è-ô-ï-€

import time
import openmdao.api as om
from sellar import SellarMDA

prob = om.Problem()
prob.model = SellarMDA(strategy='bgs_matfree', verbosity=2) # strategy = [direct,bgs_auto,bgs_custom,bgs_matfree]; verbosity = [0,1,2]

prob.driver = om.ScipyOptimizeDriver()
prob.driver.options['optimizer'] = 'SLSQP'
prob.driver.options['maxiter'] = 100
prob.driver.options['tol'] = 1e-8

prob.model.add_design_var('x', lower=0, upper=10)
prob.model.add_design_var('z', lower=0, upper=10)
prob.model.add_objective('obj')
prob.model.add_constraint('con1', upper=0)
prob.model.add_constraint('con2', upper=0)

prob.setup(check=True, mode='rev')
prob.set_solver_print(level=2)
om.n2(prob, outfile='n2.html', show_browser=False)

#prob.check_partials(compact_print=True);
#prob.run_model()
#prob.check_totals(compact_print=True);
tic = time.perf_counter()
tic2 = time.process_time()
prob.run_driver()
toc = time.perf_counter()
toc2 = time.process_time()

print('minimum found at')
print(prob.get_val('x')[0])
print(prob.get_val('z'))

print('minumum objective')
print(prob.get_val('obj')[0])

print('process time:', toc2 - tic2)
print('ellapsed time:', toc - tic)
