
###############################################################################
### Phenogram		 										  	     		###
###	Poupouzzoni 2022, adapted from the code of 	 V. Fischer					###
###############################################################################


library(ape)
library(TreeSearch)
library(TreeTools)
library(dendextend)
library(paleotree)
library(strap)
library(treeio)
library(viridis)
library(deeptime)
library(phytools)
library(evobiR)
library(rgl)
library(geomorph)
library(readxl)
library(Morpho)
library(ggplot2)
library(ggfortify)
library(ggthemes) 
library(ggrepel)
library(ggtree)


library(stringr)

################################################################################
######################		Input parameters	################################
################################################################################

BoneType = "Humerus_Thalatto"
#BoneType = "Humerus_Dyro"


WorkingDirectory <-  "C:\\Users\\Admin\\Dropbox (EDDy Lab)\\Scavezzoni Sea Crocs\\PostcranialPaper\\Data"

setwd(paste0(WorkingDirectory,"\\Phenogram"))

              # # # # # # # # # # # # # # # # # # # # # # # # # #
              # # # #                                     # # # #
              # # # #				PHYLOGENY	          # # # #
              # # # #                                     # # # #
              # # # # # # # # # # # # # # # # # # # # # # # # # #
			  
			  

library(ape)
library(TreeSearch)
library(TreeTools)

library(paleotree)
library(strap)
library(treeio)
library(viridis)
library(deeptime)
library(phytools)
library(evobiR)
library(rgl)
library(geomorph)
library(readxl)
library(Morpho)
library(ggplot2)
library(ggfortify)
library(ggthemes) 
library(ggrepel)
library(ggtree)


library(stringr)



Croc_trees<-read.nexus("Jouve2020.nex")
mod_trees <- list()
sample <- sample(1:length(Croc_trees),100)
class(mod_trees) <- "multiphylo"


for (i in 1:length(sample)){
Croc_tree <- Croc_trees[[sample[i]]]

#First change some names
Croc_tree$tip.label[which(Croc_tree$tip.label=="Steneosaurus_obtusidens")] <- "Lemmysuchus_obtusidens"
Croc_tree$tip.label[which(Croc_tree$tip.label=="Steneosaurus_edwardsi")] <- "Neosteneosaurus_edwardsi"
Croc_tree$tip.label[which(Croc_tree$tip.label=="Steneosaurus_leedsi")] <- "Charitomenosuchus_leedsi"
Croc_tree$tip.label[which(Croc_tree$tip.label=="Steneosaurus_bollensis")] <- "Macrospondylus_bollensis9428"
Croc_tree$tip.label[which(Croc_tree$tip.label=="Steneosaurus_heberti")] <- "Proexochokefalos_heberti"
Croc_tree$tip.label[which(Croc_tree$tip.label=="Metriorhynchus_superciliosus")] <- "Thalattosuchus_superciliosus"
Croc_tree$tip.label[which(Croc_tree$tip.label=="Steneosaurus_gracilirostris")] <- "Plagiophthalmosuchus_gracilirostris"


#Then add new tips
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Rhabdognathus_sp."),label="Congosaurus_bequaerti", edgeLength = 0, lengthBelow = NULL) 
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Congosaurus_bequaerti"),label="Hyposaurus_natator", edgeLength = 0, lengthBelow = NULL) 
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Rhabdognathus_sp."),label="Acherontisuchus", edgeLength = 0, lengthBelow = NULL)
Croc_tree <- DropTip(Croc_tree, "Rhabdognathus_sp.", preorder = TRUE, check = TRUE)
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Crocodylus_porosus"),label="Mecistops_cataphractus", edgeLength = 0, lengthBelow = NULL) 
Croc_tree <- DropTip(Croc_tree, "Crocodylus_porosus", preorder = TRUE, check = TRUE)

Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="M_brachyrhynchus"),label="M_brachyrhynchus3804", edgeLength = 0, lengthBelow = NULL) 
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="M_brachyrhynchus"),label="M_brachyrhynchus4763", edgeLength = 0, lengthBelow = NULL) 
Croc_tree <- DropTip(Croc_tree, "M_brachyrhynchus", preorder = TRUE, check = TRUE)
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Cricosaurus_suevicus"),label="Cricosaurus_bambergensis", edgeLength = 0, lengthBelow = NULL) 
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Cricosaurus_suevicus"),label="Cricosaurus_albersdoerferi", edgeLength = 0, lengthBelow = NULL) 
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Thalattosuchus_superciliosus"),label="Thalattosuchus_superciliosus950", edgeLength = 0, lengthBelow = NULL) 
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Thalattosuchus_superciliosus"),label="Thalattosuchus_superciliosus960", edgeLength = 0, lengthBelow = NULL) 
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Thalattosuchus_superciliosus"),label="Thalattosuchus_superciliosus1005", edgeLength = 0, lengthBelow = NULL) 
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Thalattosuchus_superciliosus"),label="Thalattosuchus_superciliosus1016", edgeLength = 0, lengthBelow = NULL) 
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Thalattosuchus_superciliosus"),label="Thalattosuchus_superciliosusV1143", edgeLength = 0, lengthBelow = NULL) 
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Thalattosuchus_superciliosus"),label="Thalattosuchus_superciliosusV1146", edgeLength = 0, lengthBelow = NULL) 
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Thalattosuchus_superciliosus"),label="Thalattosuchus_superciliosusR1530", edgeLength = 0, lengthBelow = NULL) 
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Thalattosuchus_superciliosus"),label="Thalattosuchus_superciliosusR2032", edgeLength = 0, lengthBelow = NULL) 
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Thalattosuchus_superciliosus"),label="Thalattosuchus_superciliosusR2054", edgeLength = 0, lengthBelow = NULL) 
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Thalattosuchus_superciliosus"),label="Thalattosuchus_superciliosusPMU35988", edgeLength = 0, lengthBelow = NULL)
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Geosaurus_giganteus"),label="Geosaurus_lapparenti", edgeLength = 0, lengthBelow = NULL)	
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="M_brachyrhynchus3804"),label="Tyrannoneustes972", edgeLength = 0, lengthBelow = NULL)
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Tyrannoneustes972"),label="Tyrannoneustes1145", edgeLength = 0, lengthBelow = NULL)
#Proexochokefalos_cf_bouchardi added
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Proexochokefalos_heberti"),label="Proexochokefalos_cf_bouchardi", edgeLength = 0, lengthBelow = NULL)
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Neosteneosaurus_edwardsi"),label="Neosteneosaurus3169", edgeLength = 0, lengthBelow = NULL)
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Neosteneosaurus_edwardsi"),label="Neosteneosaurus3701", edgeLength = 0, lengthBelow = NULL)	
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Neosteneosaurus_edwardsi"),label="Neosteneosaurus2076", edgeLength = 0, lengthBelow = NULL)
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Neosteneosaurus_edwardsi"),label="Neosteneosaurus2865", edgeLength = 0, lengthBelow = NULL)
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Lemmysuchus_obtusidens"),label="Machimosaurus_hugii", edgeLength = 0, lengthBelow = NULL)

#Add deeper taxon
temp_node <- Croc_tree$edge[which(Croc_tree$edge[,2]==which(Croc_tree$tip.label=="Macrospondylus_bollensis9428")),1] #get node of Lemmy+Macro
Croc_tree <-  AddTip(Croc_tree,where=temp_node,label="Mycterosuchus_nasutus", edgeLength = 1, lengthBelow = NULL)


#Sericodon added
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Mycterosuchus_nasutus"),label="Sericodon_jugleri", edgeLength = 0, lengthBelow = NULL)
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Sericodon_jugleri"),label="Aeolodon_priscus", edgeLength = 0, lengthBelow = NULL)



Croc_tree <-  AddTip(Croc_tree,where=0,label="Turnersuchus_hingleyae", edgeLength = 1, lengthBelow = NULL)

# #Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Charitomenosuchus_leedsi"),label="Turnersuchus_hingleyae", edgeLength = 0, lengthBelow = NULL)


mod_trees[[i]] <- Croc_tree	
}


############ SCALE THE TREES IN TIME #############

FAD_LAD <- read.csv(paste0("FAD_LAD_",BoneType,".csv"),header=TRUE,row.names=1) #First & Last occurences

Bone_trees <- lapply(mod_trees, keep.tip,tip=rownames(FAD_LAD))
node_mins <- rep(NA,(Nnode(Bone_trees[[1]])))
node_mins[1] <- 219 #root
node_mins[Bone_trees[[1]]$edge[which(Bone_trees[[1]]$edge[,2]==which(Bone_trees[[1]]$tip.label=="Mecistops_cataphractus")),1]-Ntip(Bone_trees[[1]])] <- 201.5 #Neosuchian split
Bone_trees <- unlist(lapply(Bone_trees, timePaleoPhy,timeData=FAD_LAD,dateTreatment="minMax",randres=TRUE,ntrees=100,type="mbl",vartime=3,node.mins=node_mins),recursive=FALSE)
class(Bone_trees)<-"multiPhylo"

#Cons_tree <- consensus(Bone_trees)
Cons_tree <- consensus(Bone_trees, rooted=TRUE)

plot(Cons_tree)



Cons_tree_eq <- timePaleoPhy(Cons_tree,timeData=FAD_LAD,type= "mbl",vartime = 3,node.mins =node_mins)


pdf(paste0(BoneType,"_timescale.pdf"),width=8, height=11)
geoscalePhylo((Bone_trees[[999]]),FAD_LAD,cex.ts=0.5,cex.tip=0.6)
dev.off()





################################################################################################################################################################
####################									PHENOGRAM																	############################
################################################################################################################################################################


library(phytools)
library(strap)
library(paleotree)

Ratio_data <- read.csv(paste0(BoneType,"_Ratio.csv"))
List_ratio <- Ratio_data[,2]
names(List_ratio)<-Ratio_data[,1]

Cons_tree_eq$tip.label %in% names(List_ratio)

anc_ratio <- fastAnc(Cons_tree_eq,List_ratio)
#anc_ratio <- anc.ML(Bone_tree_eq,Ratio_data[,2])

H <- nodeHeights(Cons_tree_eq)
max_x <- max(H)
root <- Cons_tree_eq$root.time
#real_max_x <- min(ages_red[rownames(ages_red) %in% rownames(data[-missing,]),1]) #OR = root-max(H)

pheno <- phenogram(Cons_tree_eq,c(List_ratio,anc_ratio),ylab = "Humerus ratio",fsize = 0.8,ftype="i",spread.labels=TRUE)

pdf("Phylogeny/phenogram.pdf", width=7.1, height=7.1)
ggsave(paste0(BoneType,"_Phylogeny/phenogram",".pdf"),device="pdf",units="mm",width=240,height=240) #sauvegarde le graphe affiché


if(BoneType == "Humerus_Thalatto")
{	
phenogram(Cons_tree_eq,c(List_ratio,anc_ratio),ylab = "Humerus ratio length/mid-width",fsize = 0.8,ftype="i",spread.labels=TRUE)

rect(xleft=root-199.3 ,ybottom=min(List_ratio)-0.05,xright=root-190.8 ,ytop=max(List_ratio)+0.05,col="#cccccc50",border="NA") #Sinemurian
rect(xleft=root-182.7,ybottom=min(List_ratio)-0.05,xright=root-174.1 ,ytop=max(List_ratio)+0.05,col="#cccccc50",border="NA") #Toarcian
rect(xleft=root-170.3,ybottom=min(List_ratio)-0.05,xright=root-168.3 ,ytop=max(List_ratio)+0.05,col="#cccccc50",border="NA") #Bajocian
rect(xleft=root-166.1,ybottom=min(List_ratio)-0.05,xright=root-163.5 ,ytop=max(List_ratio)+0.05,col="#cccccc50",border="NA") #Callovian
rect(xleft=root-157.3,ybottom=min(List_ratio)-0.05,xright=root-152.1 ,ytop=max(List_ratio)+0.05,col="#cccccc50",border="NA") #Kimmeridgian
rect(xleft=root-145,ybottom=min(List_ratio)-0.05,xright=root-139.8,ytop=max(List_ratio)+0.05,col="#cccccc50",border="NA") #Berriasian
#rect(xleft=root-132.9,ybottom=min(List_ratio)-0.05,xright=root-129.4,ytop=max(List_ratio)+0.05,col="#cccccc50",border="NA") #Hauterivian
#rect(xleft=root-125,ybottom=min(List_ratio)-0.05,xright=root-113,ytop=max(List_ratio)+0.05,col="#cccccc50",border="NA") #Aptian
# rect(xleft=root-100.5,ybottom=min(List_ratio)-0.05,xright=root-93.9,ytop=max(List_ratio)+0.05,col="#cccccc50",border="NA") #Cenomanian
# rect(xleft=root-89.8,ybottom=min(List_ratio)-0.05,xright=root-86.3,ytop=max(List_ratio)+0.05,col="#cccccc50",border="NA") #Coniacian
# rect(xleft=root-83.6,ybottom=min(List_ratio)-0.05,xright=root-72.1,ytop=max(List_ratio)+0.05,col="#cccccc50",border="NA") #Campanian
rect(xleft=root-201.3,ybottom=min(List_ratio)-0.15,xright=root-174.1,ytop=min(List_ratio)-0.05,col="#42AED0",border="NA") #Early Jurassic
rect(xleft=root-174.1,ybottom=min(List_ratio)-0.15,xright=root-163.5,ytop=min(List_ratio)-0.05,col="#80CFD8",border="NA") #Mid Jurassic
rect(xleft=root-163.5,ybottom=min(List_ratio)-0.15,xright=root-145,ytop=min(List_ratio)-0.05,col="#B3E3EE",border="NA") #Late Jurassic
# rect(xleft=root-145,ybottom=min(List_ratio)-0.15,xright=root-100.5,ytop=min(List_ratio)-0.05,col="#94cc79",border="NA") #Early K rectangle
# rect(xleft=root-100.5,ybottom=min(List_ratio)-0.15,xright=root-66,ytop=min(List_ratio)-0.05,col="#afd46c",border="NA") #Late K rectangle
# text(x=c(root-122.74,root-83.25),y=rep(min(List_ratio)-0.1,2),labels=c("Early Cretaceous","Late Cretaceous"),cex=0.7) 
# text(x=c(root-145,root-100.5,root-66),y=rep(min(List_ratio)-0.17,3),labels=c(145,100.5,66),cex=0.7)

points(pheno,pch=20,col=c(rep("#800080",7),rep("#5ab3b3",11))) #Purple "#800080" = Teleosauroids – # Teal "#5ab3b3" = Metriorhynchoidea #position of points is based on phylogenetic tree order
#points(supp_to_plot,pch=20,col="grey") #If I need to plot supplementary points not in my phylogeny
text(x=c(rep(0,1)),y=c(2,1.55),labels=c("Teleosauroidea","Metriorhynchoidea"),col=c("#800080","#5ab3b3"),pos=4,cex=0.7) #color legend
#text(x=c(rep(0,4)),y=c(1.67,1.64,1.61,1.58,1.55),labels=c("leptocleidians","early elasmosaurids","euelasmosauridans","aristonectine euelasmosauridans",
#"indeterminate elasmosaurids"),col=c("#01abe9","#23CC8F","#ff952c","#FF0D68","grey"),pos=4,cex=0.7) #color legend

}




if(BoneType == "Humerus_Dyro")
{	
phenogram(Cons_tree_eq,c(List_ratio,anc_ratio),ylab = "Humerus ratio length/mid-width",fsize = 0.8,ftype="i",spread.labels=TRUE)

rect(xleft=root-199.3 ,ybottom=min(List_ratio)-0.05,xright=root-190.8 ,ytop=max(List_ratio)+0.05,col="#cccccc50",border="NA") #Sinemurian
rect(xleft=root-182.7,ybottom=min(List_ratio)-0.05,xright=root-174.1 ,ytop=max(List_ratio)+0.05,col="#cccccc50",border="NA") #Toarcian
rect(xleft=root-170.3,ybottom=min(List_ratio)-0.05,xright=root-168.3 ,ytop=max(List_ratio)+0.05,col="#cccccc50",border="NA") #Bajocian
rect(xleft=root-166.1,ybottom=min(List_ratio)-0.05,xright=root-163.5 ,ytop=max(List_ratio)+0.05,col="#cccccc50",border="NA") #Callovian
rect(xleft=root-157.3,ybottom=min(List_ratio)-0.05,xright=root-152.1 ,ytop=max(List_ratio)+0.05,col="#cccccc50",border="NA") #Kimmeridgian
rect(xleft=root-145,ybottom=min(List_ratio)-0.05,xright=root-139.8,ytop=max(List_ratio)+0.05,col="#cccccc50",border="NA") #Berriasian
rect(xleft=root-132.9,ybottom=min(List_ratio)-0.05,xright=root-129.4,ytop=max(List_ratio)+0.05,col="#cccccc50",border="NA") #Hauterivian
rect(xleft=root-125,ybottom=min(List_ratio)-0.05,xright=root-113,ytop=max(List_ratio)+0.05,col="#cccccc50",border="NA") #Aptian
rect(xleft=root-100.5,ybottom=min(List_ratio)-0.05,xright=root-93.9,ytop=max(List_ratio)+0.05,col="#cccccc50",border="NA") #Cenomanian
rect(xleft=root-89.8,ybottom=min(List_ratio)-0.05,xright=root-86.3,ytop=max(List_ratio)+0.05,col="#cccccc50",border="NA") #Coniacian
rect(xleft=root-83.6,ybottom=min(List_ratio)-0.05,xright=root-72.1,ytop=max(List_ratio)+0.05,col="#cccccc50",border="NA") #Campanian
rect(xleft=root-66.0,ybottom=min(List_ratio)-0.05,xright=root-61.6,ytop=max(List_ratio)+0.05,col="#cccccc50",border="NA") #Danian
rect(xleft=root-59.2,ybottom=min(List_ratio)-0.05,xright=root-56,ytop=max(List_ratio)+0.05,col="#cccccc50",border="NA") #Thanetian
rect(xleft=root-47.8,ybottom=min(List_ratio)-0.05,xright=root-41.2,ytop=max(List_ratio)+0.05,col="#cccccc50",border="NA") #Lutetian
rect(xleft=root-37.71,ybottom=min(List_ratio)-0.05,xright=root-33.9,ytop=max(List_ratio)+0.05,col="#cccccc50",border="NA") #Priabonian
rect(xleft=root-27.82,ybottom=min(List_ratio)-0.05,xright=root-23.03,ytop=max(List_ratio)+0.05,col="#cccccc50",border="NA") #Chattian
rect(xleft=root-201.3,ybottom=min(List_ratio)-0.15,xright=root-174.1,ytop=min(List_ratio)-0.05,col="#42AED0",border="NA") #Early Jurassic
rect(xleft=root-174.1,ybottom=min(List_ratio)-0.15,xright=root-163.5,ytop=min(List_ratio)-0.05,col="#80CFD8",border="NA") #Mid Jurassic
rect(xleft=root-163.5,ybottom=min(List_ratio)-0.15,xright=root-145,ytop=min(List_ratio)-0.05,col="#B3E3EE",border="NA") #Late Jurassic
 rect(xleft=root-145,ybottom=min(List_ratio)-0.15,xright=root-100.5,ytop=min(List_ratio)-0.05,col="#94cc79",border="NA") #Early K rectangle
 rect(xleft=root-100.5,ybottom=min(List_ratio)-0.15,xright=root-66,ytop=min(List_ratio)-0.05,col="#afd46c",border="NA") #Late K rectangle
  rect(xleft=root-66,ybottom=min(List_ratio)-0.15,xright=root-23.03,ytop=min(List_ratio)-0.05,col="#FDA75F",border="NA") #Paleogene
 rect(xleft=root-23.03,ybottom=min(List_ratio)-0.15,xright=root-2.58,ytop=min(List_ratio)-0.05,col="#FFE619",border="NA") #Neogene
 #rect(xleft=root-2.58,ybottom=min(List_ratio)-0.15,xright=root-66,ytop=min(List_ratio)-0.05,col="#F9F97F",border="NA") #Quaternary
# text(x=c(root-122.74,root-83.25),y=rep(min(List_ratio)-0.1,2),labels=c("Early Cretaceous","Late Cretaceous"),cex=0.7) 
# text(x=c(root-145,root-100.5,root-66),y=rep(min(List_ratio)-0.17,3),labels=c(145,100.5,66),cex=0.7)

points(pheno,pch=20,col=c(rep("#FFE619",7),rep("#1A9D6F",4))) #Yellow "#FFE619" = Crocodylia – # Green "#1A9D6F" = Dyrosauridae #position of points is based on phylogenetic tree order
#points(supp_to_plot,pch=20,col="grey") #If I need to plot supplementary points not in my phylogeny
text(x=c(rep(0,1)),y=c(2,1.55),labels=c("Crocodylia","Dyrosauridae"),col=c("#FFE619","#1A9D6F"),pos=4,cex=0.7) #color legend
#text(x=c(rep(0,4)),y=c(1.67,1.64,1.61,1.58,1.55),labels=c("leptocleidians","early elasmosaurids","euelasmosauridans","aristonectine euelasmosauridans",
#"indeterminate elasmosaurids"),col=c("#01abe9","#23CC8F","#ff952c","#FF0D68","grey"),pos=4,cex=0.7) #color legend

}


dev.off()

