#####################################################################
### R script for convergence tests 									              ###
### Written by V. Fischer 2022                                		###
### Associated paper: Scavezzoni & Fischer 2023.					        ###
#####################################################################

#### 1. Packages
library(ape)
library(convevol)
library(geoscale)
library(paleotree)
library(strap)
library(TreeTools)


#### 2. Build phylo tree

Croc_trees<-read.nexus("~/EDDy Lab Dropbox/Valentin Fischer/Research/A_Projects/D_General_MR/Scavezzoni Sea Crocs/PostcranialPaper/Data/Landmark_Phylomorpho/Jouve2020.nex")
Croc_tree <- Croc_trees[[1]] #selects first MP tree to run convergence tests

#First change some names
Croc_tree$tip.label[which(Croc_tree$tip.label=="Steneosaurus_obtusidens")] <- "Lemmysuchus_obtusidens"
Croc_tree$tip.label[which(Croc_tree$tip.label=="Steneosaurus_edwardsi")] <- "Neosteneosaurus_edwardsi"
Croc_tree$tip.label[which(Croc_tree$tip.label=="Steneosaurus_leedsi")] <- "Charitomenosuchus_leedsi"
Croc_tree$tip.label[which(Croc_tree$tip.label=="Steneosaurus_bollensis")] <- "Macrospondylus_bollensis"
Croc_tree$tip.label[which(Croc_tree$tip.label=="Steneosaurus_heberti")] <- "Proexochokefalos_heberti"
Croc_tree$tip.label[which(Croc_tree$tip.label=="Metriorhynchus_superciliosus")] <- "Thalattosuchus_superciliosus"

#Then add new tips
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Rhabdognathus_sp."),label="Congosaurus_bequaerti", edgeLength = 0, lengthBelow = NULL) 
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Congosaurus_bequaerti"),label="Hyposaurus_natator", edgeLength = 0, lengthBelow = NULL) 
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Rhabdognathus_sp."),label="Acherontisuchus", edgeLength = 0, lengthBelow = NULL)
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Crocodylus_porosus"),label="Mecistops_cataphractus", edgeLength = 0, lengthBelow = NULL) 
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Geosaurus_giganteus"),label="Geosaurus_lapparenti", edgeLength = 0, lengthBelow = NULL)	
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Proexochokefalos_heberti"),label="Proexochokefalos_cf_bouchardi", edgeLength = 0, lengthBelow = NULL)
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Lemmysuchus_obtusidens"),label="Machimosaurus_hugii", edgeLength = 0, lengthBelow = NULL)
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="M_brachyrhynchus"),label="M_brachyrhynchus_3804", edgeLength = 0, lengthBelow = NULL)
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Thalattosuchus_superciliosus"),label="Thalattosuchus_superciliosus_R2032", edgeLength = 0, lengthBelow = NULL)
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Thalattosuchus_superciliosus"),label="Metriorhynchus_sp", edgeLength = 0, lengthBelow = NULL)

#Add deeper taxon
temp_node <- Croc_tree$edge[which(Croc_tree$edge[,2]==which(Croc_tree$tip.label=="Macrospondylus_bollensis")),1] #get node of Lemmy+Macro
Croc_tree <-  AddTip(Croc_tree,where=temp_node,label="Mycterosuchus_nasutus", edgeLength = 1, lengthBelow = NULL)

#Add Sericodon, Turnersuchus
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Mycterosuchus_nasutus"),label="Sericodon_jugleri", edgeLength = 0, lengthBelow = NULL)
temp_node <- Croc_tree$edge[which(Croc_tree$edge[,2]==which(Croc_tree$tip.label=="Pelagosaurus_typus")),1] #of Pelagosaurus
Croc_tree <-  AddTip(Croc_tree,where= temp_node,label="Turnersuchus_hingleyae", edgeLength = 1, lengthBelow = NULL)

FAD_LAD <- read.csv("FAD_LAD_global.csv",header=TRUE,row.names=1) #First & Last occurences
Croc_tree_mbl <- timePaleoPhy(Croc_tree,timeData=FAD_LAD,type= "mbl",vartime = 3)

pdf("FigSX_supertree.pdf",width=8, height=5)
geoscalePhylo(ladderize(Croc_tree_mbl),FAD_LAD,cex.ts=0.5,cex.tip=0.6)
dev.off()

 
#### 3. Get and tidy pca data

PCA <- dir(pattern='_PCA')
PCA_list <- list()
for(i in 1:length(PCA)){
  PCA_list[[i]] <- read.csv(PCA[i],header=TRUE)
}
names(PCA_list) <- substr(c(PCA),1,nchar(c(PCA))-8)


#### Replace PCA names with names from the phylogeny
global_convert <- read.csv("Convert_global.csv",header=TRUE)
PCA_list_unique <- list()

for (h in 1:length(names(PCA_list))){
if (names(PCA_list)[h]=="Femur_outline"){ #Femur because two different names (femur and femur_outline are indicated in the files)
for (i in 1:nrow(PCA_list$Femur_outline)){	
	PCA_list[[names(PCA_list)[h]]][i,"X"] <- global_convert[which(global_convert$Femur==PCA_list[[names(PCA_list)[h]]][i,"X"])[1],1]
}
} else{
	for (i in 1:nrow(PCA_list[[names(PCA_list)[h]]])){
		PCA_list[[names(PCA_list)[h]]][i,"X"] <- global_convert[which(global_convert[[names(PCA_list)[h]]]==PCA_list[[names(PCA_list)[h]]][i,"X"])[1],1]
	}
}
Occurences <- data.frame(table(PCA_list[[names(PCA_list)[h]]]$X))
	PCA_list_unique[[names(PCA_list)[h]]] <- PCA_list[[names(PCA_list)[h]]][which(PCA_list[[names(PCA_list)[h]]]$X %in% Occurences[Occurences$Freq==1,1]),]
	if (sum(Occurences$Freq>1)>0){
		for(i in 1:nrow(Occurences[Occurences$Freq>1,])){
			PCA_list_unique[[names(PCA_list)[h]]] <- rbind(PCA_list_unique[[names(PCA_list)[h]]],c(as.character(Occurences[Occurences$Freq>1,1][i]),
		colMeans(PCA_list[[names(PCA_list)[h]]][which(PCA_list[[names(PCA_list)[h]]]$X==Occurences[Occurences$Freq>1,1][i]),-1])))
	}
	}
	
	names <- PCA_list_unique[[names(PCA_list)[h]]]$X
	PCA_list_unique[[names(PCA_list)[h]]] <- as.matrix(sapply(PCA_list_unique[[names(PCA_list)[h]]][,-1], as.numeric))
	rownames(PCA_list_unique[[names(PCA_list)[h]]]) <- names
}

#### 4. Convergence tests
#Get pairs to test

pairs <- dir(pattern='_pair')
pairs_list <- list()
for(i in 1:length(pairs)){
  pairs_list[[i]] <- read.csv(file=pairs[i],header=TRUE)
}
names(pairs_list) <- substr(c(pairs),1,nchar(c(pairs))-9)

nsim <- 1000


### 'Classical' Stayton 2015 C metrics


# for(i in 1:length(pairs_list)){
#   
#   #drop tips
#   Croc_tree_mbl_temp <- drop.tip(Croc_tree_mbl, Croc_tree_mbl$tip.label[!Croc_tree_mbl$tip.label %in% rownames(PCA_list_unique[[names(pairs_list)[i]]])])
#   
#   for (j in 1:nrow(pairs_list[[i]])){
#     #tips to analyse
#     convtips <- as.character(pairs_list[[i]][j,1:2])
#     #C1,C2,C3,C4 across all the axes of the PCoA
#     C_metrics <- calcConv(phy=Croc_tree_mbl_temp,traits=PCA_list_unique[[names(pairs_list)[i]]],focaltaxa=convtips)
#     #write.csv(rbind(cbind(C_metrics$ObservedCs[1],C_metrics$Pvals[1])),file=paste("Old_Stayton_",names(pairs_list)[i],"_",convtips[1],"_",convtips[2],".csv",sep=""))
#     
#   }
# }


### Stayton 2015 metrics modified by Zeldtich et al 2017 (Ct metrics)

for(i in 1:length(pairs_list)){
	
	#drop tips
	Croc_tree_mbl_temp <- drop.tip(Croc_tree_mbl, Croc_tree_mbl$tip.label[!Croc_tree_mbl$tip.label %in% rownames(PCA_list_unique[[names(pairs_list)[i]]])])

	for (j in 1:nrow(pairs_list[[i]])){
		#tips to analyse
		convtips <- as.character(pairs_list[[i]][j,1:2])
		
		#C1,C2,C3,C4 across all axes of PCoA
		Ct_metrics <- convSigCt(phy=Croc_tree_mbl_temp,traits=PCA_list_unique[[names(pairs_list)[i]]],focaltaxa=convtips,nsim=nsim) 
		write.csv(Ct_metrics$pvals,file=paste("Stayton_",names(pairs_list)[i],"_",convtips[1],"_",convtips[2],".csv",sep=""))
	}

}
 
