                      # # # # # # # # # # # # # # # # # # # # # # # #
                      # # # #                                 # # # #
                      # # # #        .PTS IMPORTATION         # # # #
                      # # # # written by N. Chatar March 2020 # # # #
                      # # # #                                 # # # #
                      # # # # # # # # # # # # # # # # # # # # # # # #


library(geomorph)
library(readxl)
library(Morpho)
library(ggplot2)
library(ggfortify)
library(ggthemes) 
library(ggrepel)

					  # # # # # # # # # # # # # # # # # # # # # # # #
                      # # # #                                 # # # #
                      # # # #      		  COMBINED 		      # # # #
                      # # # # written by N. Chatar March 2020 # # # #
                      # # # #Modifs by I. Scavezzoni Mai 2023# # # #
                      # # # # # # # # # # # # # # # # # # # # # # # #
					  
################################################################################
######################		Input parameters	################################
################################################################################

GirdleType = "Pelvic"
#GirdleType = "Thoracic"
#GirdleType = "Total"

CreateMesh3d = FALSE


################################################################################
################################################################################

if(GirdleType == "Pelvic")
{
	BoneTypes = c("Femur", "Ilium", "Ischium", "Pubis")
}

if(GirdleType == "Thoracic")
{
	BoneTypes = c("Coracoid", "Humerus", "Scapula")
}

if(GirdleType == "Total")
{
	BoneTypes = c("Coracoid","Femur", "Humerus","Ilium", "Ischium", "Pubis", "Scapula")
}

WorkingDirectory <-  "C:\\Users\\Admin\\Dropbox (EDDy Lab)\\Scavezzoni Sea Crocs\\PostcranialPaper\\Data"

################################################################################
######################		COMBINED			################################
################################################################################

procrustes <- c()

for(j in 1:length(BoneTypes))
{
	print(paste0(GirdleType,"\\",BoneTypes[j]))

	# Define the working directory
	#setwd(paste0("C:\\Users\\Admin\\Dropbox (EDDy Lab)\\Scavezzoni Sea Crocs\\Landmarks_Decimated_models\\Combined\\",GirdleType,"\\",BoneTypes[j]))
    



# Define the working directory
setwd(paste0(WorkingDirectory,"\\Models\\Combined\\",GirdleType,"\\",BoneTypes[j]))

	# Create the list with .pts files
	ptslist<-dir(pattern='.pts')

	# Creation of the array with the dimensions being A: number of landmarks + semilandmarks, B: 2 or 3 dimensions--> c(A,B)
	nbrPts <- dim(as.matrix(read.table(file=ptslist[1],skip=2,header=F,sep="",row.names=1)))[1]
	ptsarray<-array(dim=c(nbrPts,3,length(ptslist))) #276 Ilium #170 Ischium #116 Pubis # 82 Pubis Outline #200 Femur Repaired #181 Femur Repaired No trochanter
													#194 Coracoid	#196 Scapula	#180 Humerus



	# readland.tps() #trouve les courbes readcurves = TRUE
	# #



	for(i in 1:length(ptslist))
	{
	print(ptslist[i])
	  ptsarray[,,i]<-as.matrix(read.table(file=ptslist[i],skip=2,header=F,sep="",row.names=1))
	}



	# Rename each specimen with the name of the ".pts" file by removing the .pts
	# ptsarray)[[3] if 3 dimensions, ptsarray)[[2] if only 2

	dimnames(ptsarray)[[3]] <- c(substr(c(ptslist),1,nchar(c(ptslist))-4))

	# Rename each landmark its name from the pts file
	# ptsarray)[[3] if 3 dimensions, ptsarray)[[2] if only 2
	dimnames(ptsarray)[[1]] <- c(read.table(file=ptslist[1],skip=2,header=F,sep="")[,1])


	taxa_list <- substr(c(ptslist),1,nchar(c(ptslist))-4)

	#Create mesh3d objects named as the ply files, it can be very long  depending on the number of files 
	if(CreateMesh3d) {
		meshlist <- list()
		for(i in 1:length(taxa_list)){ 
		  meshlist[[i]] <- assign(taxa_list[i],read.ply(file=paste(taxa_list[i],".ply",sep=""), ShowSpecimen=FALSE))
		  print(paste(round(100*(i/length(taxa_list)),1),"%"))
		}

		names(meshlist) <- taxa_list
	}

	###################################
	######### PROCRUSTES 
	###################################

	readland.tps #trouve les courbes readcurves = TRUE

	semilandmarks <- read.csv("sliders.csv", sep = ",", header = TRUE)


	landmarks_names <- row.names(ptsarray[,,1])
	nbrFixed <- sum(sapply(landmarks_names, function(i) return (substr(i,1,1) == "S")))
	nbrCurves <- sum(sapply(landmarks_names, function(i) return (substr(i,1,1) == "C")))

	fixed <- 1:nbrFixed 
	cur <- (nbrFixed+1):(nbrFixed+nbrCurves) 
	semi <- nbrPts- nbrFixed - nbrCurves
	surface <- c(1:semi)




	###Slide and General Procrustes Analysis directly with geomorph with 1 sliders file
	procrustes[BoneTypes[j]] <- gpagen(ptsarray,curves=semilandmarks,surfaces=surface,ProcD=FALSE) #GPA
	#arrayspecs(procrustes["Femur"],length(landmarks_names),3)

}


###################################################################
######################## COMBINE SETS #############################
###################################################################

if(GirdleType == "Pelvic")
{
	comb.lm <- combine.subsets(femur = procrustes[["Femur"]], ilium = procrustes[["Ilium"]], ischium = procrustes[["Ischium"]], pubis = procrustes[["Pubis"]], gpa = TRUE) # Combine with GPA and relative centroid size
}

if(GirdleType == "Thoracic")
{
	comb.lm <- combine.subsets(coracoid = procrustes[["Coracoid"]], scapula = procrustes[["Humerus"]], humerus = procrustes[["Scapula"]], gpa = TRUE) # Combine with GPA and relative centroid size
}



if(GirdleType == "Total")
{
	comb.lm <- combine.subsets(femur = procrustes[["Femur"]], ilium = procrustes[["Ilium"]], ischium = procrustes[["Ischium"]], pubis = procrustes[["Pubis"]],coracoid = procrustes[["Coracoid"]], scapula = procrustes[["Humerus"]], humerus = procrustes[["Scapula"]], gpa = TRUE) # Combine with GPA and relative centroid size
}



#comb.lm <- combine.subsets(femur = femur.procrust, ilium = ilium.procrust, ischium = ischium.procrust, pubis = pubis.procrust, gpa = TRUE) # Combine with GPA and relative centroid size
summary(comb.lm)
plotAllSpecimens(comb.lm$coords)

# show all specimens
#comb.lm$coords

# comb.lm <- combine.subsets(coracoid = coracoid.procrust, scapula = scapula.procrust, humerus = humerus.procrust, gpa = TRUE) # Combine with GPA and relative centroid size
# summary(comb.lm)
# plotAllSpecimens(comb.lm$coords)

# comb.lm <- combine.subsets(femur = femur.procrust, ilium = ilium.procrust, ischium = ischium.procrust, pubis = pubis.procrust, coracoid = coracoid.procrust, scapula = scapula.procrust, humerus = humerus.procrust, gpa = TRUE) # Combine with GPA and relative centroid size
# summary(comb.lm)
# plotAllSpecimens(comb.lm$coords)


 # # Combine with GPA and relative centroid size
 
# comb.lm <- combine.subsets(head = head.gpa, tail = tail.gpa, gpa = TRUE)
# summary(comb.lm)

# # (configurations are actual relative size)
# comb.lm$coords[,,1]

# # # Plot all specimens and just first specimen and color code landmarks 
# par(mfrow = c(1,2))
# plotAllSpecimens(comb.lm$coords)
# plot(comb.lm$coords[,,1], pch = 21, bg = c(rep(1,26), 
# rep(2,64)), asp = 1)






# #Check if position of 3DLM appear correct
# spheres3d(GPA$coords[,,"Pelagosaurus_typus"],radius=c(rep(0.001,5),rep(0.001,2000)),color=c(rep("#FF0D68",5),rep("#23CC8F",nrow(patched[,,1]))))


#=======================================================#
#===================== Morphospace =====================#
#=======================================================#

# # # PCA # # # 

PCA <- gm.prcomp(comb.lm$coords)
eigenvalues <- PCA$d
scores <- PCA$x

# # # Labels # # # 

# Create as many vectors as you need to differentiate your specimens in the plot. Vectors need to be 
# the size of the dataset. You can repeat several times the same term by using: rep() 
# rep("The Word You Want To Repeat", X)
# If, for instance, you would like to display only some specimen number just fill the position of the 
# specimen with a blank " ", e.g. label_specimen_PCA  <- c("ULg-1", " " , "ULg-3")


######  PELVIC  ######			
if(GirdleType == "Pelvic")
{				
	color_group_PCA     <- c("Teleosauroidea",
							"Dyrosauridae",
							"Teleosauroidea",
							"Metriorhynchoidea",
							"Metriorhynchoidea",
							"Crocodylia",
							"Metriorhynchoidea",
							"Teleosauroidea",
							"Metriorhynchoidea")
}
							
######  THORACIC  ######	
if(GirdleType == "Thoracic")
{						
	color_group_PCA     <- c("Teleosauroidea",
							"Dyrosauridae",
							"Dyrosauridae",
							"Teleosauroidea",
							"Crocodylia",
							"Metriorhynchoidea",
							"Teleosauroidea",
							"Teleosauroidea",
							"Metriorhynchoidea",
							"Metriorhynchoidea")
}

######  TOTAL  ######							
if(GirdleType == "Total")
{
		color_group_PCA     <- c("Teleosauroidea",
							"Dyrosauridae",
							"Teleosauroidea",
							"Crocodylia",
							"Teleosauroidea",
							"Metriorhynchoidea") 
} 
	########################################################################################################						
#label_specimen_PCA  <- c(XXX)
# or simply if you named your pts files with the labels you want to use:

####label_specimen_PCA  <- row.names(PCA$x) #POU
label_specimen_PCA <- taxa_list


					
# I just put some random colors and shape, choose whatever you want. This will allow you to always
# have the same colors for you taxa in all your analyses. 

# # # Plot # # #

# Creation of the df for the ggplot
df_pca <-cbind(as.data.frame(scores[,1:2]),label_specimen_PCA, color_group_PCA )
    

    


#Create a convex hull to plot on the ggplot
split(df_pca[,1:2], df_pca$color_group_PCA )
chull_PCA <- lapply(split(df_pca, df_pca$color_group_PCA), function(df){
  df[chull(df),]
})

chull_PCA <- do.call(rbind, chull_PCA)


PC1 <- round(((eigenvalues[1]/sum(eigenvalues))*100), digits = 2)
PC2 <- round(((eigenvalues[2]/sum(eigenvalues))*100), digits = 2)
    
PCA_graphe <- ggplot(data=df_pca[,1:2],aes(x=df_pca[,1],y=df_pca[,2],color=color_group_PCA)) +
              theme_minimal() +
              geom_point(size= 3,alpha=0.5) +
              geom_text_repel(aes(label=label_specimen_PCA), size=3) +
              labs(x = paste0('PC1 = ', PC1, '%'), 
                   y = paste0('PC2 = ', PC2, '%')) +              
              geom_rangeframe(color = "black") +
              geom_polygon(data=chull_PCA, aes(x=Comp1 , y=Comp2 , fill=color_group_PCA), alpha=0.2)
              #  + scale_color_manual(values = colors_to_plot) +
              # scale_fill_manual(values = colors_to_plot) +
              # scale_shape_manual(values=shape_to_plot) 
PCA_graphe



				########################### SAVING THE GRAPH #########################
				
				
ggsave(paste0("PCA_",GirdleType,"_Repaired",".pdf"),device="pdf",units="mm",width=240,height=240) #sauvegarde le graphe affiché

plotratio <- PC2/PC1
ggsave(paste0("PCA_",GirdleType,"_Scaled",".pdf"),device="pdf",units="mm",width=240,height=240*plotratio) #sauvegarde le graphe affiché



              # # # # # # # # # # # # # # # # # # # # # # # # # #
              # # # #                                     # # # #
              # # # #           Procrustes ANOVA          # # # #
              # # # #                                     # # # #
              # # # # # # # # # # # # # # # # # # # # # # # # # #

# Creates 2D list from combined Procrustes
ListProcrust<-two.d.array(comb.lm$coords)


# Use geomorph.data.frame to reate a data frame with shape data and include your group color_group_PCA variable (or another if needed)
gdf <- geomorph.data.frame(coords=ListProcrust, ClusteringVariable = as.factor(color_group_PCA))

# Compute a procrustes ANOVA to look for a relationship between the shape (coords) and your categorical variable, e.g. genus, species, family, diet, etc. (color_group_PCA)
fit <- procD.lm(coords~color_group_PCA,data=gdf,iter=999)
summary(fit)





              # # # # # # # # # # # # # # # # # # # # # # # # # #
              # # # #                                     # # # #
              # # # #				PHYLOGENY	          # # # #
              # # # #                                     # # # #
              # # # # # # # # # # # # # # # # # # # # # # # # # #
			  
			  

library(ape)
library(TreeSearch)
library(TreeTools)

library(paleotree)
library(strap)
library(treeio)
library(viridis)
library(deeptime)
library(phytools)
library(evobiR)
library(rgl)
library(geomorph)
library(readxl)
library(Morpho)
library(ggplot2)
library(ggfortify)
library(ggthemes) 
library(ggrepel)
library(ggtree)


library(stringr)


setwd(paste0(WorkingDirectory,"\\Landmark_Phylomorpho"))

Croc_trees<-read.nexus("Jouve2020.nex")
mod_trees <- list()
sample <- sample(1:length(Croc_trees),100)
class(mod_trees) <- "multiphylo"


for (i in 1:length(sample)){
Croc_tree <- Croc_trees[[sample[i]]]

#First change some names
Croc_tree$tip.label[which(Croc_tree$tip.label=="Steneosaurus_obtusidens")] <- "Lemmysuchus_obtusidens"
Croc_tree$tip.label[which(Croc_tree$tip.label=="Steneosaurus_edwardsi")] <- "Neosteneosaurus_edwardsi"
Croc_tree$tip.label[which(Croc_tree$tip.label=="Steneosaurus_leedsi")] <- "Charitomenosuchus_leedsi"
Croc_tree$tip.label[which(Croc_tree$tip.label=="Steneosaurus_bollensis")] <- "Macrospondylus_bollensis"
Croc_tree$tip.label[which(Croc_tree$tip.label=="Steneosaurus_heberti")] <- "Proexochokefalos_heberti"
Croc_tree$tip.label[which(Croc_tree$tip.label=="Metriorhynchus_superciliosus")] <- "Thalattosuchus_superciliosus"


#Then add new tips
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Rhabdognathus_sp."),label="Congosaurus_bequaerti", edgeLength = 0, lengthBelow = NULL) 
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Congosaurus_bequaerti"),label="Hyposaurus_natator", edgeLength = 0, lengthBelow = NULL) 
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Rhabdognathus_sp."),label="Acherontisuchus", edgeLength = 0, lengthBelow = NULL)
Croc_tree <- DropTip(Croc_tree, "Rhabdognathus_sp.", preorder = TRUE, check = TRUE)
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Crocodylus_porosus"),label="Mecistops_cataphractus", edgeLength = 0, lengthBelow = NULL) 
Croc_tree <- DropTip(Croc_tree, "Crocodylus_porosus", preorder = TRUE, check = TRUE)

Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="M_brachyrhynchus"),label="M_brachyrhynchus3804", edgeLength = 0, lengthBelow = NULL) 
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="M_brachyrhynchus"),label="M_brachyrhynchus4763", edgeLength = 0, lengthBelow = NULL) 
Croc_tree <- DropTip(Croc_tree, "M_brachyrhynchus", preorder = TRUE, check = TRUE)
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Thalattosuchus_superciliosus"),label="Thalattosuchus_superciliosus950", edgeLength = 0, lengthBelow = NULL) 
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Thalattosuchus_superciliosus"),label="Thalattosuchus_superciliosus960", edgeLength = 0, lengthBelow = NULL) 
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Thalattosuchus_superciliosus"),label="Thalattosuchus_superciliosus1005", edgeLength = 0, lengthBelow = NULL) 
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Thalattosuchus_superciliosus"),label="Thalattosuchus_superciliosus1016", edgeLength = 0, lengthBelow = NULL) 
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Thalattosuchus_superciliosus"),label="Thalattosuchus_superciliosus1143", edgeLength = 0, lengthBelow = NULL) 
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Thalattosuchus_superciliosus"),label="Thalattosuchus_superciliosus1146", edgeLength = 0, lengthBelow = NULL) 
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Thalattosuchus_superciliosus"),label="Thalattosuchus_superciliosusR1530", edgeLength = 0, lengthBelow = NULL) 
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Thalattosuchus_superciliosus"),label="Thalattosuchus_superciliosusR2032", edgeLength = 0, lengthBelow = NULL) 
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Thalattosuchus_superciliosus"),label="Thalattosuchus_superciliosusR2054", edgeLength = 0, lengthBelow = NULL) 
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Thalattosuchus_superciliosus"),label="Thalattosuchus_superciliosusPMU35988", edgeLength = 0, lengthBelow = NULL)
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Geosaurus_giganteus"),label="Geosaurus_lapparenti", edgeLength = 0, lengthBelow = NULL)	
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="M_brachyrhynchus3804"),label="Tyrannoneustes972", edgeLength = 0, lengthBelow = NULL)
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Tyrannoneustes972"),label="Tyrannoneustes1145", edgeLength = 0, lengthBelow = NULL)
#Proexochokefalos_cf_bouchardi added
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Proexochokefalos_heberti"),label="Proexochokefalos_cf_bouchardi", edgeLength = 0, lengthBelow = NULL)
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Neosteneosaurus_edwardsi"),label="Neosteneosaurus3169", edgeLength = 0, lengthBelow = NULL)
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Neosteneosaurus_edwardsi"),label="Neosteneosaurus3701", edgeLength = 0, lengthBelow = NULL)	
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Neosteneosaurus_edwardsi"),label="Neosteneosaurus2076", edgeLength = 0, lengthBelow = NULL)
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Neosteneosaurus_edwardsi"),label="Neosteneosaurus2865", edgeLength = 0, lengthBelow = NULL)
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Lemmysuchus_obtusidens"),label="Machimosaurus_hugii", edgeLength = 0, lengthBelow = NULL)

#Add deeper taxon
temp_node <- Croc_tree$edge[which(Croc_tree$edge[,2]==which(Croc_tree$tip.label=="Macrospondylus_bollensis")),1] #get node of Lemmy+Macro
Croc_tree <-  AddTip(Croc_tree,where=temp_node,label="Mycterosuchus_nasutus", edgeLength = 1, lengthBelow = NULL)

#Sericodon added
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Mycterosuchus_nasutus"),label="Sericodon_jugleri", edgeLength = 0, lengthBelow = NULL)

# #Add Turnersuchus_hingleyae at the base of Thalattosuchia so change so it is 2 nodes from Pelagosaurus:
# temp_node <- which(Croc_tree$tip.label=="Pelagosaurus_typus")
# temp_node <- Croc_tree$edge[which(Croc_tree$edge[,2]==temp_node),1]
# temp_node <- Croc_tree$edge[which(Croc_tree$edge[,2]==temp_node),1]
# temp_node <- Croc_tree$edge[which(Croc_tree$edge[,2]==temp_node),1]
# temp_node <- Croc_tree$edge[which(Croc_tree$edge[,2]==temp_node),1]
# temp_node <- Croc_tree$edge[which(Croc_tree$edge[,2]==temp_node),1]
# temp_node <- Croc_tree$edge[which(Croc_tree$edge[,2]==temp_node),1]
# temp_node <- Croc_tree$edge[which(Croc_tree$edge[,2]==temp_node),1]
# temp_node <- Croc_tree$edge[which(Croc_tree$edge[,2]==temp_node),1]


# Croc_tree <-  AddTip(Croc_tree,where=temp_node,label="Turnersuchus_hingleyae", edgeLength = 1, lengthBelow = NULL)
Croc_tree <-  AddTip(Croc_tree,where=0,label="Turnersuchus_hingleyae", edgeLength = 1, lengthBelow = NULL)

# #Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Charitomenosuchus_leedsi"),label="Turnersuchus_hingleyae", edgeLength = 0, lengthBelow = NULL)


mod_trees[[i]] <- Croc_tree	
}
#Need to add Turnersuchus_hingleyae,
#plot(Croc_tree,cex=0.5);nodelabels(cex=0.4)


############ SCALE THE TREES IN TIME #############

FAD_LAD <- read.csv(paste0("FAD_LAD_",GirdleType,".csv"),header=TRUE,row.names=1) #First & Last occurences

Bone_trees <- lapply(mod_trees, keep.tip,tip=rownames(FAD_LAD))
node_mins <- rep(NA,(Nnode(Bone_trees[[1]])))
node_mins[1] <- 219 #root
node_mins[Bone_trees[[1]]$edge[which(Bone_trees[[1]]$edge[,2]==which(Bone_trees[[1]]$tip.label=="Mecistops_cataphractus")),1]-Ntip(Bone_trees[[1]])] <- 201.5 #Neosuchian split
Bone_trees <- unlist(lapply(Bone_trees, timePaleoPhy,timeData=FAD_LAD,dateTreatment="minMax",randres=TRUE,ntrees=100,type="mbl",vartime=3,node.mins=node_mins),recursive=FALSE)
class(Bone_trees)<-"multiPhylo"

#Cons_tree <- consensus(Bone_trees)
Cons_tree <- consensus(Bone_trees, rooted=TRUE)
# if(BoneType == "Scapula")
# {
	# Cons_tree <- DropTip(Cons_tree, "Turnersuchus_hingleyae", preorder = TRUE, check = TRUE)
	# Cons_tree <-  AddTip(Cons_tree,where=0,label="Turnersuchus_hingleyae", edgeLength = 1, lengthBelow = NULL)
# }
plot(Cons_tree)



Cons_tree_eq <- timePaleoPhy(Cons_tree,timeData=FAD_LAD,type= "mbl",vartime = 3,node.mins =node_mins)


pdf(paste0(GirdleType,"_timescale.pdf"),width=8, height=11)
geoscalePhylo((Bone_trees[[999]]),FAD_LAD,cex.ts=0.5,cex.tip=0.6)
dev.off()





###################################################################################################
###################################################################################################
###################################################################################################
###################################################################################################
###################################################################################################
###################################################################################################
###################################################################################################
###################################################################################################
###################################################################################################
###################################################################################################
###################################################################################################
###################################################################################################


Phy_tree_eq <- Cons_tree_eq

if(GirdleType == "Thoracic")
{
	#Use taxa_list to find order, replace with the name of the tips from Cons_tree$tip.label
	taxa_list_coords <- c("Charitomenosuchus_leedsi","Congosaurus_bequaerti","Hyposaurus_natator","Lemmysuchus_obtusidens","Mecistops_cataphractus","Mycterosuchus_nasutus","Neosteneosaurus_edwardsi","Thalattosuchus_superciliosus","Thalattosuchus_superciliosus1143","Thalattosuchus_superciliosus1146")
}


if(GirdleType == "Pelvic")
{
	#Use taxa_list to find order, replace with the name of the tips from Cons_tree$tip.label
	taxa_list_coords <- c("Charitomenosuchus_leedsi", "Hyposaurus_natator","Lemmysuchus_obtusidens", "M_brachyrhynchus4763","M_brachyrhynchus3804", "Mecistops_cataphractus","Neosteneosaurus_edwardsi", "Thalattosuchus_superciliosus","Thalattosuchus_superciliosus1005")
}


if(GirdleType == "Total")
{
	#Use taxa_list to find order, replace with the name of the tips from Cons_tree$tip.label
	taxa_list_coords <- c("Charitomenosuchus_leedsi", "Hyposaurus_natator","Lemmysuchus_obtusidens", "Mecistops_cataphractus","Neosteneosaurus_edwardsi", "Thalattosuchus_superciliosus")
}

renamedCoords <- comb.lm$coords
dimnames(renamedCoords)[[3]] <- taxa_list_coords


PS.shape <- physignal(A=renamedCoords[1:10,1:2,],phy=Phy_tree_eq,iter=999)
summary(PS.shape)
plot(PS.shape) #Plot K and P values
plot(PS.shape$PACA, phylo = TRUE) #Plot phylomorphospace
PS.shape$K.by.p # Phylogenetic signal profile



###################################################################################################
###################################################################################################
###################################################################################################
###################################################################################################
###################################################################################################
###################################################################################################
###################################################################################################
###################################################################################################
###################################################################################################
###################################################################################################
###################################################################################################
###################################################################################################
###################################################################################################
###################################################################################################








###################################################################################################
#############################				TEST MANTEL					###########################
###################################################################################################

# ###### TEST MANTEL #####


# library(evolqg)
library(vegan)
library(adephylo)

#Create distance matrix for ListProcrust
sortedCoords <- two.d.array(renamedCoords)
sortedCoords <- sortedCoords[match(Cons_tree_eq$tip.label, rownames(sortedCoords)),]

DistProcrust<-dist(sortedCoords)

Phylo_dist <- distTips(Cons_tree_eq,method="patristic")


mantel(xdis=DistProcrust, ydis=Phylo_dist, permutations=999)

###################################################################################################
#############################		Creation phylomorphospace		###############################
###################################################################################################



# Creation of the df for the phylomorphospace    
    df_pca_phylo <- as.data.frame(scores[,1:2])
	#Tree labels to check label creation 
		Cons_tree$tip.label
		
		
	####### 	Create labels same as tree but matching order of landmarks		#######
	
if(GirdleType == "Thoracic")
{
	#Use taxa_list to find order, replace with the name of the tips from Cons_tree$tip.label
	label_specimen <- c("Charitomenosuchus_leedsi","Congosaurus_bequaerti","Hyposaurus_natator","Lemmysuchus_obtusidens","Mecistops_cataphractus","Mycterosuchus_nasutus","Neosteneosaurus_edwardsi","Thalattosuchus_superciliosus","Thalattosuchus_superciliosus1143","Thalattosuchus_superciliosus1146")
}


if(GirdleType == "Pelvic")
{
	#Use taxa_list to find order, replace with the name of the tips from Cons_tree$tip.label
	label_specimen <- c("Charitomenosuchus_leedsi", "Hyposaurus_natator","Lemmysuchus_obtusidens", "M_brachyrhynchus4763","M_brachyrhynchus3804", "Mecistops_cataphractus","Neosteneosaurus_edwardsi", "Thalattosuchus_superciliosus","Thalattosuchus_superciliosus1005")
}


if(GirdleType == "Total")
{
	#Use taxa_list to find order, replace with the name of the tips from Cons_tree$tip.label
	label_specimen <- c("Charitomenosuchus_leedsi", "Hyposaurus_natator","Lemmysuchus_obtusidens", "Mecistops_cataphractus","Neosteneosaurus_edwardsi", "Thalattosuchus_superciliosus")
}

	df_pca_phylo <-cbind (df_pca_phylo,label_specimen)
	df_pca_phylo



################################################################################
###########################		PHYLOMORPHOSPACE	############################
################################################################################

Cons_tree_eq2 <- Cons_tree_eq
df_pca_phylo2 <- df_pca_phylo
species_list <- unique(label_specimen)
specimen_bucket <- setNames(rep(0, length(species_list)),species_list)

for(i in 1:length(label_specimen))
{
	specimen_bucket[label_specimen[i]] <- specimen_bucket[label_specimen[i]] + 1
	if(specimen_bucket[label_specimen[i]] > 1)
	{	
		#Putting edgeLength=0 gives an error in phylomorphospace
		Cons_tree_eq2 <- AddTip(Cons_tree_eq2, where=label_specimen[i], label=paste0(label_specimen[i], specimen_bucket[label_specimen[i]]), 
			edgeLength = 0.000001, lengthBelow = 0)
			
		df_pca_phylo2[i,3] <- paste0(df_pca_phylo2[i,3], specimen_bucket[label_specimen[i]])
	}
}
row.names(df_pca_phylo2) <- df_pca_phylo2[,3]

plot(Cons_tree_eq2)

#BUG

phylomorphospace(Cons_tree_eq2,df_pca_phylo2[,1:2], A=NULL, label=c("horizontal"),xlab="PC1",ylab="PC2",node.size=c(0,1))


Cons_tree_eq3 <- Cons_tree_eq2

# now add the era map
Cons_tree_eq3<-make.era.map(Cons_tree_eq3,0:99)
# choose the color scale
colors<-rainbow(100,start=0,end=0.7)
names(colors)<-1:100
# check it
plotSimmap(Cons_tree_eq3,colors,pts=FALSE,lwd=6)

# plot phylomorphospace with colors
phylomorphospace(Cons_tree_eq3,df_pca_phylo2[,1:2],colors=colors,node.by.map=TRUE, lwd=4,node.size=c(0,1.5),label="horizontal",xlab="PC1",ylab="PC2")
#add.color.bar(cols=colors,leg=15,title="time since the root",subtitle="",lims=c(0,max(nodeHeights(Cons_tree_eq3))))





#Computing multidimensional phylogenetic scatterplot matrix
X <- df_pca_phylo2[,1:2]
fancyTree(Cons_tree_eq2,type="scattergram",X=X,fsize=0.8)




########## EXPORT PHYLOMORPHOSPACE ############




pdf(paste0(GirdleType,"_phylomorphospace",".pdf"), height = 600, width =600)
phylomorphospace(Cons_tree_eq2, df_pca_phylo2[,1:2], A=NULL, label=c("horizontal"),xlab="PC1",ylab="PC2",node.size=c(0,1))
dev.off()


#plot(Bone_tree_eq2)




pdf(paste0(GirdleType,"_phylomorphospace_color",".pdf"), height = 600, width =600)
phylomorphospace(Cons_tree_eq3,df_pca_phylo2[,1:2],colors=colors,node.by.map=TRUE, lwd=4,node.size=c(0,2),label="horizontal",xlab="PC1",ylab="PC2")
#add.color.bar(cols=colors,leg=15,title="time since the root",subtitle="",lims=c(0,max(nodeHeights(Bone_tree_eq3))))
dev.off()


#ggsave(paste0(GirdleType,"_phylomorphospace_color",".pdf",sep=""),device="pdf",units="mm",width=240,height=240) 

################################################################################################################################################################
################################################################################################################################################################


