


###############################################################################
### Phylomorphospace and landmarks							  	     		###
###	Scavezzoni 2022, adapted from the code of N. Chatar and V. Fischer		###
###############################################################################



################################################################################
######################		Input parameters	################################
################################################################################

#Comment/Uncomment to choose the type of bone for the analysis
#BoneType = "Scapula"
#BoneType = "Coracoid"
BoneType = "Humerus"
#BoneType = "Ilium"
#BoneType = "Ischium"
#BoneType = "Pubis"
#BoneType = "Femur_outline"


#Change to local path where Data directory is, don't forget to turn any '\' to '\\'
WorkingDirectory <-  "C:\\Users\\Admin\\Dropbox (EDDy Lab)\\Scavezzoni Sea Crocs\\PostcranialPaper\\Data"

#For VF
#WorkingDirectory <- "~/EDDy Lab Dropbox/Valentin Fischer/Research/A_Projects/D_General_MR/Scavezzoni Sea Crocs/PostcranialPaper/Data"
#

#Set to TRUE if you want to auto-install all required packages
AutoInstallPackages <-  FALSE






################################################################################
######################		Packages			################################
################################################################################

if(AutoInstallPackages)
{
	install.packages("ape")
	install.packages("TreeSearch")
	install.packages("TreeTools")
	install.packages("paleotree")
	install.packages("strap")
	install.packages("treeio")
	install.packages("viridis")
	install.packages("deeptime")
	install.packages("phytools")
	install.packages("evobiR")
	install.packages("geomorph")
	install.packages("readxl")
	install.packages("Morpho")
	install.packages("ggplot2")
	install.packages("ggfortify")
	install.packages("ggthemes")
	install.packages("ggrepel")
	install.packages("stringr")
	install.packages("vegan")
	install.packages("adephylo")
}

library(ape)
library(TreeSearch)
library(TreeTools)
library(dendextend)
library(paleotree)
library(strap)
library(treeio)
library(viridis)
library(deeptime)
library(phytools)
library(evobiR)
library(rgl)
library(geomorph)
library(readxl)
library(Morpho)
library(ggplot2)
library(ggfortify)
library(ggthemes) 
library(ggrepel)
library(stringr)
library(vegan)
library(adephylo)





################################################################################
###########################		PHYLOGENY	####################################
################################################################################



setwd(paste0(WorkingDirectory,"\\Landmark_Phylomorpho"))

Croc_trees<-read.nexus("Jouve2020.nex")
mod_trees <- list()
sample <- sample(1:length(Croc_trees),100)
class(mod_trees) <- "multiphylo"


for (i in 1:length(sample)){
Croc_tree <- Croc_trees[[sample[i]]]

#First change some names
Croc_tree$tip.label[which(Croc_tree$tip.label=="Steneosaurus_obtusidens")] <- "Lemmysuchus_obtusidens"
Croc_tree$tip.label[which(Croc_tree$tip.label=="Steneosaurus_edwardsi")] <- "Neosteneosaurus_edwardsi"
Croc_tree$tip.label[which(Croc_tree$tip.label=="Steneosaurus_leedsi")] <- "Charitomenosuchus_leedsi"
Croc_tree$tip.label[which(Croc_tree$tip.label=="Steneosaurus_bollensis")] <- "Macrospondylus_bollensis"
Croc_tree$tip.label[which(Croc_tree$tip.label=="Steneosaurus_heberti")] <- "Proexochokefalos_heberti"



#Then add new tips
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Rhabdognathus_sp."),label="Congosaurus_bequaerti", edgeLength = 0, lengthBelow = NULL) 
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Congosaurus_bequaerti"),label="Hyposaurus_natator23368", edgeLength = 0, lengthBelow = NULL) 
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Hyposaurus_natator23368"),label="Hyposaurus_natator985", edgeLength = 0, lengthBelow = NULL) 
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Hyposaurus_natator23368"),label="Hyposaurus_natator753", edgeLength = 0, lengthBelow = NULL) 
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Rhabdognathus_sp."),label="Acherontisuchus", edgeLength = 0, lengthBelow = NULL)
Croc_tree <- DropTip(Croc_tree, "Rhabdognathus_sp.", preorder = TRUE, check = TRUE)
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Crocodylus_porosus"),label="Mecistops_cataphractus", edgeLength = 0, lengthBelow = NULL) 
Croc_tree <- DropTip(Croc_tree, "Crocodylus_porosus", preorder = TRUE, check = TRUE)

Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="M_brachyrhynchus"),label="M_brachyrhynchus3804", edgeLength = 0, lengthBelow = NULL) 
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="M_brachyrhynchus"),label="M_brachyrhynchus4763", edgeLength = 0, lengthBelow = NULL) 
Croc_tree <- DropTip(Croc_tree, "M_brachyrhynchus", preorder = TRUE, check = TRUE)
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Metriorhynchus_superciliosus"),label="Thalattosuchus_superciliosusV950", edgeLength = 0, lengthBelow = NULL) 
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Metriorhynchus_superciliosus"),label="Thalattosuchus_superciliosusV960", edgeLength = 0, lengthBelow = NULL) 
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Metriorhynchus_superciliosus"),label="Thalattosuchus_superciliosusV960_2", edgeLength = 0, lengthBelow = NULL)
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Metriorhynchus_superciliosus"),label="Thalattosuchus_superciliosusV1005", edgeLength = 0, lengthBelow = NULL) 
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Metriorhynchus_superciliosus"),label="Thalattosuchus_superciliosusV1016", edgeLength = 0, lengthBelow = NULL) 
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Metriorhynchus_superciliosus"),label="Thalattosuchus_superciliosusV1143", edgeLength = 0, lengthBelow = NULL) 
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Metriorhynchus_superciliosus"),label="Thalattosuchus_superciliosusV1146", edgeLength = 0, lengthBelow = NULL) 
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Metriorhynchus_superciliosus"),label="Thalattosuchus_superciliosusR1530", edgeLength = 0, lengthBelow = NULL) 
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Metriorhynchus_superciliosus"),label="Thalattosuchus_superciliosusR2032", edgeLength = 0, lengthBelow = NULL) 
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Metriorhynchus_superciliosus"),label="Thalattosuchus_superciliosusR2054", edgeLength = 0, lengthBelow = NULL) 
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Metriorhynchus_superciliosus"),label="Thalattosuchus_superciliosusPMU35988", edgeLength = 0, lengthBelow = NULL)
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Geosaurus_giganteus"),label="Geosaurus_lapparenti", edgeLength = 0, lengthBelow = NULL)	
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="M_brachyrhynchus3804"),label="Tyrannoneustes972", edgeLength = 0, lengthBelow = NULL)
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Tyrannoneustes972"),label="Tyrannoneustes1145", edgeLength = 0, lengthBelow = NULL)
#Proexochokefalos_cf_bouchardi added
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Proexochokefalos_heberti"),label="Proexochokefalos_cf_bouchardi", edgeLength = 0, lengthBelow = NULL)
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Neosteneosaurus_edwardsi"),label="Neosteneosaurus3169", edgeLength = 0, lengthBelow = NULL)
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Neosteneosaurus_edwardsi"),label="Neosteneosaurus3701", edgeLength = 0, lengthBelow = NULL)	
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Neosteneosaurus_edwardsi"),label="Neosteneosaurus2076", edgeLength = 0, lengthBelow = NULL)
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Neosteneosaurus_edwardsi"),label="Neosteneosaurus2865", edgeLength = 0, lengthBelow = NULL)
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Lemmysuchus_obtusidens"),label="Machimosaurus_hugii", edgeLength = 0, lengthBelow = NULL)

#Add deeper taxon
temp_node <- Croc_tree$edge[which(Croc_tree$edge[,2]==which(Croc_tree$tip.label=="Macrospondylus_bollensis")),1] #get node of Lemmy+Macro
Croc_tree <-  AddTip(Croc_tree,where=temp_node,label="Mycterosuchus_nasutus", edgeLength = 1, lengthBelow = NULL)

#Sericodon added
Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Mycterosuchus_nasutus"),label="Sericodon_jugleri", edgeLength = 0, lengthBelow = NULL)

# #Add Turnersuchus_hingleyae at the base of Thalattosuchia so change so it is 2 nodes from Pelagosaurus:
# temp_node <- which(Croc_tree$tip.label=="Pelagosaurus_typus")
# temp_node <- Croc_tree$edge[which(Croc_tree$edge[,2]==temp_node),1]
# temp_node <- Croc_tree$edge[which(Croc_tree$edge[,2]==temp_node),1]
# temp_node <- Croc_tree$edge[which(Croc_tree$edge[,2]==temp_node),1]
# temp_node <- Croc_tree$edge[which(Croc_tree$edge[,2]==temp_node),1]
# temp_node <- Croc_tree$edge[which(Croc_tree$edge[,2]==temp_node),1]
# temp_node <- Croc_tree$edge[which(Croc_tree$edge[,2]==temp_node),1]
# temp_node <- Croc_tree$edge[which(Croc_tree$edge[,2]==temp_node),1]
# temp_node <- Croc_tree$edge[which(Croc_tree$edge[,2]==temp_node),1]


# Croc_tree <-  AddTip(Croc_tree,where=temp_node,label="Turnersuchus_hingleyae", edgeLength = 1, lengthBelow = NULL)
Croc_tree <-  AddTip(Croc_tree,where=0,label="Turnersuchus_hingleyae", edgeLength = 1, lengthBelow = NULL)

# #Croc_tree <-  AddTip(Croc_tree,where=which(Croc_tree$tip.label=="Charitomenosuchus_leedsi"),label="Turnersuchus_hingleyae", edgeLength = 0, lengthBelow = NULL)


mod_trees[[i]] <- Croc_tree	
}
#Need to add Turnersuchus_hingleyae,
#plot(Croc_tree,cex=0.5);nodelabels(cex=0.4)


############ SCALE THE TREES IN TIME #############

FAD_LAD <- read.csv(paste0("FAD_LAD_",BoneType,".csv"),header=TRUE,row.names=1) #First & Last occurences

Bone_trees <- lapply(mod_trees, keep.tip,tip=rownames(FAD_LAD))
node_mins <- rep(NA,(Nnode(Bone_trees[[1]])))
node_mins[1] <- 219 #root
node_mins[Bone_trees[[1]]$edge[which(Bone_trees[[1]]$edge[,2]==which(Bone_trees[[1]]$tip.label=="Mecistops_cataphractus")),1]-Ntip(Bone_trees[[1]])] <- 201.5 #Neosuchian split
Bone_trees <- unlist(lapply(Bone_trees, timePaleoPhy,timeData=FAD_LAD,dateTreatment="minMax",randres=TRUE,ntrees=100,type="mbl",vartime=3,node.mins=node_mins),recursive=FALSE)
class(Bone_trees)<-"multiPhylo"



#Cons_tree <- consensus(Bone_trees)
Cons_tree <- consensus(Bone_trees, rooted=TRUE)
if(BoneType == "Scapula")
{
	Cons_tree <- DropTip(Cons_tree, "Turnersuchus_hingleyae", preorder = TRUE, check = TRUE)
	Cons_tree <-  AddTip(Cons_tree,where=0,label="Turnersuchus_hingleyae", edgeLength = 1, lengthBelow = NULL)
}
plot(Cons_tree)


Cons_tree_eq <- timePaleoPhy(Cons_tree,timeData=FAD_LAD,type= "mbl",vartime = 3,node.mins =node_mins)

pdf(paste0(BoneType,"_timescale.pdf"),width=8, height=11)
geoscalePhylo((Bone_trees[[999]]),FAD_LAD,cex.ts=0.5,cex.tip=0.6)
dev.off()


################################################################################################################################################################
################################################################################################################################################################



################################################################################
###########################		LANDMARKS	####################################
################################################################################


# Define the working directory
setwd(paste0(WorkingDirectory,"\\Models\\",BoneType))

# Create the list with .pts files
ptslist<-dir(pattern='.pts')

# Creation of the array with the dimensions being A: number of landmarks + semilandmarks, B: 2 or 3 dimensions--> c(A,B)
nbrPts <- dim(as.matrix(read.table(file=ptslist[1],skip=2,header=F,sep="",row.names=1)))[1]
ptsarray<-array(dim=c(nbrPts,3,length(ptslist))) #276 Ilium #170 Ischium #116 Pubis # 82 Pubis Outline #200 Femur Repaired #181 Femur Repaired No trochanter
												#194 Coracoid	#196 Scapula	#180 Humerus

#Add more landmarks on the pubis to reach 150-170

for(i in 1:length(ptslist))
{
  ptsarray[,,i]<-as.matrix(read.table(file=ptslist[i],skip=2,header=F,sep="",row.names=1))
}


# Rename each specimen with the name of the ".pts" file by removing the .pts
# ptsarray)[[3] if 3 dimensions, ptsarray)[[2] if only 2

dimnames(ptsarray)[[3]] <- c(substr(c(ptslist),1,nchar(c(ptslist))-4))

# Rename each landmark its name from the pts file
# ptsarray)[[3] if 3 dimensions, ptsarray)[[2] if only 2
dimnames(ptsarray)[[1]] <- c(read.table(file=ptslist[1],skip=2,header=F,sep="")[,1])


taxa_list <- substr(c(ptslist),1,nchar(c(ptslist))-4)

#Create mesh3d objects named as the ply files, it can be very long  depending on the number of files 
# meshlist <- list()

# for(i in 1:length(taxa_list)){ 
  # meshlist[[i]] <- assign(taxa_list[i],read.ply(file=paste(taxa_list[i],".ply",sep=""), ShowSpecimen=FALSE))
  # print(paste(round(100*(i/length(taxa_list)),1),"%"))
# }

# names(meshlist) <- taxa_list





# # # # # # # # # # # # # # # # # # # # # # # # # #
# # # #                                     # # # #
# # # #  Procrustes superimposition & PCA   # # # #
# # # #                                     # # # #
# # # # # # # # # # # # # # # # # # # # # # # # # #


# Define semi landmarks, C = number of semilandmarks in your dataset. 
# If you have a lot of semilandmark it may be interesting to create your sliding file on excel, to do so
# you need to create a 3 column sheet the name of the columns beeing "before", "slide" and "after"
# the 2nd column (slide) is the point that is sliding are and the "before" and "after" are the points in between
# which the sliding point is moving. To find the points number open one of your pts file and run the line 
# below to see how R numbered your points. 


#readland.tps #trouve les courbes readcurves = TRUE
#



semilandmarks <- read.csv("sliders.csv", sep = ",", header = TRUE)

landmarks_names <- row.names(ptsarray[,,1])
nbrFixed <- sum(sapply(landmarks_names, function(i) return (substr(i,1,1) == "S")))
nbrCurves <- sum(sapply(landmarks_names, function(i) return (substr(i,1,1) == "C")))

fixed <- 1:nbrFixed 
cur <- (nbrFixed+1):(nbrFixed+nbrCurves) 
semi <- nbrPts- nbrFixed - nbrCurves
surface <- c(1:semi)


###Slide and General Procrustes Analysis directly with geomorph with 1 sliders file
procrust <- gpagen(ptsarray,curves=semilandmarks,surfaces=surface,ProcD=FALSE) #GPA



#=======================================================#
#===================== Morphospace =====================#
#=======================================================#

# # # PCA # # # 

PCA <- gm.prcomp(procrust$coords)
eigenvalues <- PCA$d
scores <- PCA$x

# # # Labels # # # 

# Create as many vectors as you need to differentiate your specimens in the plot. Vectors need to be 
# the size of the dataset. You can repeat several times the same term by using: rep() 
# rep("The Word You Want To Repeat", X)
# If, for instance, you would like to display only some specimen number just fill the position of the 
# specimen with a blank " ", e.g. label_specimen_PCA  <- c("ULg-1", " " , "ULg-3")

oldwd <- getwd()
setwd(paste0(WorkingDirectory,"\\Landmark_Phylomorpho"))
write.csv(PCA$x, file=paste0(BoneType,"_PCA.csv"))
setwd(oldwd)
#write.csv(myDataFrame, paste0('Croc_',BoneType,'.csv'), row.names = TRUE) 

if(BoneType == "Ilium")
{
######  ILIUM  ######							
	color_group_PCA     <- c("Dyrosauridae",
							"Teleosauroidea",
							"Dyrosauridae",
							"Metriorhynchoidea",
							"Metriorhynchoidea",
							"Dyrosauridae",
							"Dyrosauridae",
							"Teleosauroidea",
							"Metriorhynchoidea",
							"Metriorhynchoidea",
							"Crocodylia",
							"Teleosauroidea",
							"Metriorhynchoidea",
							"Teleosauroidea",
							"Teleosauroidea",
							"Metriorhynchoidea",
							"Metriorhynchoidea",
							"Metriorhynchoidea",
							"Metriorhynchoidea",
							"Metriorhynchoidea",
							"Metriorhynchoidea", 
							"Metriorhynchoidea")
}							


if(BoneType == "Ischium")
{
######  ISCHIUM  ######							
	color_group_PCA     <- c("Dyrosauridae",
							"Teleosauroidea",
							"Dyrosauridae",
							"Teleosauroidea",
							"Metriorhynchoidea",
							"Metriorhynchoidea",
							"Crocodylia",
							"Teleosauroidea",
							"Teleosauroidea",
							"Metriorhynchoidea",
							"Teleosauroidea",
							"Teleosauroidea",
							"Metriorhynchoidea",
							"Metriorhynchoidea",
							"Metriorhynchoidea",
							"Metriorhynchoidea",
							"Metriorhynchoidea",
							"Metriorhynchoidea",
							"Metriorhynchoidea")	
}							
							
							
						
							

if(BoneType == "Pubis")
{
######  PUBIS Expanded ######							
	color_group_PCA     <- c("Teleosauroidea",
							"Metriorhynchoidea",
							"Dyrosauridae",
							"Dyrosauridae",
							"Teleosauroidea",
							"Teleosauroidea",
							"Teleosauroidea",
							"Crocodylia",
							"Metriorhynchoidea",
							"Teleosauroidea",
							"Teleosauroidea",
							"Metriorhynchoidea",
							"Metriorhynchoidea",
							"Metriorhynchoidea",
							"Metriorhynchoidea",
							"Metriorhynchoidea",
							"Metriorhynchoidea")
}								

					

if(BoneType == "Femur_outline") #or Femur
{
######  FEMUR Repaired Expanded ######	
color_group_PCA   <- c("Teleosauroidea", 
						"Dyrosauridae",  
						"Metriorhynchoidea",
						"Metriorhynchoidea",
						"Dyrosauridae",     
						"Dyrosauridae",      
						"Teleosauroidea",              
						"Teleosauroidea",
						"Crocodylia",        
						"Metriorhynchoidea",
						"Metriorhynchoidea",           
						"Teleosauroidea",   
						"Teleosauroidea",  
						"Teleosauroidea",          
						"Teleosauroidea",
						"Metriorhynchoidea", 						
						"Metriorhynchoidea",
						"Metriorhynchoidea",
						"Metriorhynchoidea",
						"Metriorhynchoidea",       
						"Metriorhynchoidea",
						"Metriorhynchoidea",           
						"Metriorhynchoidea")
}						
						

if(BoneType == "Humerus")
{
######  HUMERUS Repaired Expanded ######	
color_group_PCA   <- c("Teleosauroidea", 
						"Dyrosauridae",  
						"Metriorhynchoidea",
						"Metriorhynchoidea",
						"Dyrosauridae",     
						"Dyrosauridae",
						"Teleosauroidea",
						"Metriorhynchoidea",						
						"Crocodylia",                
						"Teleosauroidea",   
						"Teleosauroidea",
						"Teleosauroidea",
						"Teleosauroidea",
						"Metriorhynchoidea",
						"Metriorhynchoidea",
						"Metriorhynchoidea",
						"Metriorhynchoidea",
						"Metriorhynchoidea")
}

if(BoneType == "Scapula")
{
#####  SCAPULA Repaired Expanded ######	
color_group_PCA   <- c("Teleosauroidea", 
						"Dyrosauridae",                       
						"Dyrosauridae",     
						"Teleosauroidea",      
						"Crocodylia",                
						"Teleosauroidea",   
						"Teleosauroidea",           
						"Metriorhynchoidea",
						"Metriorhynchoidea",
						"Thalattosuchia")
}
						

if(BoneType == "Coracoid")
{
######  Coracoid Repaired Expanded######	
color_group_PCA   <- c("Teleosauroidea", 
						"Dyrosauridae",                       
						"Dyrosauridae",     
						"Dyrosauridae",
						"Metriorhynchoidea",						
						"Crocodylia",                
						"Teleosauroidea",   
						"Teleosauroidea",   
						"Teleosauroidea",           
						"Metriorhynchoidea",
						"Metriorhynchoidea",
						"Metriorhynchoidea",
						"Metriorhynchoidea",
						"Metriorhynchoidea")
}						
						


 
########################################################################################################		
	
label_specimen_PCA  <- row.names(PCA$x)

# Define precise colors and shapes for each taxa.

if(BoneType == "Ilium")
{
######  ILIUM  ######	
colors_to_plot <- c("Acherontisuchus_L_ilium" = "#D32027",
					 "Charitomenosuchus_NHM_PV_R_3806_L_ILIUM" = "#106851",
					 "Congosaurus_ilium_1806_repaired" = "#741016",        
					 "Cricosaurus_araucanensis_Ileon_oriented" = "#629488", 
					 "Geosaurus_giganteus_L_Ilium_NHM_PV_R_1230_Test1"= "#629488",
					 "Hyposaurus_NJSM23368_R_Ilium_mirrored" = "#741016",
					 "Hyposaurus_YPM_VP000753_Ilium_centered_mirrored" = "#741016",
					 "Lemmysuchus_NHM_PV_R_3168_L_ILIUM_oriented" = "#106851",
					 "M_brachyrhynchus_NHM_PV_R_3804_R_ILIUM_mirrored" = "#629488",
					 "M_brachyrhynchus_NHM_PV_R_4763_L_ILIUM" = "#629488",     
					 "Mecistops_RBINS_18374_R_ilium_mirrored" = "#D4772B",
					 "Neosteneosaurus_NHM_PV_R_2076_L_ILIUM" = "#106851",      
					 "Pelagosaurus_BRLSI_M1417_L_Ilium_repaired_blender" = "#106851", 
					 "Proexochefalos_left_ilium_repaired" = "#106851",
					 "Sericodon_L_Ilium_Oriented" = "#106851",
					 "Suchodus_NHM_PV_R_2618_R_ILIUM_mirrored" = "#629488", 
					 "Thalattosuchus_GLAHM_V1005_L_Ilium_repaired" ="#629488",
					 "Thalattosuchus_GLAHM_V1146_R_Ilium_mirrored" = "#629488",
					 "Thalattosuchus_NHM_PV_R_1530_R_Ilium_mirrored" = "#629488",
					 "Thalattosuchus_NHM_PV_R_2054_L_ILIUM" = "#629488",
					 "Tyrannoneustes_GLAHM_V972_L_Ilium_repaired"= "#629488",
					 "Tyrannoneustes_GLAHM_V1145_R_Ilium_mirrored"= "#629488")
}					 
					 
					 

if(BoneType == "Ischium")
{					 
######  ISCHIUM  ######					 
colors_to_plot <- c("Acherontiuchus_Ischium_repaired"= "#741016",
					"Charitomenosuchus_NHM_PV_R_3806_R_ISCHIUM_mirrored" = "#106851",
					 "Hyposaurus_LeftIschium_010920" = "#741016",
					 "Lemmysuchus_NHM_PV_R_3168_R_ischium_mirrored" = "#106851",
					 "M_brachyrhynchus_NHM_PV_R_3804_L_ISCHIUM_Reconstruction"= "#629488",
					 "M_brachyrhynchus_NHM_PV_R_4763_L_ISCHIUM" = "#629488",        
					 "Mecistops_RBINS_18374_R_ischium_mirrored" = "#D4772B",     
					 "Neosteneosaurus_NHM_PV_R_2865_R_ischium_mirrored" = "#106851",
					 "Neosteneosaurus_NHM_PV_R_3701_L_ISCHIUM_modified" = "#106851",
					 "Pelagosaurus_BRLSI_M1410_L_Ilium_repaired_blender"= "#629488",
					 "Proexochokefalos_R_Ischium_repaired_mirrored" = "#106851",
					 "Sericodon_L_Ischium_repaired_test2" = "#106851",
					 "Thalattosuchus_GLAHM_V950_L_Ischium_repaired"= "#629488",
					 "Thalattosuchus_GLAHM_V960_R_Ischium_mirrored_repaired"= "#629488",
					 "Thalattosuchus_GLAHM_V960_R_Ischium_mirrored_repaired2"= "#629488",
					 "Thalattosuchus_GLAHM_V1005_L_Ischium_repaired"= "#629488",
					 "Thalattosuchus_NHM_PV_R_1530_R_ISCHIUM_mirrored" = "#629488",
					 "Thalattosuchus_NHM_PV_R_2054_L_ISCHIUM_modified" = "#629488",
					 "Torvoneustes_BRSMG_Cd7203_R_Ischium_repaired_mirrored"= "#629488")
}

				 

if(BoneType == "Pubis")
{					 
######  PUBIS Expanded ######					 
colors_to_plot   <- c("Charitomenosuchus_NHM_PV_R_3806_L_PUBIS_reconstructed2" = "#106851",
						"Geosaurus_giganteus_pubis_NHM_PV_R_1230_repaired"= "#629488",  
						"Hyposaurus_NJSM23368_RightPubis_mirrored" = "#741016",                
						"Hyposaurus_YPM_VP_000753_pubis_mirrored" = "#741016",                                      
						"Lemmysuchus_NHMPVR_3168_L_pubis_reconstruction" = "#106851",
						"Machimosaurus_hugii_SMNS_81608_L_pubis_repaired" = "#106851",
						"Macrospondylus_bollensis_NHM_PV_R_5703_Pubis_mirrored_repaired"= "#106851",
						"Mecistops_RBINS_18374_R_pubis_mirrored" = "#D4772B",             
						"Metriorhynchus_NHM_PV_R_3804_R_PUBIS_mirrored" = "#629488",                     
						"Neosteneosaurus_NHM_PV_R_2076_pubis" = "#106851",                   
						"Neosteneosaurus_NHM_PV_R_3701_L_Pubis_WATERTIGHT" = "#106851",       
						"Pelagosaurus_BRLSI_M1420_pubis_repaired_mirrored" = "#629488",
						"Suchodus_NHM_PV_R_2618_R_PUBIS_WATERTIGHT_mirrored" = "#629488",      
						"Thalattosuchus_GLAHM_V960_R_Pubis_repaired_mirrored" = "#629488",
						"Thalattosuchus_GLAHM_V1005_L_Pubis_repaired" = "#629488",
						"Thalattosuchus_NHM_PV_R_1530_L_Pubis" = "#629488",                     
						"Thalattosuchus_NHM_PV_R_2054_R_PUBIS_mirrored" = "#629488")	
}				


if(BoneType == "Femur_outline") #Or Femur
{
######  FEMUR Repaired Expanded ######	
colors_to_plot   <- c("Charitomenosuchus_NHM_PV_R_3806_R_FEMUR_mirrored" = "#106851", 
						"Congosaurus_Femur_L_1817" = "#741016",                       
						"Dacosaurus_maximus_SMNS8203_femur_repaired"= "#629488",
						"Geosaurus_lapparenti_UJF-ID11846n_L_Femur_repaired"= "#629488",
						"Hyposaurus_NJSM_23368_RightFemur_mirrored" = "#741016",      
						"Hyposaurus_YPM_VP000753_R_Femur_mirrored" = "#741016",      
						"Lemmysuchus_NHM_PV_R_3168_L_FEMUR" = "#106851",              
						"Machimosaurus_hugii_SMNS81608_L_Femur" = "#106851",            
						"Mecistops_RBINS_18374_R_Femur_mirrored" = "#D4772B",         
						"Metriorhynchus_NHM_PV_R_3804_R_FEMUR_mirrored" = "#629488",
						"Metriorhynchus_NHM_PV_R_4763_L_FEMUR" = "#629488",            
						"Neosteneosaurus_NHM_PV_R_2076_R_Femur_mirrored" = "#106851",   
						"Neosteneosaurus_NHM_PV_R_2865_R_Femur_mirrored" = "#106851",  
						"Neosteneosaurus_NHM_PV_R_3169_L_Femur" = "#106851",          
						"Sericodon_left_femur_oriented_repaired" = "#106851",
						"Suchodus_NHM_PV_R_2618_L_FEMUR" = "#629488",                  
						"Thalattosuchus_GLAHM_V960_L_Femur_repaired"= "#629488",
						"Thalattosuchus_GLAHM_V1005_L_Femur"= "#629488",
						"Thalattosuchus_NHM_PV_R_1530_L_Femur" = "#629488",       
						"Thalattosuchus_NHM_PV_R_2032_Femur" = "#629488",            
						"Thalattosuchus_NHM_PV_R_2054_L_FEMUR" = "#629488",
						"Torvoneustes_BRSMG_Cd7203_R_Femur_Mirrored_blender"= "#629488",
						"Tyrannoneustes_GLAHM_V1145_L_Femur_repaired"= "#629488")
}



if(BoneType == "Humerus")
{						
######  HUMERUS Repaired ######	
colors_to_plot   <- c("Charitomenosuchus_NHM_PV_R_3806_L_HUMERUS" = "#106851",
						"Congosaurus_R_Humerus_1813_mirrored" = "#741016", 
						"Dakosaurus_lapparenti_UJF-ID11846m_mirrored_repaired" = "#629488",
						"Dakosaurus_maximus_SMNS_8203_R_humerus_repaired_mirrored" = "#629488",
						"Hyposaurus_NJSM_23368_RightHumerus_mirrored" = "#741016",
						"Hyposaurus_YPM_VP000985_R_Humerus_mirrored" = "#741016",
						"Lemmysuchus_NHM_PV_R_3168_L_HUMERUS_repaired" = "#106851",
						"M_moreli_GLAHM_V1143_R_Humerus_mirrored" = "#629488",
						"Mecistops_RBINS_18374_R_Humerus_mirrored" = "#D4772B",
						"Mycterosuchus_NHM_PV_R_2617_L_HUMERUS" = "#106851",    
						"Neosteneosaurus_NHM_PV_R_3701_L_Humerus" = "#106851", 
						"Proexochefalos_R_Humerus_repaired_mirrored" = "#106851",
						"Sericodon_left_humerus_repaired" = "#106851",
						"Thalattosuchus_GLAHM_V1016_R_Humerus_repaired_MIRRORED" = "#629488",
						"Thalattosuchus_GLAHM_V1146_L_Humerus_repaired_test2" = "#629488",
						"Thalattosuchus_NHM_PV_R_2032_L_Humerus" = "#629488",
						"Torvoneustes_BRSMG_Cd7203_R_Humerus_mirrored"= "#629488",
						"Tyrannoneustes_GLAHM_V1145_L_Humerus_repaired"= "#629488")   
}



if(BoneType == "Scapula")
{
######  SCAPULA Repaired Expanded ######	
colors_to_plot   <- c("Charitomenosuchus_NHM_PV_R_3806_R_SCAPULA_mirrored" = "#106851",
						"Congosaurus_R_Scapula_1809_repaired" = "#741016",              
						"Hyposaurus_NJSM23368_RightScapula_mirrored" = "#741016",      
						"Lemmysuchus_NHM_PV_R_3168_L_SCAPULA" = "#106851",              
						"Mecistops_RBINS_18374_R_Scapula_mirrored" = "#D4772B",      
						"Mycterosuchus_NHM_PV_R_2617_L_SCAPULA" = "#106851",            
						"Neosteneosaurus_NHM_PV_R_3701_L_Scapula" = "#106851", 
						"Thalattosuchus_GLAHM_V1146_L_Scapula"= "#629488",
						"Thalattosuchus_R_SCAPULA_PMU35988_mirrored" = "#629488",
						"Turnersuchus_R_scapula_repaired_mirrored" = "#00FF00")						
}


if(BoneType == "Coracoid")
{
			#####  CORACOID Repaired Expanded ######	
colors_to_plot   <- c("Charitomenosuchus_NHM_PV_R_3806_L_CORACOID" = "#106851",    
					"Congosaurus_MRAC_1811_R_coracoid_mirrored" = "#741016",        
					"Hyposaurus_NJSM23368_LeftCoracoid" = "#741016",               
					"Hyposaurus_YPM_VP000985_L_Coracoid" = "#741016",
					"M_moreli_GLAHM_V1143_R_Coracoid_mirrored_repaired" = "#106851",
					"Mecistops_RBINS_18374_R_Coracoid_mirrored" = "#D4772B",        
					"Mycterosuchus_NHM_PV_R_2617_L_CORACOID" = "#106851",           
					"Neosteneosaurus_NHM_PV_R_3701_R_CORACOID_mirrored" = "#106851",
					"NHM_PV_R_3169_L_Coracoid_repaired" = "#106851",                
					"Thalattosuchus_GLAHM_V1005_R_Coracoid_repaired_mirrored"= "#629488",
					"Thalattosuchus_GLAHM_V1146_L_Coracoid_repaired" = "#629488",
					"Thalattosuchus_L_Coracoid_NHM_PV_R_1530" = "#629488",         
					"Thalattosuchus_L_Coracoid_PMU35988" = "#629488",
					"Tyrannoneustes_GLAHM_V1145_L_Coracoid_repaired"= "#629488") 				
}



										
#######################################################################################################"


# # # Plot # # #

# Creation of the df for the ggplot
df_pca <-cbind(as.data.frame(scores[,1:2]),label_specimen_PCA, color_group_PCA )

# Creation of the df for the phylomorphospace    
df_pca_phylo <- as.data.frame(scores[,1:2])
#Tree labels to check label creation 


Cons_tree$tip.label


#Create labels same as tree but matching order of landmarks
Phy_tree_eq <- Cons_tree_eq


if(BoneType == "Scapula")
{			
	##### SCAPULA #####
	label_specimen <- c("Charitomenosuchus_leedsi","Congosaurus_bequaerti","Hyposaurus_natator23368","Lemmysuchus_obtusidens",
	"Mecistops_cataphractus","Mycterosuchus_nasutus","Neosteneosaurus3701","Thalattosuchus_superciliosusV1146","Thalattosuchus_superciliosusPMU35988","Turnersuchus_hingleyae")
}

if(BoneType == "Coracoid")
{			
	##### CORACOID #####
	label_specimen <- c("Charitomenosuchus_leedsi","Congosaurus_bequaerti","Hyposaurus_natator23368","Hyposaurus_natator985",
	"Thalattosuchus_superciliosusV1143","Mecistops_cataphractus","Mycterosuchus_nasutus","Neosteneosaurus3701","Neosteneosaurus3169",
	"Thalattosuchus_superciliosusV1005","Thalattosuchus_superciliosusV1146","Thalattosuchus_superciliosusR1530",
	"Thalattosuchus_superciliosusPMU35988","Tyrannoneustes1145")
}


if(BoneType == "Humerus")
{			
	##### HUMERUS #####
	label_specimen <- c("Charitomenosuchus_leedsi","Congosaurus_bequaerti","Geosaurus_lapparenti","Dakosaurus_maximus","Hyposaurus_natator23368",
	"Hyposaurus_natator985","Lemmysuchus_obtusidens","Thalattosuchus_superciliosusV1143","Mecistops_cataphractus","Mycterosuchus_nasutus","Neosteneosaurus3701",
	"Proexochokefalos_cf_bouchardi","Sericodon_jugleri","Thalattosuchus_superciliosusV1016","Thalattosuchus_superciliosusV1146","Thalattosuchus_superciliosusR2032",
	"Torvoneustes_carpenteri","Tyrannoneustes1145")
}

if(BoneType == "Ilium")
{			
	##### ILIUM #####
	label_specimen <- c("Acherontisuchus","Charitomenosuchus_leedsi","Congosaurus_bequaerti","Cricosaurus_araucanensis","Geosaurus_giganteus","Hyposaurus_natator23368",
	"Hyposaurus_natator753","Lemmysuchus_obtusidens","M_brachyrhynchus3804","M_brachyrhynchus4763","Mecistops_cataphractus","Neosteneosaurus2076","Pelagosaurus_typus",
	"Proexochokefalos_cf_bouchardi","Sericodon_jugleri","Suchodus_durobrivensis","Thalattosuchus_superciliosusV1005","Thalattosuchus_superciliosusV1146",
	"Thalattosuchus_superciliosusR1530","Thalattosuchus_superciliosusR2054","Tyrannoneustes1145","Tyrannoneustes972")
}

if(BoneType == "Ischium")
{			
	##### ISCHIUM #####
	label_specimen <- c("Acherontisuchus","Charitomenosuchus_leedsi","Hyposaurus_natator23368","Lemmysuchus_obtusidens","M_brachyrhynchus3804","M_brachyrhynchus4763",
	"Mecistops_cataphractus","Neosteneosaurus2865","Neosteneosaurus3701","Pelagosaurus_typus","Proexochokefalos_cf_bouchardi","Sericodon_jugleri","Thalattosuchus_superciliosusV1005","Thalattosuchus_superciliosusV950",
	"Thalattosuchus_superciliosusV960","Thalattosuchus_superciliosusV960_2","Thalattosuchus_superciliosusR1530","Thalattosuchus_superciliosusR2054",
	"Torvoneustes_carpenteri")
}

if(BoneType == "Pubis")
{			
	##### PUBIS #####
	#label_specimen <- c("Charitomenosuchus_leedsi","Geosaurus_giganteus","Hyposaurus_natator23368","Hyposaurus_natator753","Lemmysuchus_obtusidens","Macrospondylus_bollensis","Mecistops_cataphractus",
	label_specimen <- c("Charitomenosuchus_leedsi","Geosaurus_giganteus","Hyposaurus_natator23368","Hyposaurus_natator753","Lemmysuchus_obtusidens","Machimosaurus_hugii","Macrospondylus_bollensis","Mecistops_cataphractus",
	"M_brachyrhynchus3804",	"Neosteneosaurus2076","Neosteneosaurus3701","Pelagosaurus_typus","Suchodus_durobrivensis","Thalattosuchus_superciliosusV1005",
	"Thalattosuchus_superciliosusV960","Thalattosuchus_superciliosusR1530","Thalattosuchus_superciliosusR2054")
}



if(BoneType == "Femur_outline")
{	
	##### FEMUR #####
	label_specimen <- c("Charitomenosuchus_leedsi","Congosaurus_bequaerti","Dakosaurus_maximus","Geosaurus_lapparenti","Hyposaurus_natator23368","Hyposaurus_natator753",
	"Lemmysuchus_obtusidens","Machimosaurus_hugii","Mecistops_cataphractus","M_brachyrhynchus3804","M_brachyrhynchus4763","Neosteneosaurus2076","Neosteneosaurus2865",
	"Neosteneosaurus3169","Sericodon_jugleri","Suchodus_durobrivensis","Thalattosuchus_superciliosusV1005","Thalattosuchus_superciliosusV960","Thalattosuchus_superciliosusR1530",
	"Thalattosuchus_superciliosusR2032","Thalattosuchus_superciliosusR2054","Torvoneustes_carpenteri","Tyrannoneustes1145")
}

df_pca_phylo <-cbind (df_pca_phylo,label_specimen)
df_pca_phylo



#Create a convex hull to plot on the ggplot
split(df_pca[,1:2], df_pca$color_group_PCA )
chull_PCA <- lapply(split(df_pca, df_pca$color_group_PCA), function(df){
  df[chull(df),]
})

chull_PCA <- do.call(rbind, chull_PCA)

PC1 <- round(((eigenvalues[1]/sum(eigenvalues))*100), digits = 2)
PC2 <- round(((eigenvalues[2]/sum(eigenvalues))*100), digits = 2)

#si ratio en dessous de 25% il faut forcer 1/4
    
PCA_graphe <- ggplot(data=df_pca[,1:2],aes(x=df_pca[,1],y=df_pca[,2],color=color_group_PCA)) +
              theme_minimal() +
              geom_point(size= 3,alpha=0.5) +
              geom_text_repel(aes(label=label_specimen_PCA), size=3) +
              labs(x = paste0('PC1 = ', PC1, '%'), 
                   y = paste0('PC2 = ', PC2, '%')) +              
              geom_rangeframe(color = "black") +
              geom_polygon(data=chull_PCA, aes(x=Comp1 , y=Comp2 , fill=color_group_PCA), alpha=0.2)
               # + scale_color_manual(values = colors_to_plot) +
              # scale_fill_manual(values = colors_to_plot) +
              # scale_shape_manual(values=shape_to_plot) 
PCA_graphe




########################### SAVING THE GRAPH #########################
				
ggsave(paste0("PCA_",BoneType,"_Repaired",".pdf"),device="pdf",units="mm",width=240,height=240) #sauvegarde le graphe affiché

plotratio <- PC2/PC1
ggsave(paste0("PCA_",BoneType,"_Scaled",".pdf"),device="pdf",units="mm",width=240,height=240*plotratio) #sauvegarde le graphe affiché


              # # # # # # # # # # # # # # # # # # # # # # # # # #
              # # # #                                     # # # #
              # # # #           Procrustes ANOVA          # # # #
              # # # #                                     # # # #
              # # # # # # # # # # # # # # # # # # # # # # # # # #


# Use geomorph.data.frame to reate a data frame with shape data and include your group color_group_PCA variable (or another if needed)
gdf <- geomorph.data.frame(procrust, ClusteringVariable = as.factor(color_group_PCA))

# Compute a procrustes ANOVA to look for a relationship between the shape (coords) and your categorical variable, e.g. genus, species, family, diet, etc. (color_group_PCA)
fit <- procD.lm(coords~color_group_PCA,data=gdf,iter=999)
summary(fit)

#Scapula is 0.001
#Coracoid is 0.001
#Humerus is 0.003
#Ilium is 0.001
#Ischium is 0.001
#Pubis is 0.01
#Femur is 0.001

###################################################################################################
############################  			 Preparing dataset				###########################
###################################################################################################

setwd(paste0(WorkingDirectory,"\\Landmark_Phylomorpho"))
Bone_convert <- read.csv(paste0("Bone_convert_",BoneType,".csv"))

# Phy_tree_eq <- Bone_trees
# for (i in 1:length(Phy_tree_eq)){
	# Phy_tree_eq[[i]]$tip.label <- Bone_convert[match(Bone_trees[[i]]$tip.label, Bone_convert$Taxa),"Bone"]
# }

Phy_tree_eq <- Cons_tree_eq

Phy_tree_eq$tip.label <- Bone_convert[match(Cons_tree_eq$tip.label, Bone_convert$Taxa),"Bone"]


###################################################################################################
############################   Assessing phylogenetic signal in morphometric data	###############
###################################################################################################
# Code from Adams 2022 Geomorph Package
#The function estimates the degree of phylogenetic signal present in Procrustes shape variables for a given phylogeny.
# The degree of phylogenetic signal in data is estimated using the multivariate version of the K-statistic
#Test for phylogenetic signal in shape
#produces a histogram of random K statistics, associated with the resampling procedure
PS.shape <- physignal(A=procrust$coords,phy=Phy_tree_eq,iter=999)
summary(PS.shape)
plot(PS.shape) #Plot K and P values
plot(PS.shape$PACA, phylo = TRUE) #Plot phylomorphospace
PS.shape$K.by.p # Phylogenetic signal profile


#Scapula is K=0.5543 p=0.001
#Coracoid is K=0.4969 p=0.001
#Humerus is K=0.3472 p=0.001
#Ilium is K=0.5642 p=0.001
#Ischium is K=0.4562 p=0.002
#Pubis is is K=0.2943 p=0.003
#Femur is is K=0.4595 p=0.001


PS.size <- physignal(A=procrust$Csize,phy=Phy_tree_eq,iter=999)
summary(PS.size)
plot(PS.size)


#Scapula is K=1.464 p=0.021
#Coracoid is K=0.2508 p=0.031
#Humerus is K=0.11 p=0.739
#Ilium is K=0.2089 p=0.281
#Ischium is K=0.4495 p=0.07
#Pubis is K=0.278 p=0.174
#Femur is K=0.5494 p=0.064


# PS.shape <- physignal(A=renamedCoords[1:10,1:2,],phy=Phy_tree_eq,iter=999)
# summary(PS.shape)
# plot(PS.shape) #Plot K and P values
# plot(PS.shape$PACA, phylo = TRUE) #Plot phylomorphospace
# PS.shape$K.by.p # Phylogenetic signal profile



###################################################################################################
#############################				TEST MANTEL					###########################
###################################################################################################

# ###### TEST MANTEL #####

# Creates 2D list from combined Procrustes
sortedCoords <- two.d.array(procrust$coords)
sortedCoords <- sortedCoords[match(Phy_tree_eq$tip.label, rownames(sortedCoords)),]

ListProcrust <- sortedCoords


#Create distance matrix for ListProcrust
DistProcrust<-dist(ListProcrust)

Phylo_dist <- distTips(Phy_tree_eq,method="patristic")


mantel(xdis=DistProcrust, ydis=Phylo_dist, permutations=999)

#Scapula r=0.544 & p=0.025
#Coracoid is r=0.8523 & p=0.001
#Humerus is r=0.1947 & p=0.133
#Ilium is r=0.6589 & p=0.001
#Ischium is r=0.9178 & p=0.001
#Pubis is r=0.322 & p=0.043
#Femur is r=0.8546 & p=0.001


################################################################################################################################################################
################################################################################################################################################################


################################################################################
###########################		PHYLOMORPHOSPACE	############################
################################################################################


setwd(paste0(WorkingDirectory,"\\Landmark_Phylomorpho"))



########## PHYLOMORPHOSPACE ############

Bone_tree_eq2 <- Bone_tree_eq
df_pca_phylo2 <- df_pca_phylo
species_list <- unique(label_specimen)
specimen_bucket <- setNames(rep(0, length(species_list)),species_list)

for(i in 1:length(label_specimen))
{
	specimen_bucket[label_specimen[i]] <- specimen_bucket[label_specimen[i]] + 1
	if(specimen_bucket[label_specimen[i]] > 1)
	{	
		#Putting edgeLength=0 gives an error in phylomorphospace
		Bone_tree_eq2 <- AddTip(Bone_tree_eq2, where=label_specimen[i], label=paste0(label_specimen[i], specimen_bucket[label_specimen[i]]), 
			edgeLength = 0.000001, lengthBelow = 0)
			
		df_pca_phylo2[i,3] <- paste0(df_pca_phylo2[i,3], specimen_bucket[label_specimen[i]])
	}
}
row.names(df_pca_phylo2) <- df_pca_phylo2[,3]

plot(Bone_tree_eq2)

phylomorphospace(Bone_tree_eq2, df_pca_phylo2[,1:2], A=NULL, label=c("horizontal"),xlab="PC1",ylab="PC2",node.size=c(0,1))



Bone_tree_eq3 <- Bone_tree_eq2

# now add the era map
Bone_tree_eq3<-make.era.map(Bone_tree_eq3,0:99)
# choose the color scale
colors<-rainbow(100,start=0,end=0.7)
names(colors)<-1:100
# check it
plotSimmap(Bone_tree_eq3,colors,pts=FALSE,lwd=6)

# plot phylomorphospace with colors
phylomorphospace(Bone_tree_eq3,df_pca_phylo2[,1:2],colors=colors,node.by.map=TRUE, lwd=4,node.size=c(0,1.5),label="horizontal",xlab="PC1",ylab="PC2")



#Computing multidimensional phylogenetic scatterplot matrix
X <- df_pca_phylo2[,1:2]
fancyTree(Bone_tree_eq2,type="scattergram",X=X,fsize=0.8)




########## EXPORT PHYLOMORPHOSPACE ############

pdf(paste0(BoneType,"_phylomorphospace",".pdf"), height = 600, width =600)
phylomorphospace(Bone_tree_eq2, df_pca_phylo2[,1:2], A=NULL, label=c("horizontal"),xlab="PC1",ylab="PC2",node.size=c(0,1))
dev.off()


pdf(paste0(BoneType,"_phylomorphospace_color",".pdf"), height = 600, width =600)
phylomorphospace(Bone_tree_eq3,df_pca_phylo2[,1:2],colors=colors,node.by.map=TRUE, lwd=4,node.size=c(0,2),label="horizontal",xlab="PC1",ylab="PC2")
dev.off()















