function [moments, moments_CRSC] = spectral_recombine(m2Q,m3Q,phi)

moments      = zeros(size(phi,1),4);
moments_CRSC = zeros(size(phi,1),4);

Nmodes = size(phi,2);

for inod = 1:size(phi,1)
    tmp=0;
    for i1=1:Nmodes
        for i2=1:Nmodes
            tmp = tmp + m2Q(i1,i2)*phi(inod,i1)*phi(inod,i2);
        end
    end
    moments(inod,2) = sqrt(tmp); % std of nodal displacement
end
for inod = 1:size(phi,1)
    tmp=0;
    for i1=1:Nmodes
        for i2=1:Nmodes
            for i3=1:Nmodes
                tmp = tmp + m3Q(i1,i2,i3)*phi(inod,i1)*phi(inod,i2)*phi(inod,i3);
            end
        end
    end
    moments(inod,3) = tmp / moments(inod,2)^3; % skw of nodal displacement
end




for inod = 1:size(phi,1)
    tmp=0;
    for i1=1:Nmodes
        i2=i1;
        tmp = tmp + m2Q(i1,i2)*phi(inod,i1)*phi(inod,i2);
    end
    moments_CRSC(inod,2) = sqrt(tmp); % std of nodal displacement
end

for inod = 1:size(phi,1)
    tmp=0;
    for i1=1:Nmodes
        i2=i1; i3=i1;
        tmp = tmp + m3Q(i1,i2,i3)*phi(inod,i1)*phi(inod,i2)*phi(inod,i3);
    end
    moments_CRSC(inod,3) = tmp / moments_CRSC(inod,2)^3; % skw of nodal displacement
end
