function Spectral = solutionSpectral(Mgen,Kgen,Cgen,xi,omega,wsollB,V,Sf,Bf,mom3F,iload,NDOF,CORRES,NElem,Ke,doFreqDomainBispe)

Nmodes = size(V,2);

V_all = zeros(NDOF,Nmodes);
V_all(CORRES,:) = V;

M_all = computeBendingMoment(V_all,NElem, Ke);

V_all = V_all(2:3:end,:);


%% SPECTRAL ANALYSIS

% define mesh
ns = 150;
wsoll = linspace(0,1.5,ns);
w = 2*pi * FrequencesDeCalcul(xi(1:Nmodes),omega(1:Nmodes)/2/pi,wsoll/2/pi);
Spectral.w = w;

% V'*V can be computed first because there is only one loading point.
VtV =  V(iload,:)'*V(iload,:);
for i1=1:Nmodes
    for i2=1:Nmodes
        Sfgen(i1,i2,:) = VtV(i1,i2) * Sf(w);
    end
end
Hgen = FCTTransfertMDDL (Mgen,Kgen,Cgen,w/2/pi);

for i=1:length(w)
    Spectral.Sq(:,:,i) = Hgen(:,:,i)*Sfgen(:,:,i)*Hgen(:,:,i)';
end
for i1=1:Nmodes
    for i2=1:Nmodes
        Spectral.cov(i1,i2) = 2*real(trapz(w,squeeze(Spectral.Sq(i1,i2,:)))); % multiply by 2 because w starts at zero
    end
end
Spectral.varq = diag(Spectral.cov);
Spectral.corr = diag(1./sqrt(Spectral.varq ))* Spectral.cov * diag(1./sqrt(Spectral.varq ));

%% SPECTRAL ANALYSIS MTSA -- SKIP
% covF = VtV*mom2F;
% for i1=1:Nmodes
%     for i2=1:Nmodes
%         %covF(i1,i2) =  trapz(w,squeeze(Sfgen(i1,i2,:)));
%         covQ_B(i1,i2) = covF(i1,i2)/Kgen(i1,i1)/Kgen(i2,i2);
%         
%         wm = (omega(i1)+omega(i2))/2;
%         xim = (xi(i1)+xi(i2))/2;
%         e   = (omega(i1)-omega(i2))/2/wm;
%         SfWM(i1,i2) = interp1(w,squeeze(Sfgen(i1,i2,:)),wm);
%         covQ_r(i1,i2) = 1/Kgen(i1,i1)/Kgen(i2,i2) * SfWM(i1,i2) * wm * pi * xim / 2 / (e^2+xim^2);
%     end
% end
% Spectral.covq_MTSA = covQ_r+covQ_B;

%s = sqrt(diag(Spectral.covq_MTSA))

%% BISPECTRAL ANALYSIS
Bfgen = @(w1__,w2__,i,j,k) V(iload,i)*V(iload,j)*V(iload,k)*Bf(w1__,w2__);
H = @(w__,i) 1./(-Mgen(i,i)*w__.^2+1i*w__*Cgen(i,i)+Kgen(i,i));
Bq = @(w1__,w2__,i,j,k)  Bfgen(w1__,w2__,i,j,k).*H(w1__,i).*H(w2__,j).*conj(H(w1__+w2__,k));

if doFreqDomainBispe
    % define mesh
    commandwindow
    [w1,w2,SURF] = FrequencesBispectreMDDL3(omega(1:Nmodes), xi(1:Nmodes), wsollB);
    
    Spectral.w1 = w1;
    Spectral.w2 = w2;
    
    figure(1)
    subplot(121), semilogy(w,Sf(w))
    subplot(122), [w1_, w2_, B_] = plotBisp(w1,w2,(abs(Bf(w1,w2))),200);
    
    disp ('Check of integral of load bispectrum')
    disp ('should return the same results : ')
    
    integrateBisp(w1,w2,abs(Bf(w1,w2)),SURF)
    mom3F
    
    %%
    tic
    wb = waitbar(0,'Calcul des momoents d''ordre 3 : bispectral analysis');
    for i=1:Nmodes
        for j=i:Nmodes
            for k=j:Nmodes
                
                bisp_q = real(Bq(w1,w2,i,j,k));
                
                %             figure(999)
                %             subplot(121), semilogy(w,Sf(w))
                %             subplot(122), plotBisp(w1,w2,bisp_q,200);
                %             title (sprintf('Bispectrum of modal response (%d,%d,%d)',i,j,k)), drawnow
                
                waitbar(((i-1)*Nmodes^2+(j-1)*Nmodes+k)/Nmodes^3*3,wb)
                Spectral.m3Q(i,j,k) = integrateBisp(w1,w2,bisp_q,SURF);
                Spectral.m3Q(j,i,k) = Spectral.m3Q(i,j,k);
                Spectral.m3Q(i,k,j) = Spectral.m3Q(i,j,k);
                Spectral.m3Q(j,k,i) = Spectral.m3Q(i,j,k);
                Spectral.m3Q(k,i,j) = Spectral.m3Q(i,j,k);
                Spectral.m3Q(k,j,i) = Spectral.m3Q(i,j,k);
            end
        end
    end
    delete(wb)
    
    Spectral.momQ = nan(4,Nmodes);
    for i=1:Nmodes
        Spectral.momQ(i,2) = sqrt(Spectral.varq(i));
        Spectral.momQ(i,3) = Spectral.m3Q(i,i,i) / sqrt(Spectral.varq(i))^3;
    end
    
    Spectral.timeSpectralFull = toc;
    
    % Recombinaisons
    [Spectral.momX, Spectral.momX_CRSC] = spectral_recombine(Spectral.cov,Spectral.m3Q,V_all);
    [Spectral.momM, Spectral.momM_CRSC] = spectral_recombine(Spectral.cov,Spectral.m3Q,M_all);
    

end
%% % MTSA
tic
wb = waitbar(0,'Calcul des moments d''ordre 3 : MTSA bispectral analysis');
kg = diag(Kgen);
for i=1:Nmodes
    for j=i:Nmodes
        for k=j:Nmodes
            
            %bisp_q = real(Bq(w1,w2,i,j,k));
            
            Bfgen_ijk = @(w1,w2) Bfgen(w1,w2,i,j,k);
            mom3F_ijk = V(iload,i)*V(iload,j)*V(iload,k)*mom3F;
            
            [m3Q, B, BR, TR, br_ij, br_ik, br_jk] = ...
                MTSA_bicorr(Bfgen_ijk,mom3F_ijk,kg([i,j,k]),omega([i,j,k]),xi([i,j,k]), 3*omega(Nmodes)*linspace(-1,1,50000));
            
            waitbar(((i-1)*Nmodes^2+(j-1)*Nmodes+k)/Nmodes^3*3,wb)
            
            Spectral.m3Q_MTSA(i,j,k) = real(m3Q);
            Spectral.m3Q_MTSA(j,i,k) = Spectral.m3Q_MTSA(i,j,k);
            Spectral.m3Q_MTSA(i,k,j) = Spectral.m3Q_MTSA(i,j,k);
            Spectral.m3Q_MTSA(j,k,i) = Spectral.m3Q_MTSA(i,j,k);
            Spectral.m3Q_MTSA(k,i,j) = Spectral.m3Q_MTSA(i,j,k);
            Spectral.m3Q_MTSA(k,j,i) = Spectral.m3Q_MTSA(i,j,k);
            
            Spectral.m3Q_MTSA_B (i,j,k) = B;
            Spectral.m3Q_MTSA_BR(i,j,k) = real(BR);
            Spectral.m3Q_MTSA_TR(i,j,k) = TR;
        end
    end
end
delete(wb)

Spectral.timeSpectralMTSA = toc;

% Recombinaisons
[Spectral.momX_MTSA, Spectral.momX_MTSA_CRSC] = spectral_recombine(Spectral.cov,Spectral.m3Q_MTSA,V_all);
[Spectral.momM_MTSA, Spectral.momM_MTSA_CRSC] = spectral_recombine(Spectral.cov,Spectral.m3Q_MTSA,M_all);


