function Sol_Nodal = solutionNodal(M,K,C,Pgen,dt,N,t,nr,NDOF,CORRES,NElem,Ke)

[x_,~,~,x_qs_] = NewmarkMDDL(M,K,C,Pgen,dt,N);

x_ = x_(:,nr:end);

% Displacements at all dofs
x = zeros(NDOF,length(x_));
x(CORRES,:) = x_;

% Bending moments
M = computeBendingMoment(x,NElem,Ke);

Sol_Nodal.x = x(2:3:end,:);
Sol_Nodal.M = M;



x_qs_ = x_qs_(:,nr:end);
% Displacements at all dofs
x_qs = zeros(NDOF,length(x_qs_));
x_qs(CORRES,:) = x_qs_;

% Bending moments
M_qs = computeBendingMoment(x_qs,NElem,Ke);

Sol_Modal.x_qs = x_qs(2:3:end,:);
Sol_Modal.M_qs = M_qs;