function Sol_Modal = solutionModal(Mgen,Kgen,Cgen,Pgen,V,dt,N,t,nr,NDOF,CORRES,NElem,Ke)

[q,~,~,q_qs] = NewmarkMDDL(Mgen,Kgen,Cgen,Pgen,dt,N);
q = q (:,nr:end);
q_qs= q_qs(:,nr:end);

% Recombination of nodal responses : displacements
x = zeros(NDOF,size(q,2));
x(CORRES,:) = V*q;
x_qs = zeros(NDOF,size(q_qs,2));
x_qs(CORRES,:) = V*q_qs;

M =    computeBendingMoment(x,   NElem,Ke);
M_qs= computeBendingMoment(x_qs,NElem,Ke);

Sol_Modal.q = q;
Sol_Modal.x = x(2:3:end,:);
Sol_Modal.M = M;

Sol_Modal.q_qs = q_qs;
Sol_Modal.x_qs = x_qs(2:3:end,:);
Sol_Modal.M_qs = M_qs;



% create uncoupled q series (just to create the CRSC combination)
q_CRSC=q;
for i=1:size(q,1)
    rp = randperm(size(q,2));
    q_CRSC(i,:) = q(i,rp);
end

% Recombination of nodal responses : displacements
x_CRSC = zeros(NDOF,size(q_CRSC,2));
x_CRSC(CORRES,:) = V*q_CRSC;

M_CRSC = computeBendingMoment(x_CRSC,NElem,Ke);

Sol_Modal.q_CRSC = q_CRSC;
Sol_Modal.x_CRSC = x_CRSC(2:3:end,:);
Sol_Modal.M_CRSC = M_CRSC;


doPlot = 0;
if doPlot
    figure, plotTF(t,q)
    figure,  for i=1:3, histv(q(i,:)), hold on, end
end