function plotMom3(m3,varargin)
% plot elements of the 3rd moment matrix
%
% example :
% plotMom3(m3Q,'ko','MarkerFaceColor','k'); hold on



%% parse input data
parserObj = inputParser;
parserObj.KeepUnmatched = true;
parserObj.parse(varargin{:});
plotArgs = struct2pv(parserObj.Unmatched);

%% do plot

n = size(m3,1);

if any(size(m3,2)~=[n n n]); warning('plotMom3:: first argument must be a cubic tensor'); end

tmp = zeros(n,n,n);
labels={};
for i=1:n, for j=i:n,  for k=j:n, tmp(i,j,k)=1;
            labels{end+1}=sprintf('(%d,%d,%d)',i,j,k);
        end, end, end
tmp=tmp(:);
ii = (tmp==1);

m3Q = m3(:);
m3Q = m3Q(ii);

plot(m3Q,plotArgs{:});   hold on

set(gca,'XTick',1:length(labels))
set(gca,'XTickLabel',labels)
set(gca,'XTickLabelRotation',90)


end

function [pv_list, pv_array] = struct2pv (s)
p = fieldnames(s);
v = struct2cell(s);
pv_array = [p, v];
pv_list = reshape(pv_array', [],1)';
end