function [w1q, w2q, Bq] = plotBisp(w1,w2,B,npt, typePlot)

if nargin<4, npt=100; end
if ~mod(npt,2), npt=npt+1; end

if nargin<5, typePlot=3; end

% Construct the interpolant
F = scatteredInterpolant([-w1(:); w1(:)],[-w2(:); w2(:)],[B(:); B(:)],'linear');

lim = 0.4; % use this to zoom in
[w1q,w2q] = meshgrid(linspace(-lim*max(w1),lim*max(w1),npt),  linspace(-lim*max(w2),lim*max(w2),npt));
Bq = F(w1q,w2q);


switch typePlot
    
    case 1
        mesh( w1q, w2q,Bq); hold on;
        plot3(w1,w2,B,'.','color',[0.7 0.7 0.7],'Markersize',2); hold off
        
    case 2
        surf( w1q, w2q,Bq); hold on;
        plot3(w1,w2,B,'.','color',[0.7 0.7 0.7],'Markersize',2); hold off
        
    
    case 3
        
        lmax = log(max(abs(Bq(:))));
        cont = exp(lmax-10:2:lmax);
        cont = sort([-cont, cont]);
        [~,h]= contourf(w1q,w2q,Bq,cont);
        
        caxis ([-1 1]*sqrt(mean(abs(Bq(:)))*max(abs(Bq(:))))/4)
        myColormap(2);
        h.LineColor = [0.7 0.7 0.7]; h.LineWidth = 0.2;
end




