function [g,std] = peakVanmarckeMarkovFormula(m0,m1,m2,m4,N,T)
% Author(s): Blaise Nicolas
% Date: 24/02/2012
% See also: 
% Reference(s): Rice
%
% Aims
% ====
% Computing peak factors from the Rice's formula
% Inputs
% ======
% m0: statistical moment of order 0 [N x 1]
% m2: statistical moment of order 2 [N x 1]
% N: Number of processes [scalar]
% T: period of observation [scalar]; can be omitted
% Outputs
% =======
% g: peak factors [N x 1]
% Definition
% ==========
%
% Table of contents
% =================
% 
% Code
% ====

%% S: Handle missing arguments
if nargin==3
    T=10*60; %secondes
elseif nargin==2
    N=length(m0);
    T=10*60; %secondes
end
%%
eps=sqrt(1-m2^2/(m0*m4));
delta=sqrt(1-m1^2/(m0*m2));
%% S: Preallocating
g=zeros(N,1);
nu0p=zeros(N,1);
n0=zeros(N,1);
%% S: Predefined
gamma=0.5772;
%% S: Computation of the cross 0 rate
nu0p(:,1)=1/2/pi*sqrt(m2./m0);
n0=T.*nu0p; %Nombre de passage par 0 sur 10 minutes
%% S: Facteurs k
if delta<0.5
   Kappa_u=1.5*(1-exp(-1.8*delta));
   Kappa_alpha=7*delta;
else
   Kappa_u=0.94;
   Kappa_alpha=4.05;
end

%% S: Computation of the peak factors
for i=1:N
    if n0(i)>1
        g(i)=(sqrt(2*log(Kappa_u*n0(i)))+gamma./sqrt(2*log(Kappa_alpha*n0(i))));
        std(i)=pi*sqrt(m0(i))/(sqrt(6)*sqrt(2*log(Kappa_alpha*n0)));
    else
        g(i)=0;
    end
end



