function [g,n0,std] = peakSoizeFormula(m0,m2,N,T)
% Author(s): Blaise Nicolas
% Date: 24/02/2012
% See also: 
% Reference(s): Soize
%
% Aims
% ====
% Computing peak factors from the Rice's formula
% Inputs
% ======
% m0: statistical moment of order 0 [N x 1]
% m2: statistical moment of order 2 [N x 1]
% N: Number of processes [scalar]
% T: period of observation [scalar]; can be omitted
% Outputs
% =======
% g: peak factors [N x 1]
% Definition
% ==========
%
% Table of contents
% =================
% 
% Code
% ====

%% S: Handle missing arguments
if nargin==3
    T=10*60; %secondes
elseif nargin==2
    N=length(m0);
    T=10*60; %secondes
end
%% S: Preallocating
g=zeros(N,1);
nu0p=zeros(N,1);
n0=zeros(N,1);
%% S: Predefined
gamma=0.5772;
%% S: Computation of the cross 0 rate
nu0p(:,1)=1/2/pi*sqrt(m2./m0);
n0=T.*nu0p; %Nombre de passage par 0 sur 10 minutes
%% S: Computation of the peak factors
for i=1:N
    if n0(i)>1
        g(i)=(sqrt(2*log(n0(i)))+gamma./sqrt(2*log(n0(i))));
        std=pi*sqrt(m0)/(sqrt(6)*sqrt(2*log(T*nu0p)));
    else
        g(i)=0;
    end
end



