function [g,n0,std] = peakRiceFormula(m0,nu0p,N,T)
% Author(s): Blaise Nicolas
% Date: 24/02/2012
% See also: 
% Reference(s): Rice
%
% Aims
% ====
% Computing peak factors from the Rice's formula
% Inputs
% ======
% m0: statistical moment of order 0 [N x 1]
% nu0p:  [N x 1]
% N: Number of processes [scalar]
% T: period of observation [scalar]; can be omitted
% Outputs
% =======
% g: peak factors [N x 1]
% Definition
% ==========
%
% Table of contents
% =================
% 
% Code
% ====

%% S: Handle missing arguments
if nargin==3
    T=10*60; %secondes
elseif nargin==2
    N=length(m0);
    T=10*60; %secondes
end
%% S: Preallocating
g=zeros(N,1);
std=zeros(N,1);
%% S: Predefined
gamma=0.5772;
%% S: Computation of the cross 0 rate
n0=T.*nu0p; %Nombre de passage par 0 sur 10 minutes
%% S: Computation of the peak factors
for i=1:N
    if n0(i)>1 && m0(i)~=0
        g(i)=(sqrt(2*log(n0(i)))+gamma./sqrt(2*log(n0(i))));
        std(i)=pi*sqrt(m0(i))/(sqrt(6)*sqrt(2*log(T*nu0p(i))));
    else
        g(i)=0;
    end
end



