function [gNG,nu0pNG,nu0nNG,Gamma3] = peakKareemFormula(m0,nu0p,Gamma3,Gammae,T,Typenu0p)
% Author(s): Blaise Nicolas
% Date: 28/05/2014
% See also: 
% Reference(s): Kareem and Zhao, 1994
%
% Aims
% ====
% Computing peak factor using cubic transformation
% Inputs
% ======
% m0: spectral moment of order 0      [N x 1] 
% m2: spectral moment of order 2      [N x 1]
% Gamma3: Skewness coefficient        [N x 1]
% Gammae: Excess kurtosis coefficient [N x 1]
% N: Number of processes              [scalar]
% T: period of observation [scalar]; 
% Outputs
% =======
% gNG: Non-Gaussian peak factors      [N x 2]

%% S: Preallocating
N=length(m0);
%% S: Vertical Mapping if necessary
for i=1:N
   [Gamma3VM] = KG_VerticalMapping(Gammae(i),Gamma3(i),0);
   if abs(Gamma3(i)) > abs(Gamma3VM)
       disp('Vertical Mapping')
       disp('================')
       disp(['Gamma3(',num2str(i),'): ',num2str(Gamma3(i)),' -> ',num2str(Gamma3VM),' | Gammae:',num2str(Gammae(i))]);
       Gamma3(i)=Gamma3VM;
   end
end
%% S: Cubic transformation
cumpos=[zeros(1,N); (m0./m0)'; Gamma3';Gammae'];
cumneg=[zeros(1,N); (m0./m0)'; -Gamma3';Gammae'];
%% S: Positive peak factor
[gNGpos(:,1),nu0pNG] = peakFormula(cumpos,m0,nu0p,T,Typenu0p);
[gNGneg(:,1),nu0nNG] = peakFormula(cumneg,m0,nu0p,T,Typenu0p);
gNGneg=-gNGneg;

gNGpos(isnan(gNGpos(:,1)),1)=0;
gNGneg(isnan(gNGneg(:,1)),1)=0;

gNG=[gNGpos gNGneg];
end

function [gNG,nu0p_] = peakFormula(cum,m0,nu0p,T,Typenu0p)
N=length(m0);
n0_=zeros(N,1);
a=zeros(N,1);
b=zeros(N,1);
alpha=zeros(N,1);
h3=zeros(N,1);
h4=zeros(N,1);
for i=1:N
    if isnan(cum(2,i))~=1
        %disp([num2str(i),'/',num2str(N)]);
        [a(i,1),b(i,1),alpha(i,1)] = KG_cumulants_inversion (cum(:,i));
        [h3(i,1),h4(i,1)] = KG_param2h3h4(a(i,1),b(i,1));
    end
end
%% S: Computation of the cross 0 rate
if strcmp(Typenu0p,'Time-domain')==1
    nu0p_(:,1) =  nu0p; 
elseif strcmp(Typenu0p,'RiceEq')==1
    nu0p_(:,1) = 1./(alpha.^2.*(1+4.*h3.^2+18.*h4.^2)) .* nu0p; 
end
n0_=T.*nu0p_; %Nombre de passage par 0 sur 10 minutes
beta=sqrt(2.*log(n0_));
%% S: Computation of the peak factors
gamma=0.5772;
gNG=zeros(N,1);
gNG=alpha.*((beta+gamma./beta))+h3.*(beta.^2+2*gamma-1)+...
    h4.*(beta.^3+3.*beta.*(gamma-1)+3./beta.*(pi^2/12-gamma+gamma^2/2));
end
