function [g] = peakIshikawaFormula(m0,m2,mu3,mu4,N,T)
% Author(s): Blaise Nicolas
% Date: 24/02/2012
% See also: 
% Reference(s): Soize
%
% Aims
% ====
% Computing peak factors from the Rice's formula
% Inputs
% ======
% m0: spectral moment of order 0 [N x 1]
% m2: spectral moment of order 2 [N x 1]
% mu3: central statistical moment of order 3 [N x 1]
% mu4: central statistical moment of order 4 [N x 1]
% N: Number of processes [scalar]
% T: period of observation [scalar]; can be omitted
% Outputs
% =======
% g: peak factors [N x 1]
% Definition
% ==========
%
% Table of contents
% =================
% 
% Code
% ====

%% S: Handle missing arguments
if nargin==3
    T=10*60; %secondes
elseif nargin==2
    N=length(m0);
    T=10*60; %secondes
end
%% S: Preallocating
g=zeros(N,1);
nu0p=zeros(N,1);
n0=zeros(N,1);
%% S: Computing h3, h4 and k
h3=mu3./(4+2.*sqrt(1+(3.*(mu4-3))/2));
h4=(sqrt(1+(3.*(mu4-3))/2)-1)./18;
k=1./sqrt(1+2*h3^2+6*h4^2);
%% S: Computation of the cross 0 rate
nu0p(:,1)  = 1/2/pi*sqrt(m2./m0); %zero up-crossing number in T
nu0p_(:,1) = 1/(sqrt(1+4.*h3.^2+18*h4^2)) .* nu0p; 
n0_=T.*nu0p_; %Nombre de passage par 0 sur 10 minutes
%% S: Computation of the peak factors
for i=1:N
    if n0_(i)>1
        g(i)=k(i)*(sqrt(2*log(n0_(i)))+ ...
            h3(i)*(2*log(n0_(i))-1) + ...
            h4*( (2*log(n0_(i)))^(3/2) - 3*sqrt(2*log(n0_(i)))) );
    else
        g(i)=0;
    end
end
