function M = myColormap(typeScale,map)
% just write 'myColormap' to have a colormap running from red to blue.


if nargin<1; typeScale = 1; end
if nargin<2; map = 2;       end


switch map
    case 1 % pure red & pure blue
        Color{1} = [0 0 1]; % red
        Color{2} = [1 1 1]; % white
        Color{3} = [1 0 0]; % blue
    case 2 % dark red and dark blue
        Color{1} = [115  14  35]/255; % red
        Color{2} = [230 131 102]/255;
        Color{3} = [1 1 1];           % white
        Color{4} = [112 176 211]/255;
        Color{5} = [ 24  56  99]/255; % blue
    case 3 % dark red and dark blue with grey in-between
        Color{1} = [115  14  35]/255; % red
        Color{2} = [230 131 102]/255;
        Color{3} = [.7 .7 .7];           % white
        Color{4} = [112 176 211]/255;
        Color{5} = [ 24  56  99]/255; % blue        
end

n = 50;

CM1 = [];
for i=1:length(Color)-1
    for rgb = 1:3
        CM(1:n,rgb) = linspace(Color{i}(rgb),Color{i+1}(rgb), n);
    end
    CM1 = [CM1; CM];
end
c1 = linspace(-1,1,size(CM1,1));

switch typeScale
    case 1 % use this for figure with just one plot
        c = caxis;
        c = c/max(abs(c));
        for rgb = 1:3
            M(:,rgb) = interp1(c1,CM1(:,rgb),linspace(c(1),c(2),n));
        end
        
        
        
    case 2 % use this for figures with subplots
        c = caxis;
        mc= max(abs(c));
        caxis ([-1 1]*mc)
        M = CM1;
        
end

colormap(M)
