function [u,t] = generateSamples(S,N,dt)
% u = GENERATESAMPLES(S,N,dt) returns a sample with length N and samping
% time step dt, drawn from the process described by the PSD @(w) S(w).
%
% S must be normalized such that the integral of S over w in [-inf,inf]
% returns the variance. It is possible to check that :
% var(u) and 2*trapz(w,S) are equal (up to sampling error) for a suitable
% choice of w ranging from 0 to sufficiently large.
%
% Example : 
% sigw = 1;
% beta = 0.1;
% Sw = @(w_)  sigw^2/pi * beta ./ (beta^2 + w_.^2);
% N = 1e4; dt = 0.0.1;
% [w,t] = generateSamples(Sw,N,dt)


t = (0:N-1)*dt;

wmax = 2*pi/dt;
w    = linspace(0,wmax,N);
dw   = w(2);
S    = S(w);

fft_u           = N*sqrt(S(:)*dw).*exp(2*pi*1i*rand(N,1));
fft_u(1)        = 0;
fft_u(N/2+1)    = 0;
fft_u(N/2+2:N)  = conj(fft_u(N/2:-1:2));

u = ifft(fft_u);
