figure

for i=1:nRun;
    z = Sol_Nodal{i}.M;
    
    nw = 600/dt;
    nn = floor(size(z,2) / nw);
    
    for k=1:nn;
        ii = (1:nw)+nw*(k-1);
        
        vmax(:,k) = max(z(:,ii),[],2);
        vmin(:,k) = min(z(:,ii),[],2);
        vavg(:,k) = mean(z(:,ii),2);
        vstd(:,k) = std(z(:,ii),1,2);
        vskw(:,k) = skewness(z(:,ii),1,2);
        
    end
    
    vmax = mean(vmax,2);
    vmin = mean(vmin,2);
    vavg = mean(vavg,2);
    vstd = mean(vstd,2);
    vskw = mean(vskw,2);
    
    subplot(221)
    plot(XNOD, vmax,  XNOD, vmin , XNOD, vavg, XNOD, vstd), hold on
    
    subplot(222)
    plot(XNOD, (vmax-vavg)./vstd, XNOD, (vavg-vmin)./vstd), hold on
    
    subplot(223)
    plot(vskw, (vmax-vavg)./vstd), hold on
    
    subplot(224)
    plot(vskw, (vavg-vmin)./vstd), hold on    
    
    drawnow

end
%%
KareemZhao = [0	4.14	-4.14
0.058	4.29	-3.98
0.087	4.38	-3.91
0.113	4.46	-3.85
0.138	4.53	-3.78
0.194	4.69	-3.64
0.25	4.85	-3.5
0.307	5.02	-3.37
0.355	5.16	-3.26
0.397	5.29	-3.16];

skwval = 0:0.05:0.4;
nu0=2.5;
for t=1:length(skwval)    
    [g(t,:),~,~, gamma3(t)] = peakKareemFormula(1,nu0,0.5,skwval(t),600,'RiceEq')
end
KareemZhao = [gamma3(:) g];

KareemZhao = sort([KareemZhao; -KareemZhao(2:end,1), -KareemZhao(2:end,3) -KareemZhao(2:end,2)]);

subplot(223)
plot( KareemZhao(:,1), KareemZhao(:,2),'k','linewidth',2)
%plot(-KareemZhao(:,1),-KareemZhao(:,3),'k','linewidth',2)
subplot(224)
plot( KareemZhao(:,1),-KareemZhao(:,3),'k','linewidth',2)
%plot(-KareemZhao(:,1), KareemZhao(:,2),'k','linewidth',2)

m3M = Spectral.momM(:,3);
for i=1:length(m3M)
    gmax_KZ(i) = interp1(KareemZhao(:,1),KareemZhao(:,2),m3M(i),'spline','extrap');
    gmin_KZ(i) = interp1(KareemZhao(:,1),KareemZhao(:,3),m3M(i),'spline','extrap');
end
subplot(222)
plot(XNOD, gmax_KZ,'k.', XNOD, -gmin_KZ,'k.'), hold on


subplot(221)
plot(XNOD, vavg+gmax_KZ'.*vstd,'k.'), hold on
plot(XNOD, vavg+gmin_KZ'.*vstd,'k.'), hold on
%%
figure
for i=1:nRun;
    z = Sol_Nodal{i}.M;
    histv(z(8,:)); hold on, drawnow
end


for i=1:nRun;
    z = Sol_Nodal{i}.M;
    histv(z(25,:)); hold on, drawnow
end
%%
