function Sol = doStats(Sol)
% Do statistics on time series
% Sol is supposed to have fields like q, x and M

f = fields(Sol);
for i=1:length(f)
    switch f{i}
        case 'q'
            Sol.momQ = allMoments(Sol.q);
            Sol.m3Q  = fullM3(Sol.q);
        case 'q_qs'
            Sol.momQ_qs = allMoments(Sol.q_qs);
            Sol.m3Q_qs  = fullM3(Sol.q_qs);
        case 'q_CRSC'
            Sol.momQ_CRSC = allMoments(Sol.q_CRSC);
            Sol.m3Q_CRSC  = fullM3(Sol.q_CRSC);
         
            
        case 'x'
            Sol.momX = allMoments(Sol.x);
        case 'x_qs'
            Sol.momX_qs = allMoments(Sol.x_qs);
        case 'x_CRSC'
            Sol.momX_CRSC = allMoments(Sol.x_CRSC);
         
            
        case 'M'
            Sol.momM = allMoments(Sol.M);
        case 'M_qs'
            Sol.momM_qs = allMoments(Sol.M_qs);
        case 'M_CRSC'
            Sol.momM_CRSC = allMoments(Sol.M_CRSC);
    end
end


function moments = allMoments(y)
% unilateral moments (mean, std, skw, exc)
if size(y,1)>size(y,2); y=y'; end % row = dofs or mode // column = time
nsig = size(y,1);
moments = nan(nsig,4);
for k=1:nsig
    moments(k,:)=MomentsStatistiques(y(k,:),4);
end


function m3  = fullM3(y)
% All 3rd central moments
if size(y,1)>size(y,2); y=y'; end % row = dofs or mode // column = time
nsig = size(y,1);
m3 = nan(nsig,nsig,nsig);

for i1=1:nsig
    for i2=1:nsig
        for i3=1:nsig
            m3(i1,i2,i3) = mean((y(i1,:)-mean(y(i1,:))).*(y(i2,:)-mean(y(i2,:))).*(y(i3,:)-mean(y(i3,:))));
        end
    end
end