function M = computeBendingMoment(x,NElem, Ke)

M = zeros(NElem,2,size(x,2)); % NElements, 2 nodes, N time steps

for iel=1:NElem
    elemdof = (iel-1)*3+(1:6);
    xloc=x(elemdof,:);
    Fint_=Ke(:,:,iel)*xloc;
    M(iel,1,:) = -Fint_(3,:); % axial force
    M(iel,2,:) =  Fint_(6,:);
end

M = [squeeze(M(1,1,:) )' ;  squeeze(M(2:end,1,:)+M(1:end-1,2,:))/2 ; squeeze(M(end,2,:) )'];