function [p] = QU_Univariate (X,U,Plot,clr)

%% Compute the pdf of the transformation gamma (-1 + 2 a u + u)
p=zeros(length(X),1);
a=U;
Gamma=1/sqrt(2*(1+2*a^2));
for i=1:length(X)   
    usol1=-a-sqrt(1+a^2+x/Gamma);
    usol2=-a-sqrt(1+a^2+x/Gamma);
    p(i) = 1/2/sqrt(Gamma^2*Cst+Gamma*X(i)) * ( normpdf(-U+sqrt(Cst+X(i)/Gamma),0,sigma) + normpdf(-U-sqrt(Cst+X(i)/Gamma),0,sigma) );
end
p(1)=0;

%% S: Moments and cumulants

disp('Squared Gaussian distribution')
disp('=============================')

[M] = MomentsFromUnivariatePdf(X',p');
%[K] = Moments2Cumulants(M.m);
MA.m(1)=Gamma*(sigma^2+U^2);
MA.cm(2)=2*Gamma^2*sigma^2*(sigma^2+2*U^2);
MA.gamma1=2*sqrt(2)*sigma*(sigma^2+3*U^2)/(sigma^2+2*U^2)^(3/2);
MA.beta2=15-48*U^4/(sigma^2+2*U^2)^2;
MA.gamma2=MA.beta2-3;
%% S: Plot

[~,Imode]=max(p);

Imean=find(X>M.m(1),1);
Xmean=(X(Imean-1)+X(Imean))/2;
pmean=(p(Imean-1)+p(Imean))/2;

% [mean_u,Imean]=mean(u);
% mode_u=X(I);%mode(u);
% [median_u=median(u);

%disp('Mode: ',num2str(X(I));
if Plot==1
    plot(X,p,'color',clr); hold on
    ylabel('Density')
    %plot(mean_u,0.5,[clr,'s']);
    plot(X(Imode),max(p),[clr,'s']);
    %plot(median_u,0.5,'k-');
    plot(Xmean,pmean,[clr,'d']);
    xlabel('X','fontsize',10)
    %plot(mode_u.*ones(2,1),[0 max(p_u)],'k-');
    %plot(median_u.*ones(2,1),[0 max(p_u)],'k-');
    %legend(h,'Ref')
end