function [p] = BivariateSquaredGaussianPDF (X,Y,U,Gamma,Covu,C,Type)

U1=U(1);
U2=U(2);
C1=C(1);
C2=C(2);
p=zeros(length(X),length(Y));

[Xgrid,Ygrid] = meshgrid(X,Y);

x1=-U1-sqrt(C1+X./Gamma);
x2=-U1+sqrt(C1+X./Gamma);

z1=-U2-sqrt(C2+Y./Gamma);
z2=-U2+sqrt(C2+Y./Gamma);


for i=1:length(X)
    for j=1:length(Y)
        p(i,j)= 1/4/Gamma/sqrt(X(i)*Y(j))*(mvnpdf([x2(i) z2(j)],[0 0],Covu) + mvnpdf([x1(i) z2(j)],[0 0],Covu)+...
                 mvnpdf([x2(i) z1(j)],[0 0],Covu) + mvnpdf([x1(i) z1(j)],[0 0],Covu)) ;
    end
end
p(:,1)=zeros(length(X),1);
p(1,:)=zeros(1,length(Y));
%% S: Moments
disp('Normal bivariate Squared distribution')
disp('=====================================')
MomentsFromBivariatePdf(X,Y,p)
%% S: Plot
if strcmp(Type,'surf')==1
    surf(Xgrid,Ygrid,p);
elseif strcmp(Type,'mesh')==1
    mesh(Xgrid,Ygrid,p);
elseif strcmp(Type,'contour')==1
    contour(Xgrid,Ygrid,p); hold on
end
xlabel('X','fontsize',12)
ylabel('Y','fontsize',12)

