function [nu0pNG]=KG_peakfactors(nu0p,P)


a=-40:0.1:40;
gamma3full=(6*sqrt(3).*a.*(15 + 16*a.^2 + 3.*a.^4))./(5 + 12*a.^2 + 3*a.^4).^(3/2);
gammaefull=(3*(385+1920.*a.^2+1326*a.^4+240*a.^6+9*a.^8))./(5+12*a.^2+3*a.^4).^2-3;

Gamma3=-2:0.1:2;
Gammae=0:0.1:6.5;
p=NaN(length(Gamma3),length(Gammae));
p1=NaN(length(Gamma3),length(Gammae));

for k=1:length(Gamma3)
    [Gammae_min] = KG_LimitsGamma(Gamma3(k),[],0);
    for l=1:length(Gammae);
        if Gammae(l)>Gammae_min
        K=[0; 1; Gamma3(k); Gammae(l)];
        [gNG,nu0pNG]=peakKareemFormula(1,nu0p,Gamma3(k),Gammae(l),600,'RiceEq');
        p(k,l)=gNG(1);
        p1(k,l)=nu0pNG./nu0p;
        end
    end
end

[Gammaegrid,Gamma3grid] = meshgrid(Gammae,Gamma3);
if P==1; contourplot (gammaefull,gamma3full,Gammaegrid,Gamma3grid,p,1); end 
if P==2; contourplot (gammaefull,gamma3full,Gammaegrid,Gamma3grid,p1,2); end
end

function contourplot (gammaefull,gamma3full,Gammaegrid,Gamma3grid,p,j)
figure(1)
[c,h]=contour(Gammaegrid,Gamma3grid,p,'color',[0.880722 0.611041 0.142051]); grid on; hold on
Z=clabel(c,'FontSize',7);%,'LabelSpacing',144);
%clabel(c,h,'FontSize',8)   
%set(h,'ShowText','on')
if 0==1
    %texth=clabel(c,h)%'fontsize', 7); %,'manual','fontsize', 20);
    texth=get(h,'TextList');%
    for i=1:size(texth)
        textstr=get(texth(i),'String');
        textnum(i)=str2double(textstr);
        %textstrnew(i)=sprintf('%0.1f', textnum(i));
        position(i,:)=get(texth(i),'Position');
        %set(texth(i),'String',textstrnew);
    end

%close(j); figure(j)
hold on
[c,h]=contour(Gammaegrid,Gamma3grid,p,7,'color',[0.880722 0.611041 0.142051])%[0.3684 0.5067 0.7098]); 
grid on
end
plot(gammaefull,gamma3full,'k'); 

if 1==0
    [~,Index] = unique(textnum);%,'stable');
    for k=1:length(Index)
        i=Index(k);
        if j==1
            text(position(i,1),position(i,2),num2str(round(textnum(i)*10)/10),'fontsize',7)
        elseif j==2;
            text(position(i,1),position(i,2),num2str(round(textnum(i)*100)/100),'fontsize',7)
        end
    end
end
end

