function [a,b,alpha,c,gamma3_,gammae_,ml] = KG_cumulants_inversion (cum)

% cum [4xN]
N=size(cum,2);
a=zeros(N,1);
b=zeros(N,1);
alpha=zeros(N,1);
c=zeros(N,1);
gamma3_=zeros(N,1);
gammae_=zeros(N,1);
ml=zeros(N,1);

for i=1:N
    [cum(3,i),cum(4,i)] = KG_CheckMapping(cum(4,i),cum(3,i));
    if cum(2,i)~=0
        [a(i,1),b(i,1),alpha(i,1),c(i,1),~,~,gamma3_(i,1),gammae_(i,1)] = cumulants_inversion (cum(:,i));
        ml(i,1)=b(i,1)-1-a(1,i)^2;
    end
end


end

function [a,b,alpha,c,h3,h4,gamma3_,gammae_] = cumulants_inversion (cum)
if (length(cum) ~= 4)
    disp('cum must be a vector of length 4')
end

gamma3=cum(3);
gammae=cum(4);

if 1==1
    if 1==1
        h3=gamma3/(4+2*sqrt(1+1.5*gammae));
        h4=(sqrt(1+1.5*gammae)-1)/18;
    else
        [h3,h4] = Estimationsh3h4(gamma3,gammae);
    end
    
    x0 = [h3; h4];                                     % Make a starting guess at the solution
    options=optimset('TolX',1e-16,'Diagnostics','off','Display','off');   % Option to display output
    f = @(x)skt_cumulants_matching(x,gamma3,gammae);
    %disp([num2str(h3),' ',num2str(gamma3),' ',num2str(gammae)]);
    [x,fval] = fsolve(f,x0,options);  % Call solver;
    
    h3=x(1);
    h4=x(2);
    gamma3_=2*h3*(3+4*h3^2+18*h4+54*h4^2)/(sqrt(1+2*h3^2+6*h4^2))^3;
    gammae_=3*(1+20*h3^4+8*h4+84*h4^2+432*h4^3+1116*h4^4+4*h3^2*(5+48*h4+186*h4^2))/(1+2*h3^2+6*h4^2)^2-3;
else
    [h3,h4] = Estimationsh3h4(gamma3,gammae);
    gamma3_=2*h3*(3+4*h3^2+18*h4+54*h4^2)/(sqrt(1+2*h3^2+6*h4^2))^3;
    gammae_=3*(1+20*h3^4+8*h4+84*h4^2+432*h4^3+1116*h4^4+4*h3^2*(5+48*h4+186*h4^2))/(1+2*h3^2+6*h4^2)^2-3;
end


if gamma3==0 && gammae==0%h3+h4==0
    a=0;
    alpha=1;
    b=Inf;
else
    a=h3/(3*h4);
    b=1/(3*h4);
    alpha=sqrt(cum(2))/sqrt(1+2*h3^2+6*h4^2);
end

if (b-1-a^2)<0
%     for i=1:1;
%         disp('Warning (b-1-a^2)>0 not satisfied')
%         disp([num2str((b-1-a^2)),'<0'])
%     end
end

c=(b-1-a^2)^3;
end

function   [F] = skt_cumulants_matching (par,gamma3,gammae)
h3=par(1); h4=par(2);
F=[gamma3-2*h3*(3+4*h3^2+18*h4+54*h4^2)/(sqrt(1+2*h3^2+6*h4^2))^3;
    (gammae+3)-3*(1+20*h3^4+8*h4+84*h4^2+432*h4^3+1116*h4^4+4*h3^2*(5+48*h4+186*h4^2))/(1+2*h3^2+6*h4^2)^2];
end

function [h3,h4] = Estimationsh3h4(gamma3,gammae)
%Probabilistic modeling of wind pressure on low-rise buildings
%Luping Yang, Kurtis R. Gurley, David O. Prevatt
p_=[0.1967    -0.0721;...
    -1.646e-2 0.03176;...
    1.809e-2  -0.02942;...
    7.438e-4  -0.00179;...
    -9.209e-4 0.002348;...
    -1.366e-5 5.965e-5;...
    1.527e-4  -6.282e-4;...
    1.07e-5   -6.355e-5;...
    8.823e-8  -9.692e-7;...
    0         1.497e-5;...
    0         5.457e-7;...
    0         6.049e-9];
p=p_(:,1);
g3=gamma3; g4=gammae+3;
h3=p(1)*g3+p(2)*g3*g4+p(3)*g3^3+p(4)*g3*g4^2+p(5)...
    *g3^3*g4+p(6)*g3*g4^3+p(7)*g3^5+p(8)*g3^3*g4^2+p(9)*g3*g4^2;
p=p_(:,2);
h4=p(1)+p(2)*g4+p(3)*g3^2+p(4)*g4^2+p(5)*g3^2*g4+p(6)*g4^3+...
    p(7)*g3^4+p(8)*g3^2*g4^2+p(9)*g4^4+p(10)*g3^4*g4+p(11)*...
    g3^2*g4^3+p(12)*g4^5;
end


