function [NG]=KG_covarA(nu0p,T,eps)

a=-40:0.1:40;

Gamma3=-2:0.2:2;
Gammae=0:0.2:6.5;
MeanmaxA=NaN(length(Gamma3),length(Gammae));
MeanminA=NaN(length(Gamma3),length(Gammae));
gKwonmax=NaN(length(Gamma3),length(Gammae));
gKwonmin=NaN(length(Gamma3),length(Gammae));
StdmaxA=NaN(length(Gamma3),length(Gammae));
StdminA=NaN(length(Gamma3),length(Gammae));

fqmaxN=NaN(length(Gamma3),length(Gammae));
sqmaxN=NaN(length(Gamma3),length(Gammae));
tqmaxN=NaN(length(Gamma3),length(Gammae));

MeanmaxN=NaN(length(Gamma3),length(Gammae));
StdmaxN=NaN(length(Gamma3),length(Gammae));
fkappamaxN=NaN(length(Gamma3),length(Gammae));
skappamaxN=NaN(length(Gamma3),length(Gammae));
tkappamaxN=NaN(length(Gamma3),length(Gammae));
             
fqmaxA=NaN(length(Gamma3),length(Gammae));
sqmaxA=NaN(length(Gamma3),length(Gammae));
tqmaxA=NaN(length(Gamma3),length(Gammae));

fqminN=NaN(length(Gamma3),length(Gammae));
sqminN=NaN(length(Gamma3),length(Gammae));
tqminN=NaN(length(Gamma3),length(Gammae));

MeanminN=NaN(length(Gamma3),length(Gammae));
StdminN=NaN(length(Gamma3),length(Gammae));
fkappaminN=NaN(length(Gamma3),length(Gammae));
skappaminN=NaN(length(Gamma3),length(Gammae));
tkappaminN=NaN(length(Gamma3),length(Gammae));
             
fqminA=NaN(length(Gamma3),length(Gammae));
sqminA=NaN(length(Gamma3),length(Gammae));
tqminA=NaN(length(Gamma3),length(Gammae));

[Gammaegrid,Gamma3grid] = meshgrid(Gammae,Gamma3);

Gammae_min=zeros(length(Gamma3),1);
ml=zeros(length(Gamma3),length(Gammae));
for k=1:length(Gamma3)
    [Gammae_min(k)] = KG_LimitsGamma(Gamma3(k),[],0);
    for l=1:length(Gammae);
        if Gammae(l)>=1.05*Gammae_min(k)
            [~,~,~,~,~,~,ml_] = KG_cumulants_inversion ([0 1 Gamma3(k) Gammae(l)]');
            if imag(ml_)==0;
            ml(k,l)=ml_;
            %% Analytic
            K=[0; 1; Gamma3(k); Gammae(l)];
            [g,~,~,std,~,~,gKwon]=peakKareemFormula(1,nu0p,Gamma3(k),Gammae(l),T,'RiceEq');
            MeanmaxA(k,l)=g(1); gKwonmax(k,l)=gKwon(1);
            MeanminA(k,l)=g(2); gKwonmin(k,l)=gKwon(2);
            StdmaxA(k,l)=std(1);
            StdminA(k,l)=std(2);
            %% Numerical
             N=(nu0p*T)/sqrt(1-eps^2);
            %% Max    
             etamax=[]; etamax(:,1)=0:StdmaxA(k,l)/1000:MeanmaxA(k,l)+15*StdmaxA(k,l);
             [pextmax,Pextmax] = KG_pdfcdfExtremum (etamax,eps,N,K);
             %plot(etamax,pextmax); hold on; plot(etamax,Pextmax)
             %plot(etamax,(etamax-trapz(etamax,etamax.*pextmax)).^2.*pextmax)
             fqmaxN(k,l)=etamax(find(Pextmax>0.57,1));
             sqmaxN(k,l)=etamax(find(Pextmax>0.78,1));
             tqmaxN(k,l)=etamax(find(Pextmax>0.86,1));
             
             MeanmaxN(k,l)=trapz(etamax,etamax.*pextmax);
             StdmaxN(k,l)=sqrt(trapz(etamax,(etamax-trapz(etamax,etamax.*pextmax)).^2.*pextmax));
             fkappamaxN(k,l)=(fqmaxN(k,l)-MeanmaxN(k,l))/StdmaxN(k,l);
             skappamaxN(k,l)=(sqmaxN(k,l)-MeanmaxN(k,l))/StdmaxN(k,l);
             tkappamaxN(k,l)=(tqmaxN(k,l)-MeanmaxN(k,l))/StdmaxN(k,l);
             
             fqmaxA(k,l)=MeanmaxA(k,l);
             sqmaxA(k,l)=MeanmaxA(k,l)*(1+0.636*(StdmaxA(k,l)./MeanmaxA(k,l)));
             tqmaxA(k,l)=MeanmaxA(k,l)*(1+1.025*(StdmaxA(k,l)./MeanmaxA(k,l)));
             %% Min
             etamin=[]; etamin(:,1)=MeanminA(k,l)-15*StdminA(k,l):StdminA(k,l)/1000:0;
             [~,~,pextmin,Pextmin] = KG_pdfcdfExtremum (etamin,eps,N,K);
             %plot(etamin,pextmin); hold on; plot(etamin,Pextmin)
             %plot(etamin,(etamin-trapz(etamin,etamin.*pextmin)).^2.*pextmin)
             fqminN(k,l)=etamin(find((1-Pextmin)>0.57,1,'last'));
             sqminN(k,l)=etamin(find((1-Pextmin)>0.78,1,'last'));
             tqminN(k,l)=etamin(find((1-Pextmin)>0.86,1,'last'));
             if 1==0
                 plot(etamin,pextmin); hold on; plot(etamin,(1-Pextmin)); hold on;
                 plot([tqminN(k,l) tqminN(k,l)],[0 1],'r'); plot([sqminN(k,l) sqminN(k,l)],[0 1],'r')
             end
             MeanminN(k,l)=trapz(etamin,etamin.*pextmin);
             StdminN(k,l)=sqrt(trapz(etamin,(etamin-trapz(etamin,etamin.*pextmin)).^2.*pextmin));
             fkappaminN(k,l)=(fqminN(k,l)-MeanminN(k,l))/StdminN(k,l);
             skappaminN(k,l)=(sqminN(k,l)-MeanminN(k,l))/StdminN(k,l);
             tkappaminN(k,l)=(tqminN(k,l)-MeanminN(k,l))/StdminN(k,l);
             
             fqminA(k,l)=MeanminA(k,l);
             sqminA(k,l)=MeanminA(k,l)*(1+0.636*(StdminA(k,l)./MeanminA(k,l)));
             tqminA(k,l)=MeanminA(k,l)*(1+1.025*(StdminA(k,l)./MeanminA(k,l)));
            end
        end
    end
end
%plot(Gammae_min,Gamma3,'rx'); hold on; KG_LimitsGamma([],[],1); set(gca,'xlim',[0 6.5])
NG=ws2struct;
end


