function [Gamma3VM,Gamma3,Gammae,VM] = KG_VerticalMapping(Gammae,Gamma3,FIG)

a=-1800:0.1:1800;%-40:0.1:40;
gamma3full=(6*sqrt(3).*a.*(15 + 16*a.^2 + 3.*a.^4))./(5 + 12*a.^2 + 3*a.^4).^(3/2);
gammaefull=(3*(385+1920.*a.^2+1326*a.^4+240*a.^6+9*a.^8))./(5+12*a.^2+3*a.^4).^2-3;

if Gammae>0
    clear a; a=-1800:0.1:1800;%-40:0.1:40;
    f2 = @(a)a_matchingGe(a,Gammae);
    options=optimset('Display','off'); %options=optimset('TolX',1e-016,'Display','off');   % Option to display output
    tmp = abs(gammaefull-Gammae);
    [idx, idx] = min(tmp); %index of closest value
    closest = a(idx); %closest value
    clear a;
    [a,fval,exitflag,output] = fsolve(f2,closest,options);
    
    Gamma3VM=sign(Gamma3)*abs((6*sqrt(3)*a*(15 + 16*a^2 + 3*a^4))/(5 + 12*a^2 + 3*a^4)^(3/2));
    Gamma3VM=0.99*Gamma3VM;
%     [a,b] = KG_cumulants_inversion ([0; 1; Gamma3VM; Gammae]);    
%     if b-1-a^2<0 
%         [Gamma3VM] = fsolve(@(Gamma3VM)mlzero(Gamma3VM,Gammae),0.9*Gamma3VM,options);
%     end
else
    Gamma3VM=0;
end

if Gammae>0
    if abs(Gamma3) > abs(Gamma3VM)
        VM=1;
        Gamma3=Gamma3VM;
        Gammae=Gammae;
    else
        VM=0;
        Gamma3=Gamma3;
        Gammae=Gammae;
    end
else
    VM=2;
    Gammae=0;
    Gamma3=0;
end


if FIG==1
    
    disp('VerticalMapping')
    disp('===============')
    disp(['Gamma3: ',num2str(Gamma3),' -> ',num2str(Gamma3VM)]);
    plot(gammaefull,gamma3full,'k'); hold on
    plot(Gammae,Gamma3VM,'g.');
    plot(Gammae,Gamma3,'r.');
end

end

function [F]= a_matchingGe(a,Gammae)
    F=Gammae-((3*(385+1920*a^2+1326*a^4+240*a^6+9*a^8))./(5+12*a^2+3*a^4)^2-3);
end

function [F]= mlzero(Gamma3,Gammae)
    [a,b] = KG_cumulants_inversion ([0; 1; Gamma3; Gammae]);
    F=b-1-a^2;
end