function [p,F] = KG_UnivariateCDFmapping(Xt,fig)
%% Fonction
% compute the pdf with inputs parameters
%% Inputs
% - X: center of the class 
% - m: moments of the probability density
% - Fig: if equal to 1 plot the figure

Xt=(Xt-mean(Xt))./std(Xt);
cum=[0;1;skewness(Xt);kurtosis(Xt)-3];

[eCDF1,x1,~,~,~] = cdfcalc(Xt);
eCDF1=eCDF1(2:end-1);
x1=x1(1:end-1);
u1=-sqrt(2)*erfcinv(2.*eCDF1);

[~,~,n,x2] = histv(Xt,0);
eCDF2=cumtrapz(x2,n)./trapz(x2,n);
u2=-sqrt(2)*erfcinv(2.*eCDF2);
% plot(x1,eCDF1); hold on; plot(x2,eCDF2,'g')
x=x2;
u=u2;

DxDu=diff(x)./(diff(u));
DxDu=[DxDu DxDu(end)];

p = 1/sqrt(2*pi)*exp(-u.^2/2)./abs(DxDu);

if fig==1
   figure
   subplot(2,1,1); plot(u1,x1); hold on; plot(u2,x2,'g');
   subplot(2,1,2); plot(u,DxDu);
   figure
   subplot(2,1,1)
   histv(Xt,1); hold on; plot(x,p,'g');
   subplot(2,1,2);
   histv(Xt,11); hold on; semilogy(x,p,'g');
end
end

