function [p,F] = KG_Univariate(X,a,b,alpha,c)
%% Fonction
% compute the pdf with inputs parameters
%% Inputs
% - X: center of the class 
% - m: moments of the probability density
% - Fig: if equal to 1 plot the figure
z=zeros(length(X),1);
u=zeros(length(X),1);
p=zeros(length(X),1);
F=zeros(length(X),1);
DxDu=zeros(length(X),1);
for i=1:length(X)
    z(i)=1.5*b*(a+X(i)/alpha)-a^3;
    tmp1 = z(i)+sqrt(c+z(i)^2);
    tmp2 = z(i)-sqrt(c+z(i)^2);
    u(i)=(abs(tmp1))^(1/3)*sign(tmp1)+(abs(tmp2))^(1/3)*sign(tmp2)-a;
    DxDu(i)=alpha/b*(u(i)^2+2*a*u(i)+(b-1));
    
    p(i) = 1/sqrt(2*pi)*exp(-u(i)^2/2)/abs(DxDu(i));
    F(i) = normcdf(u(i),0,1);
end

uMode=-((2*a)/3) - (2^(1/3)*(3 - 4*a^2 + 3*b))/(3*(-36*a - 16*a^3 + 18*a*b + sqrt(...
    4*(3 - 4*a^2 + 3*b)^3 + (-36*a - 16*a^3 + 18*a*b)^2))^(1/3)) + (-36*a - 16*a^3 + 18*a*b + sqrt(...
   4*(3 - 4*a^2 + 3*b)^3 + (-36*a - 16*a^3 + 18*a*b)^2))^(1/3)/(3*2^(1/3));
[xMode] = KG_u2x(a,alpha,b,uMode);
    
end

