function [Gammaeb,Gamma3b,ml] = KG_LimitsGamma(Gamma3,Gammae,P)
DACO=LoadDACO;
if nargin==1
   Gammae=[]; P=0;
end

a=[-1800:0.1:-0.01 0.01:0.1:1800];
gamma3full=(6*sqrt(3).*a.*(15 + 16*a.^2 + 3.*a.^4))./(5 + 12*a.^2 + 3*a.^4).^(3/2);
gammaefull=(3*(385+1920.*a.^2+1326*a.^4+240*a.^6+9*a.^8))./(5+12*a.^2+3*a.^4).^2-3;
if P==1; plot(gammaefull,gamma3full,'color','k'); end%[0.880722 0.611041 0.142051]);%[0.3684 0.5067 0.7098])%'k')
if isempty(Gamma3) && isempty(Gammae)
    if P==1; plot(gammaefull,gamma3full,'color',DACO(8,:))%[0.3684 0.5067 0.7098])%'k')
            xlabel('\gamma_e','fontsize',11); ylabel('\gamma_3','fontsize',11); hold on
    end
    Gammaeb=[];
else
    if Gamma3~=0
        %clear a; a=-40:0.1:40;
        f1 = @(a)a_matchingG3(a,Gamma3);
        %options=optimset('TolX',1e-016,'Display','off');   % Option to display output
        tmp = abs(gamma3full-Gamma3);
        [idx idx] = min(tmp); %index of closest value
        closest = a(idx); %closest value
        clear a;
        [a,fval] = fsolve(f1,closest);%,options);
        Gammaeb=(3*(385+1920*a^2+1326*a^4+240*a^6+9*a^8))./(5+12*a^2+3*a^4)^2-3;
        [~,~,~,~,~,gammae_,ml] = KG_cumulants_inversion ([0 1 Gamma3 Gammaeb]');
        while ml<0
            [~,~,~,~,gamma3_,gammae_,ml] = KG_cumulants_inversion ([0 1 Gamma3 Gammaeb]');
            Gammaeb=1.01*Gammaeb;
        end
        Gammaeb=gammae_;
      
    else
       Gammaeb=0; 
       ml=0;
    end
    
    if Gammae~=0
        %clear a; a=-40:0.1:40;
        f2 = @(a)a_matchingGe(a,Gammae);
        %options=optimset('TolX',1e-016,'Display','off');   % Option to display output
        tmp = abs(gammaefull-Gammae);
        [idx idx] = min(tmp); %index of closest value
        closest = a(idx); %closest value
        clear a;
        [a,fval] = fsolve(f2,closest);%,options);
        Gamma3b=(6*sqrt(3)*a*(15 + 16*a^2 + 3*a^4))/(5 + 12*a^2 + 3*a^4)^(3/2);
    else
       Gamma3b=0; 
    end
end


if isempty(Gamma3)~=1; 
    if P==1; hold on; plot(Gammaeb,Gamma3,'r.'); end
end
if isempty(Gammae)~=1; 
    if P==1; hold on; plot(Gammae,Gamma3b,'g.'); end
end
end

function [F]= a_matchingG3(a,Gamma3)
    F=Gamma3-(6*sqrt(3)*a*(15 + 16*a^2 + 3*a^4))/(5 + 12*a^2 + 3*a^4)^(3/2);
end

function [F]= a_matchingGe(a,Gammae)
    F=Gammae-((3*(385+1920*a^2+1326*a^4+240*a^6+9*a^8))./(5+12*a^2+3*a^4)^2-3);
end