function [rhoUV] = KG_FittingRho (X,Y,rhoXY)

alp1=X.alpha; alp2=Y.alpha;
sig1=sqrt(X.K(2)); sig2=sqrt(Y.K(2));
a1=X.a; a2=Y.a;
b1=X.b; b2=Y.b;

if a1==0
    rhoXYmin=-alp2;
    rhoXYmax=alp2;
elseif a2==0
    rhoXYmin=-alp1;
    rhoXYmax=alp1;
else
    rhoXYmin=((-2 + 6*a1*a2 + -3*b1*b2)*alp1*alp2)/(3*b1*b2);
    rhoXYmax=((2 + 6*a1*a2 + 3*b1*b2)*alp1*alp2)/(3*b1*b2);
end

if (b1*b2/2-a1^2*a2^2)>0
    if rhoXY>=rhoXYmin && rhoXY<=rhoXYmax
        %disp(['Condition: ',num2str(b1*b2/2-a1^2*a2^2),' > 0'])
        %disp(['Correlation: ',num2str(rhoXYmin),' < ',num2str(rhoXY),' < ',num2str(rhoXYmax)])
        
        %     options=optimset('TolX',1e-016);   % Option to display output
        %     f = @(rho)cov_matching(rho,rhoXY,X,Y);
        %     [x,fval,exitflag] = fsolve(f,0,options);  % Call solver;
        %     rhoUV=x;
        
        if (a1+a2)==0
            rhoUV=rhoXY;
        elseif a1==0
            rhoUV=rhoXY/(alp2*sig1*sig2*(-1+b2+sig2^2)/b2);
        elseif a2==0
            rhoUV=rhoXY/(alp1*sig1*sig2*(-1+b1+sig1^2)/b1);
        else
            r=-a1^3*a2^3+3/4*a1*a2*b1*b2+(3*b1*b2*rhoXY*sig1*sig2)/(4*alp1*alp2); 
            c=(-a1^2*a2^2+(b1*b2)/2)^3;
            tmp1 = r+sqrt(c+r^2);
            tmp2 = r-sqrt(c+r^2);
            if (-a1^2*a2^2+(b1*b2)/2)>=0
                rhoUV=(abs(tmp1))^(1/3)*sign(tmp1)+(abs(tmp2))^(1/3)*sign(tmp2)-a1*a2;
            else
                rhoUV=nan;
            end            
        end
    else
        %disp('warning')
        rhoUV=sign(rhoXY)*rhoXYmax;
    end
else
    %disp('warning')
    rhoUV=rhoXY;
end
%disp([num2str(rhoUV),' = ',num2str(rhoUV_)])

function   [F] = cov_matching (rho,rhoXY,X,Y)
alp1=X.alpha; alp2=Y.alpha;
sig1=X.K(2); sig2=Y.K(2);
a1=X.a; a2=Y.a;
b1=X.b; b2=Y.b;
if b1==Inf
    F=rhoXY-(alp2*rho*sig1*sig2*(-1+b2+sig2^2)/b2);
else
    F=rhoXY-(alp1*alp2*(rho*sig1*sig2*(3*(-1+b2)*(-1+b1+sig1^2)+(-3+3*b1+(3+2*rho^2)*sig1^2)*sig2^2)+3*a1*a2*(1-sig2^2+sig1^2*(-1+(1+2*rho^2)*sig2^2))))/(3*b1*b2);
end
end
end