function [CMeanx,CModex,CVar] = KG_ConditionalStatistics(a,alpha,b,rhouv,v,c)

if a==0
    CMeanx = (v*rhouv);
else
    CMeanx = alpha/(3*b)*((v^3-3*v)*rhouv^3+3*a*(v^2-1)*rhouv^2+3*b*v*rhouv);
end

CVar   = -(1/(3*b^2))*alpha^2*(-1+rhouv^2)*(3*(-1+b)^2+12*a*v^3*rhouv^3+3*v^4*rhouv^4-6*(-1+a^2+b)*(-1+rhouv^2)+5*(-1+rhouv^2)^2+12*a*v*rhouv*(-1+b-2*(-1+rhouv^2))+6*v^2*rhouv^2*(-1+2*a^2+b-2*(-1+rhouv^2)));

%CSkewness  = (6*sqrt(3)*alp1^3*(a+v*rhouv)*(-1+rhouv^2)^2*(3* (-1+b)^2+12* a* v^3* rhouv^3+3* v^4* rhouv^4-4*(-3+a^2+3*b)*(-1+rhouv^2)+15*(-1+rhouv^2)^2+4*a*v*rhouv*(-3+3*b-8* (-1+rhouv^2))+2* v^2* rhouv^2 *(-3+6* a^2+3* b-8* (-1+rhouv^2))))/(b^3* (-1/b^2*alp1^2* (-1+rhouv^2)* (3* (-1+b)^2+12* a *v^3* rhouv^3+3* v^4* rhouv^4-6* (-1+a^2+b)* (-1+rhouv^2)+5* (-1+rhouv^2)^2+12* a *v *rhouv *(-1+b-2* (-1+rhouv^2))+6 *v^2 *rhouv^2 *(-1+2* a^2+b-2* (-1+rhouv^2))))^(3/2));


%% S: Mode
[CModeu] = ConditionalMode(a,b,rhouv,v,c,alpha);

if isinf(CModeu)~=1
    [CModex] = KG_u2x(a,alpha,b,CModeu);
else
    %disp('Numerical approximation')
    f = @(x) findmode(x,a,b,c,alpha,rhouv,v);
    x=0;
    CModex=fminbnd(f,-10,10);
end
end

function [CMode] = ConditionalMode(a,b,rhouv,v,c,alpha)
if a==0
    CMode=(v*rhouv);
else
%     CMode = 1/3*(-2* a + v *rhouv + (-3 + 4 *a^2 - 3 *b + ...
%         2 *a *v *rhouv + (6 + v^2) *rhouv^2)/(-8 *a^3 + ...
%         9 *a *(-2 + b) - 6 *a^2 *v *rhouv + 3 *a *(3 + v^2) *rhouv^2 + ...
%         v^3 *rhouv^3 + 9 *v *rhouv* (-2 + b + rhouv^2) + ...
%         1/2*sqrt(-4 *(-3 + 4 *a^2 - 3 *b + ...
%         2 *a *v *rhouv + (6 + v^2) *rhouv^2)^3 + ...
%         4*(a + v *rhouv)^2 *(-18 - 8 *a^2 + 9 *b + ...
%         2 *a *v *rhouv + (9 + v^2) *rhouv^2)^2))^( ...
%         1/3) + (-8 *a^3 + 9 *a* (-2 + b) - 6 *a^2 *v *rhouv + ...
%         3 *a *(3 + v^2) *rhouv^2 + v^3 *rhouv^3 + ...
%         9 *v *rhouv* (-2 + b + rhouv^2) + ...
%         1/2* sqrt(-4* (-3 + 4 *a^2 - 3 *b + ...
%         2 *a *v *rhouv + (6 + v^2) *rhouv^2)^3 + ...
%         4 *(a + v *rhouv)^2 *(-18 - 8 *a^2 + 9 *b + ...
%         2 *a *v *rhouv + (9 + v^2) *rhouv^2)^2))^(1/3));
    
%      k     = -2*(a+v*rhouv)*(-2*v*a*rhouv+8*a^2-9*b-(v^2+9)*rhouv^2+18);
%      eps   = -2*v*a*rhouv-4*a^2+3*b-(v^2+6)*rhouv^2+3;
%      CMode = 1/3*(rhouv*v-2*a) + nthroot(sqrt(k^2+4*eps^3)+k,3)/(3*2^(1/3)) - (2^(1/3)*eps)/(3*(nthroot(sqrt(k^2+4*eps^3)+k,3)));
     
     a2    = 2*a - v*rhouv;
     a1    = 1+b-2*a*v*rhouv-2*rhouv^2;
     a0    = 2*a+v*rhouv-b*v*rhouv-2*a*rhouv^2;
     Q     = (3*a1-a2^2)/9;
     R     = (9*a2*a1-27*a0-2*a2^3)/54;
     if Q>=0
         B     = nthroot(R+sqrt(Q^3+R^2),3)+nthroot(R-sqrt(Q^3+R^2),3);
         CMode = B-1/3*a2;
     else
         CMode=1/0;
     end
end
end

function [invpKG] = findmode(x,a,b,c,alpha,rhouv,v)
[u,Du] = KG_function2 (a,b,c,alpha,x);
pG=normpdf(u,rhouv*v,sqrt(1-rhouv^2));
pKG=1/abs(Du)*pG;
invpKG=1/pKG;
end

