function [X_,pKG,CMean,CMode] = KG_Conditional(cum_u,cum_v,rhoZ,X_,yvalue)

%% S: Cubic parameters
[U.a,U.b,U.alpha,U.c] = KG_cumulants_inversion (cum_u);
[V.a,V.b,V.alpha,V.c] = KG_cumulants_inversion (cum_v);

% options=optimset('TolX',1e-016);   % Option to display output
% f = @(rho)KG_cov_matching(rho,rhoZ,U,V);
% [x,fval] = fsolve(f,0,options);  % Call solver;
% rho=x;
U.K=cum_u;
V.K=cum_v;
[rho] = KG_FittingRho (U,V,rhoZ);
%% Preallocating
Ny=length(yvalue);
v=zeros(Ny,1);
CMean=zeros(Ny,1);
CMode=zeros(Ny,1);
pKG=zeros(length(X_),Ny);

for k=1:length(yvalue)
    [v(k)] = KG_function2 (V.a,V.b,V.c,V.alpha,yvalue(k));
    
    [CMean(k),CMode(k)] = KG_ConditionalStatistics(U.a,U.alpha,U.b,rho,v(k),U.c);
    
    %X_=sort(unique([X_ CMean CMode]));
    
    
    for i=1:length(X_)
        [u,Du] = KG_function2 (U.a,U.b,U.c,U.alpha,X_(i));
        pG=normpdf(u,rho*v(k),sqrt(1-rho^2));
        pKG(i,k)=1/abs(Du)*pG;
    end
end



end

function [B] = function1 (A)
B.A=A;
B.K(1)=mean(A);
B.K(2)=var(A-mean(A));
B.K(3)=skewness(A)*B.K(2)^(3/2);
B.K(4)=(kurtosis(A)-3)*B.K(2)^2;
[B.a,B.b,B.alpha,B.c] = KareemGurley_cumulants_inversion (B.K);
end





