function [pKG,X_,Y_] = KG_Bivariate(cum_u,cum_v,rhoxy,X_,Y_)

[U.a,U.b,U.alpha,U.c] = KG_cumulants_inversion (cum_u);
[V.a,V.b,V.alpha,V.c] = KG_cumulants_inversion (cum_v);

if 1==0
    options=optimset('TolX',1e-016);   % Option to display output
    f = @(rho)KG_cov_matching(rho,rhoxy,U,V,cum_u,cum_v);
    [x,fval] = fsolve(f,0,options);  % Call solver;
    rhouv=x;
else
    a1=U.a; a2=V.a; b1=U.b; b2=V.b; sig1=sqrt(cum_u(2)); sig2=sqrt(cum_v(2)); alp1=U.alpha; alp2=V.alpha;
    r=3/4*a1*a2*b1*b2-a1^3*a2^3+3*b1*b2*rhoxy*sig1*sig2/(4*alp1*alp2);
    q=(b1*b2/2-a1^2*a2^2)^3;
    tmp1 = r+sqrt(q+r^2);
    tmp2 = r-sqrt(q+r^2);
    if (b1*b2/2-a1^2*a2^2)>=0
        rhouv=(abs(tmp1))^(1/3)*sign(tmp1)+(abs(tmp2))^(1/3)*sign(tmp2)-a1*a2;
    else
        rhouv=nan;
    end
    %check
    %rhoxy=alp1*alp2/(sig1*sig2)*rhouv*(1+2*a1*a2/b1/b2*rhouv+2/(3*b1*b2)*rhouv^2)
end


pKG=zeros(length(X_),length(Y_));

for i=1:length(X_)
    for j=1:length(Y_)
        [u,Du] = KG_function2 (U.a,U.b,U.c,U.alpha,X_(i));
        [v,Dv] = KG_function2 (V.a,V.b,V.c,V.alpha,Y_(j));
        pG=1/(2*pi*sqrt(1-rhouv^2)) * exp(-1/(2*(1-rhouv^2)) * (u^2-2*rhouv*u*v+v^2));
        pKG(i,j)=1/abs(Du*Dv)*pG;
    end
end

end

function [B] = function1 (A)
B.A=A;
B.K(1)=mean(A);
B.K(2)=var(A-mean(A));
B.K(3)=skewness(A)*B.K(2)^(3/2);
B.K(4)=(kurtosis(A)-3)*B.K(2)^2;
[B.a,B.b,B.alpha,B.c] = KareemGurley_cumulants_inversion (B.K);
end



