function [XNOD,YNOD,FIXNOD,NNode,ELEMNOA,ELEMNOB,ELEMLEN,ELEMGEO,ELEMMAT,ELEMTYP,NElem,APPU,CORRES] = ...
    StructurePredefinie_Poutre (Interactif,NbTravees,Portee,NbElPortee)
%
% [XNOD,YNOD,FIXNOD,NNode,ELEMNOA,ELEMNOB,ELEMLEN,ELEMGEO,ELEMMAT,ELEMTYP,NElem,APPU] = ...
%    StructurePredefinie_Poutre (Interactif,NbTravees,Portee,NbElPortee)
%
% Structure prdfinie : poutre sur appuis multiples
% Possibilit de choisir des portes diffrentes !
%
% Exemple :
% NbTravees = 4;
% Portee = [5 10 15 10];
% NbElPortee = 5;

% INTRODUCTION DES DONNEES SI INTERACTIF
% ======================================
plot=0;
if plot; ifig=figure; end
if Interactif == 1
    NbTravees = input ('Nombre de traves ? ');
    Portee = input ('Portes des traves (ex: 1.7 ou [1.7 1.7 ... 1.7]) ? ');
    NbElPortee = input ('Nombre d''lments par porte ? ');        
end

if length(Portee) == 1
    Portee = Portee * ones(NbTravees,1);
elseif length(Portee) ~= NbTravees
    error ('Erreur introduction portes ... !')
end

% DEFINITION DES NOEUDS
% ======================
XAppu = [0];
for trav = 1:NbTravees
    XAppu = [XAppu sum(Portee(1:trav))];
end

% Coordonnes des noeuds
XNOD = [0];

for trav = 1:NbTravees
    x1=XAppu(trav); x2=XAppu(trav+1); DX = (x2-x1) / NbElPortee;
    XNOD = [XNOD; (x1+DX:DX:x2)'];
end

YNOD = zeros(size(XNOD));

NNode = length(XNOD);

% Appuis
FIXNOD = zeros(NNode,3);
for trav=1:NbTravees+1
    FIXNOD ((trav-1)*NbElPortee+1,1:2)=1;   
end

APPU=[];
for inoe=1:NNode
    for idof=1:3
        l=(inoe-1)*3+idof;
        if FIXNOD(inoe,idof)==1; APPU=[APPU l]; end
    end
end

if plot
    figure (ifig); hold on
    plot(XNOD,YNOD,'b.','MarkerSize',8)
    for i=1:NNode
        text(XNOD(i), YNOD(i),num2str(i))
    end
end

% DEFINITION DES ELEMENTS
% ========================

ELEMNOA = [1:NNode-1];
ELEMNOB = [2:NNode];

NElem = NNode-1;

for el=1:NElem
    ELEMLEN(el) = sqrt((XNOD(ELEMNOA(el))-XNOD(ELEMNOB(el)))^2+(YNOD(ELEMNOA(el))-YNOD(ELEMNOB(el)))^2);
end

ELEMGEO = ones(size(ELEMNOA));
ELEMMAT = ELEMGEO;

ELEMTYP = ones(size(ELEMNOA));  % TYPE = 1 : lment de poutre

if plot
    figure (ifig); hold on;axis equal
    for i=1:NElem
        plot([XNOD(ELEMNOA(i)) XNOD(ELEMNOB(i))], [YNOD(ELEMNOA(i)) YNOD(ELEMNOB(i))])
        %text(0.5*(XNOD(ELEMNOA(i))+XNOD(ELEMNOB(i))),0.5*(YNOD(ELEMNOA(i))+YNOD(ELEMNOB(i))),num2str(i))
    end
end

CORRES=[];
for i=1:3*NNode
    if isempty(find(APPU==i,1)); CORRES=[CORRES i]; end
end