function [alpha,beta] = RayleighDamping(omega1,omega2,ksi1,ksi2)
% Return the coefficients of the 2-point Rayleigh damping
% C = alpha.M + beta.K

beta = 2*(omega2*ksi2-omega1*ksi1)/(omega2^2-omega1^2);
alpha = 2*omega1*ksi1-beta*omega1^2;
