function K=RaideurBeam3(EA,EI,L)

% Forme la matrice de raideur lmentaire K d'un lment de poutre  2
% noeuds et 3 ddl par noeud (dpl axial, dpl transversal, rotation)
%
% ELEMENT A 6 DEGRES DE LIBERTE
% ------------------------------
% EA : Raideur extensionnelle
% EI : Raideur flexionnelle
% L   : Longueur de l'lment
%
%   DDL | Effort
%  -----+--------
%    1  | Noeud 1 : effort axial
%    2  | Noeud 1 : effort tranchant
%    3  | Noeud 1 : moment de flexion
%    4  | Noeud 2 : effort axial
%    5  | Noeud 2 : effort tranchant
%    6  | Noeud 2 : moment de flexion

V=EI/L^3;
A=EA/L;

K=[   A       0      0      -A      0      0     ;    
      0     12*V    6*V*L    0   -12*V   6*V*L   ;
      0    6*V*L  4*V*L^2    0   -6*V*L  2*V*L^2 ;
     -A       0       0      A      0      0     ;
      0    -12*V   -6*V*L    0    12*V   -6*V*L  ;
      0    6*V*L  2*V*L^2    0   -6*V*L  4*V*L^2 ];