function [X, Y, SURF2, NpSURF2, SizeELM2] = RafineMaillage2(X, Y, SURF, NpSURF, SizeELM, SUBDIV)
% Rafinement du maillage : reprsentation du second noyau de Volterra
% X,Y = coordonnes de noeuds (au nombre de NPTS)
% SURF : noeuds des lments (3 ou 4 noeuds -> triangles ou rectangles)
%        il y a NELM lments
% NpSURF = nombre de points dfinissant la surface lmentaire (3 ou 4)
% SUBDIV vecteur  NELM composantes
% SUBDIV(i) = 1 s'il faut subdiviser l'lment i, 0 sinon
%
% Pour la subdivision, chaque cot d'lment est divis en p.

NPTS = length(X);
NELM = size(SURF,1);
NELM2 = 0; 
for t=1:NELM
    if SUBDIV(t) <= 1 
        NELM2 = NELM2+1;
        SURF2(NELM2,1:4)=SURF(t,1:4);
        NpSURF2(NELM2)=NpSURF(t);
        SizeELM2(NELM2)=SizeELM(t);
    else
        p=SUBDIV(t);
        DX = (Y(SURF(t,2))-Y(SURF(t,3)))/p;
        NDEB = NPTS + 1;        
        % Ajout des noeuds            
        for i=1:p+1
            if i==1 | i==p+1; jmin=2;jmax=p; else jmin=1;jmax=p+1;end
            for j=jmin:jmax
                NPTS = NPTS + 1;
                X(NPTS) = X(SURF(t,1)) + DX * (j-1);
                Y(NPTS) = Y(SURF(t,3)) + DX * (i-1);
            end
        end
        % Ajout des lments
        for i=1:p
            for j=1:p
                NELM2 = NELM2 + 1;
                NpSURF2(NELM2)=4;
                SizeELM2(NELM2)=SizeELM(t)/p;
                if i==1 & j==1
                    SURF2(NELM2,1) = NDEB + p-1;  SURF2(NELM2,2) = NDEB + p;
                    SURF2(NELM2,3) = NDEB;        SURF2(NELM2,4) = SURF(t,4);
                elseif i==1 & j==p
                    SURF2(NELM2,1) = NDEB + 2*p-2;  SURF2(NELM2,2) = NDEB + 2*p-1;
                    SURF2(NELM2,3) = SURF(t,3);     SURF2(NELM2,4) = NDEB + p-2;
                elseif i==p & j==1
                    SURF2(NELM2,1) = SURF(t,1);   SURF2(NELM2,2) = NDEB + p^2+p-2;
                    SURF2(NELM2,3) = NDEB + p^2-2;SURF2(NELM2,4) = NDEB + p^2-3;
                elseif i==p & j==p
                    SURF2(NELM2,1) = NDEB + p^2+2*p-4;  SURF2(NELM2,2) = SURF(t,2);
                    SURF2(NELM2,3) = NDEB + p^2+p-3;    SURF2(NELM2,4) = NDEB + p^2+p-4;
                else
                    SURF2(NELM2,1) = NDEB + i*(p+1)-2+(j-1);  SURF2(NELM2,2) = NDEB + i*(p+1)-1+(j-1);
                    SURF2(NELM2,3) = NDEB + i*(p+1)-p-2+(j-1);    SURF2(NELM2,4) = NDEB + i*(p+1)-p-3+(j-1);
                    if i==1; SURF2(NELM2,3)=SURF2(NELM2,3)+1; SURF2(NELM2,4)=SURF2(NELM2,4)+1;end
                    if i==p; SURF2(NELM2,1)=SURF2(NELM2,1)-1; SURF2(NELM2,2)=SURF2(NELM2,2)-1;end                        
                end
            end
        end
    end
end
