function PlotDefo (X,CORRES,NDOF,AMPL,XNOD,YNOD,ELEMNOA,ELEMNOB,ELEMLEN,fig,clr,linewidth,markersize)
%
% PlotDEFO (X,CORRES,NDOF,AMPL,XNOD,YNOD,ELEMNOA,ELEMNOB,ELEMLEN,fig,clr,linewidth,markersize)
%
% X : dplacement des DDL non fixs
% N : nombre de ddl non fixs
% NDOF : Nombre total de ddl
% CORRES : tableau de correspondance entre ddl totaux et ddl libres
% AMPL : amplification du dplacement
% XNOD,YNOD : coordonnes des noeuds
% ELEMNOA,ELEMNOB : noeuds A et B des lments
% fig : numro de la figure dans laquelle il faut tracer le dessin
% clr : couleur

if nargin >= 10; figure (fig); end
if nargin < 11 ; clr = 'k'; end
if nargin < 12 ; linewidth = 1; end
if nargin < 13 ; markersize = 5; end


N = length(CORRES);
NNode = NDOF / 3;
NElem = length(ELEMNOA);

PREC = 10;

DEP = zeros(NDOF,1); DEP(CORRES(1:N))=X(1:N);
DEPX(1:NNode) = DEP(1:3:3*NNode-2);
DEPY(1:NNode) = DEP(2:3:3*NNode-1);
PHI (1:NNode) = DEP(3:3:3*NNode-0);

for i=1:NElem
    
    if ELEMLEN(i) ~= 0 % les lments finis de type ressort ont une longueur nulle !
        % cration d'un vecteur de dplacement aux bornes de l'lment
        Uglobal = [DEPX(ELEMNOA(i)); DEPY(ELEMNOA(i)); PHI(ELEMNOA(i)); ...
                DEPX(ELEMNOB(i)); DEPY(ELEMNOB(i)); PHI(ELEMNOB(i))];    
        % retour dans un systme d'axes local
        L = ELEMLEN(i);
        SinA = (YNOD(ELEMNOB(i))-YNOD(ELEMNOA(i))) / L; 
        CosA = (XNOD(ELEMNOB(i))-XNOD(ELEMNOA(i))) / L;
        ROT = [CosA -SinA 0; SinA CosA 0; 0 0 1];
        ROT = [ROT zeros(3,3);zeros(3,3) ROT];
        Ulocal = ROT' * Uglobal;
        
        % cration d'un vecteur avec les coordonnes dplaces de points
        % intermdiaires    

        u1 = Ulocal(1); v1 = Ulocal(2); phi1 = Ulocal(3);
        u2 = Ulocal(4); v2 = Ulocal(5); phi2 = Ulocal(6) ;   
        Uloc(1:2) = Ulocal(1:2); Uloc(2*PREC+1:2*PREC+2) = Ulocal(4:5);
        for j=1:PREC-1        
            xsl=j/PREC;
            % Fonctions d'interpolation pour dplacement axial
            a1 = 1-xsl;
            a2 = xsl;
            Uloc(2*j+1)=a1*u1+a2*u2;
            % Fonctions d'interpolation pour dplacement transversal
            f1 = 1-3*xsl^2+2*xsl^3;
            f2 = L*(xsl-2*xsl^2+xsl^3);
            f3=3*xsl^2-2*xsl^3;
            f4=L*(-xsl^2+xsl^3);
            Uloc(2*j+2)=f1*v1+f2*phi1+f3*v2+f4*phi2;
        end
        % retour dans un systme d'axes global
        ROT = [CosA -SinA; SinA CosA];
        for j=1:PREC+1        
            Uglob = ROT * Uloc(2*j-1:2*j)';
            DEPX_elm(j) = Uglob(1); DEPY_elm(j) = Uglob(2);
            alpha = (j-1)/PREC;
            CoordX(j) = (1-alpha) * XNOD(ELEMNOA(i)) + alpha * XNOD(ELEMNOB(i));
            CoordY(j) = (1-alpha) * YNOD(ELEMNOA(i)) + alpha * YNOD(ELEMNOB(i));       
        end
        
        if ischar(clr)
            plot(CoordX + AMPL*DEPX_elm, CoordY + AMPL*DEPY_elm,clr,'LineWidth',linewidth,'MarkerSize',markersize);hold on
        else
            plot(CoordX + AMPL*DEPX_elm, CoordY + AMPL*DEPY_elm,'Color',clr,'LineWidth',linewidth,'MarkerSize',markersize);hold on
        end
    end
end
axis equal

ImprMax=0;
if ImprMax == 1
    MaxX = max(abs(DEPX));
    for i=1:NNode
        if DEPX(i) == MaxX | DEPX(i) == -MaxX ; disp (['Dplacement horizontal max : noeud ' num2str(i) '  - Valeur : ' num2str(DEPX(i))]);end
    end
     MaxY = max(abs(DEPY));
    for i=1:NNode
        if DEPY(i) == MaxY | DEPY(i) == -MaxY ; disp (['Dplacement vertical max : noeud ' num2str(i) '  - Valeur : ' num2str(DEPY(i))]);end
    end
end   
