
function [dep,vit,acc,qsd] = ...
   NewmarkMDDL(m, k, c, p, DT, Nstep, a, d, depin, vitin)
   %
   % @NOMENCLATURE
   % [dep,vit,acc,qs] = NewmarkMDDL(m,k,c,p,DT,Nstep,a,d)
   %
   % @OUTPUT:
   % dep = structural displacements;
   % vit = structural velocities;
   % acc = structural accelerations;
   % qsd = quasi-static displacements;
   %
   % @PARAMETERS:
   % m     = mass matrix;
   % k     = stiffness matrix;
   % c     = damping matrix;
   % p     = loading;
   % DT    = time step;
   % Nstep = number of time steps;
   % a     = ??
   % d     = ??
   % depin = initial displacement field
   % vitin = initial velocity field
   %

   dim = length(k);

   if (size(p,1) > size(p,2))
      p = transpose(p);
   end

   dep = zeros(dim, Nstep);
   vit = zeros(dim, Nstep);
   acc = zeros(dim, Nstep);
   qsd = zeros(dim, Nstep);

   % initial displacement and velocity
   if (nargin > 8)
      dep(:, 1) = depin;
      vit(:, 1) = vitin;
   end

   if (nargin <= 8)
      a = .25;
      d = .50;
   end

   % initial acceleration
   acc(:, 1) = m \ ...
      (p(:, 1) - c*vit(:, 1) - k*dep(:, 1));


   akf = m / a / DT^2 + d / a / DT * c + k; % transfer matrix
   invakf = inv(akf);   % inverse transferm matrix
   invk   = inv(k);     % inverse stiffness matrix

   for i = 2 : Nstep

      dep(:, i) = ...
         invakf*(p(:,i)+m*(1/a/DT^2*dep(:,i-1)+1/a/DT*vit(:,i-1)+(1/2/a-1)*acc(:,i-1)) ...
         + c*(d/a/DT*dep(:,i-1) + (d/a-1)*vit(:,i-1) + DT/2*(d/a-2)*acc(:,i-1)));

      vit(:, i) = ...
         d/a/DT*(dep(:,i)-dep(:,i-1))+(1-d/a)*vit(:,i-1)+DT*(1-d/2/a)*acc(:,i-1);

      acc(:, i) = ...
         1/a/DT^2*(dep(:,i)-dep(:,i-1))-1/a/DT*vit(:,i-1)-(1/2/a-1)*acc(:,i-1);

      qsd(:, i) = invk * p(:,i);
   end

end