function M=MomentsStatistiques(signal,typ)
% V. Denoel 05/2003
%
% M=MomentsStatistiques(signal,typ)
% Calcule les moments statistiques jusqu' l'ordre 4 du signal
% typ = 1 : moments totaux
% typ = 2 : moments centrs
% typ = 3 : cumulants
% tpy = 4 : adimensionnels pour o3 et o4 (mean, std, skewness, excess)

% Moments totaux
for i=1:4;
    m(i)=1/length(signal)*sum(signal.^i);
end

% Moments centrs
mc(1)=0;
mc(2)=m(2)-m(1)^2;
mc(3)=m(3) - 3*m(2)*m(1) + 2*m(1)^3;
mc(4)=m(4) - 4*m(3)*m(1) + 6*m(2)*m(1)^2 - 3*m(1)^4;

% Cumulants
k(1)=m(1);
k(2)=m(2)-m(1)^2;
k(3)=m(3) - 3*m(2)*m(1) + 2*m(1)^3;
k(4)=m(4) - 4*m(3)*m(1) - 3*m(2)^2 + 12*m(2)*m(1)^2 - 6*m(1)^4;

% Adim
ad(1) = m(1);
ad(2) = sqrt(mc(2));
ad(3) = k(3) / (k(2)^(3/2));
ad(4) = k(4) / (k(2)^2);

switch typ
    case 1 ; M = m;
    case 2 ; M = mc;
    case 3 ; M = k;
    case 4 ; M = ad;
end